<?php
/**
 * Plugin Name: افزونه فاکتور و برچسب آدرس ووکامرس
 * Plugin URI: http://www.anshanweb.com
 * Description: این افزونه برای فروشگاه ساز قدرتمند ووکامرس می باشد و کار آن صدور فاکتور فروش و دریافت برچسب ادرس مشتری می باشد
 * Author: انشان وب
 * Author URI: http://www.anshanweb.com
 * Version: 6.6
 * Text Domain: woocommerce-factor-label
 * Domain Path: /i18n/languages/
 *
 * Copyright: (c) 2014-20216 anshanweb, Inc. (info@anshanweb.com)
 *
 * @package   woocommerce factor/Label
 * @author    anshanweb
 * @category  Plugin
 * @copyright Copyright (c) 2014-20216 anshanweb, Inc.
 */
if (!defined('ABSPATH')) exit; // Exit if accessed directly
// WC version check
static $wc_ver = "3.6";
/**
 * init_woocommerce_factor function.
 *
 * @access public
 * @return void
 */
class woofactor{
	public function woocommerce_factor_load_translation() {
    load_plugin_textdomain('woocommerce-factor', false, dirname(plugin_basename(__FILE__)) . '/i18n/languages');
}
}
require_once('includes/jdfs.php');
require_once('includes/function-admin-access.php');
require_once('includes/function-admin-cartabl.php');
require_once('includes/function-admin-setting.php');
require_once('includes/function-admin-scripts.php');
add_action('plugins_loaded', 'woocommerce_init_factor', 0);
function woocommerce_init_factor() {
	global $woocommerce,$wc_ver;
    register_activation_hook(__FILE__, 'woocommerce_factor_activate');
    //Add needed action and filter hooks
    add_action('init', 'woocommerce_factor_load_translation');
    add_action('admin_init', 'woocommerce_factor_window');
    add_action('init', 'woocommerce_factor_client_window');
    add_action('wp_enqueue_scripts', 'woocommerce_factor_client_scripts');
	if ( version_compare( $woocommerce->version, $wc_ver, ">=" ) ) {
			add_action('admin_menu', 'woocommerce_factor_admin_menu');
		}else{
		remove_action('admin_menu', 'woocommerce_factor_admin_menu');
	}
    add_action('add_meta_boxes', 'woocommerce_factor_add_box');
    add_action('admin_print_scripts-edit.php', 'woocommerce_factor_scripts');
    add_action('admin_print_scripts-post.php', 'woocommerce_factor_scripts');
    add_action('admin_enqueue_scripts', 'woocommerce_factor_admin_scripts');
    add_action('woocommerce_payment_complete', 'woocommerce_factor_send_email');
    add_action('woocommerce_payment_complete', 'woocommerce_factor_send_emailpack');
    add_action('woocommerce_order_status_on-hold_to_completed', 'woocommerce_factor_send_email');
    add_action('woocommerce_order_status_processing_to_completed', 'woocommerce_factor_getbarcode');
    if (get_option('woocommerce_factor_send_emailjob') == 'enabled') {
        add_action('woocommerce_order_status_processing', 'woocommerce_factor_send_email');
    }
    add_action('woocommerce_order_status_processing_to_completed', 'woocommerce_factor_send_email');
    add_action('woocommerce_order_status_on-hold_to_processing', 'woocommerce_factor_send_emailpack');
    add_action('woocommerce_order_status_failed_to_completed', 'woocommerce_factor_send_email');
    add_action('admin_footer', 'woocommerce_factor_bulk_admin_footer', 10);
    add_action('load-edit.php', 'woocommerce_factor_order_bulk_action');
    add_filter('woocommerce_my_account_my_orders_actions', 'woocommerce_factor_my_orders_action', 10, 2);
    add_filter('plugin_action_links_' . plugin_basename(__FILE__), 'woocommerce_factor_action_links');
    add_action('admin_init', 'woocommerce_factor_resend_email');
    add_action('admin_init', 'woocommerce_factor_resend_emailpack');
    add_filter('woocommerce_subscriptions_renewal_order_meta_query', 'woocommerce_factor_remove_subscription_renewal_order_meta', 10, 4);
    add_filter('woocommerce_subscriptions_renewal_order_meta_query', 'woocommerce_factor_remove_subscription_renewal_order_metas', 10, 5);
	add_action( 'admin_notices', 'notices_render' );
	add_action('admin_notices', 'checkver' );
				
}
/**
 * woocommerce_factor_load_translation function.
 *
 * @access public
 * @return void
 */
function woocommerce_factor_load_translation() {
    load_plugin_textdomain('woocommerce-factor', false, dirname(plugin_basename(__FILE__)) . '/i18n/languages');
}
function notices_render(){
	if ( ! class_exists( 'WooCommerce' ) ) {
				echo '<div class="notice notice-info is-dismissible">
             <p>افزونه ووفاکتور با موفقیت نصب و فعال سازی شده است. لطفا افزونه ووکامرس را نصب و فعال کنید</p>
         </div>';
			
			}
}
function checkver(){
	global $woocommerce,$wc_ver;
		if ( version_compare( $woocommerce->version, $wc_ver, ">=" ) ) {
			
		} else {
        echo '<div class="notice notice-error is-dismissible"><p>افزونه ووفاکتور نیازمند ووکامرس نسخه 3.6 به بالا است، لطفا ووکامرس خود را بروزرسانی و یا نصب کنید.</p></div>';
			 
}
}
/**
 * woocommerce_factor_activate function.
 *
 * @access public
 * @return void
 */
function woocommerce_factor_activate() {
    if (!get_option('woocommerce_factor_invoice_start')) {
        update_option('woocommerce_factor_invoice_start', '1');
    }
}
/**
 * woocommerce_factor_action_links function.
 *
 * @access public
 * @param mixed $links
 * @return void
 */
function woocommerce_factor_action_links($links) {
    $plugin_links = array('<a href="' . admin_url('admin.php?page=woocommerce_factor') . '">' . __('تنظیمات', 'woocommerce-factor') . '</a>',);
    return array_merge($plugin_links, $links);
}
/**
 * woocommerce_factor_bulk_admin_footer function.
 *
 * @access public
 * @return void
 */
function woocommerce_factor_bulk_admin_footer() {
    global $post_type;
    if ('shop_order' == $post_type) {
?>
		<script type="text/javascript">
		jQuery(document).ready(function() {
			jQuery('<option>').val('print_invoice').text('<?php _e('چاپ صورت حساب', 'woocommerce-factor') ?>').appendTo("select[name='action']");
			jQuery('<option>').val('print_invoice').text('<?php _e('چاپ صورت حساب', 'woocommerce-factor') ?>').appendTo("select[name='action2']");

			jQuery('<option>').val('print_packing').text('<?php _e('چاپ لیست سفارش', 'woocommerce-factor') ?>').appendTo("select[name='action']");
			jQuery('<option>').val('print_packing').text('<?php _e('چاپ لیست سفارش', 'woocommerce-factor') ?>').appendTo("select[name='action2']");

			jQuery('<option>').val('print_label').text('<?php _e('چاپ برچسب', 'woocommerce-factor') ?>').appendTo("select[name='action']");
			jQuery('<option>').val('print_label').text('<?php _e('چاپ برچسب', 'woocommerce-factor') ?>').appendTo("select[name='action2']");
		});
		</script>
		<?php
    }
}
/**
 * woocommerce_factor_my_orders_action function.
 *
 * Add HTML invoice button to my orders page so customers can view their invoices.
 * @access public
 * @param mixed $actions
 * @param mixed $order
 * @return void
 */
function woocommerce_factor_my_orders_action($actions, $order) {
	$getfactore = 'getfactor';
      $actions[$getfactore] = array('url' => wp_nonce_url(site_url('?type=print_invoice&print_factor_invoice=true&post=' . $order->get_id()), 'client-print-factor'), 'name' => __('فاکتور', 'woocommerce-factor'), 'target' => '_blank', 'style' => 'margin-right:5px;');
    return $actions;

}
// Jquery script
add_action( 'woocommerce_after_account_orders', 'action_after_account_orders_js');
function action_after_account_orders_js($actions) {
   $getfactore = 'getfactor';
    ?>
    <script>
    jQuery(function($){
        $('a.<?php echo $getfactore; ?>').each( function(){
            $(this).attr('target','_blank');
        })
    });
    </script>
    <?php
}
/**
 * woocommerce_factor_add_box function.
 *
 * Add the meta box on the single order page
 * @access public
 * @return void
 */
function woocommerce_factor_add_box() {
    add_meta_box('woocommerce-factor-box', __('عملیات فاکتور', 'woocommerce-factor'), 'woocommerce_factor_create_box_content', 'shop_order', 'side', 'default');
}
/**
 * woocommerce_factor_create_box_content function.
 *
 * Create the meta box content on the single order page
 * @access public
 * @return void
 */
function woocommerce_factor_create_box_content() {
    global $post_id;
?>
<style>
    .btn {
      display: inline-block;
    line-height: normal;
    margin: 8px;
    padding: 5px;
    font-size: 15px;
    position: relative;
    border-radius: 2px;
    text-decoration: none;
    color: #3e3f43;
    float: right;
    margin-left: 5px;
    min-width: 39%;
}
    .btn img{vertical-align: middle;}
    .btn-border-rev {
      background-color: #e5e5e5 !important;
    border: 1px solid #e5e5e5 !important;
    color: #6d6c6c !important;
}
.btn-border-rev:before, .btn-border-rev:after {
  content: '';
  border-style: solid;
  position: absolute;
  z-index: 5;
  border-radius: 3px;
  -webkit-box-sizing: content-box;
          box-sizing: content-box;
}
.btn-border-rev:before {
  width: 0;
  height: 100%;
  border-width: 1px 0 1px 0;
  top: -1px;
  right: 0;
}
.btn-border-rev:after {
  width: 100%;
  height: 0;
  border-width: 0 1px 0 1px;
  bottom: 0;
  left: -1px;
  -webkit-transition-delay: 0.05s;
          transition-delay: 0.05s;
}
.btn-border-rev:hover {
  background-color: transparent;
}
.btn-border-rev:hover:before {
  width: 100%;
}
.btn-border-rev:hover:after {
  height: 100%;
}
.btn-border-rev.btn-green:before, .btn-border-rev.btn-green:after {
  border-color: #2ecc71;
}
.btn-border-rev.btn-green:hover {
  color: #3e3f43;
}
</style>
	<table class="form-table">
		<?php if (get_post_meta($post_id, '_factor_invoice_number', true)) { ?>
		<tr>
			<td style="text-align: center"><?php _e('صورت حساب: #', 'woocommerce-factor');
        echo get_post_meta($post_id, '_factor_invoice_number', true); ?></td>
		</tr>


<?php
    } ?>
		<?php if (get_option('woocommerce_factor_getfactorco') == 'enabled') {
        if (get_post_meta($post_id, 'factorres', true)) { ?>
		<tr>
			<td style="color: #155724;border: 1px solid #eee;background-color: #d4edda;border-color: #c3e6cb;padding: 5px;text-align: center">پذیرش دریافت برگه <span style="margin-right: -3px;font-size: 10px;">ی</span> فاکتور</td>
		</tr>


<?php
        } else { ?>
		<tr>
			<td style="border: 1px solid #eee;color: #721c24;background-color: #f8d7da;border-color: #f5c6cb;padding: 5px;text-align: center">عدم پذیرش دریافت برگه <span style="margin-right: -3px;font-size: 10px;">ی</span> فاکتور</td>
		</tr>
		<?php
        }
    } ?>
		<tr>
			<td><a class="btn btn-green btn-border-rev" data-tip="<?php esc_attr_e('چاپ صورت حساب', 'woocommerce-factor'); ?>" href="<?php echo wp_nonce_url(admin_url('?print_factor=true&post=' . $post_id . '&type=print_invoice'), 'print-factor'); ?>" target="_blank"><img src="<?php echo woocommerce_factor_get_plugin_url() . '/assets/images/printer.svg'; ?>" alt="<?php esc_attr_e('فاکتور', 'woocommerce-factor'); ?>" width="18"> <?php _e('فاکتور', 'woocommerce-factor'); ?></a>
				<a class="btn btn-green btn-border-rev" href="<?php echo wp_nonce_url(admin_url('?print_factor=true&post=' . $post_id . '&type=print_packing'), 'print-factor'); ?>" target="_blank"><img src="<?php echo woocommerce_factor_get_plugin_url() . '/assets/images/box.svg'; ?>" alt="<?php esc_attr_e('چاپ لیست سفارش List', 'woocommerce-factor'); ?>" width="18"> <?php _e('لیست انبار', 'woocommerce-factor'); ?></a><a class="btn btn-green btn-border-rev" href="<?php echo wp_nonce_url(admin_url('?print_factor=true&post=' . $post_id . '&type=print_label'), 'print-factor'); ?>" target="_blank"><img src="<?php echo woocommerce_factor_get_plugin_url() . '/assets/images/label.svg'; ?>" alt="<?php esc_attr_e('چاپ برچسب', 'woocommerce-factor'); ?>" width="18"> <?php _e('برچسب', 'woocommerce-factor'); ?></a>
				<?php if (get_option('woocommerce_factor_send_email') == 'enabled') { ?>
				<a class="btn btn-green btn-border-rev" href="<?php echo wp_nonce_url(admin_url('?email_factor=true&post=' . $post_id), 'email-factor'); ?>" target="_blank"><img src="<?php echo woocommerce_factor_get_plugin_url() . '/assets/images/mail.svg'; ?>" alt="<?php esc_attr_e('ارسال فاکتور به ایمیل', 'woocommerce-factor'); ?>" width="18"> <?php _e('ارسال فاکتور', 'woocommerce-factor'); ?></a>
				<?php
    } ?>
                <?php if (get_option('woocommerce_factor_send_emailpack') == 'enabled') { ?>
				<a class="btn btn-green btn-border-rev" href="<?php echo wp_nonce_url(admin_url('?email_factorpack=true&post=' . $post_id), 'email-factorpack'); ?>" target="_blank"><img src="<?php echo woocommerce_factor_get_plugin_url() . '/assets/images/mail.svg'; ?>" alt="<?php esc_attr_e('ارسال فاکتور به ایمیل', 'woocommerce-factor'); ?>" width="18"> <?php _e('ارسال لیست انبار', 'woocommerce-factor'); ?></a>
				<?php
    } ?>
				</td>
        </tr>
	</table>
	<?php
}

/**
 * woocommerce_factor_order_items_table function.
 *
 * Output items for display
 * @access public
 * @param mixed $order
 * @param mixed $show_price (default: FALSE)
 * @return void
 */
function woocommerce_factor_order_items_table($order, $show_price = true) {
	if(isset($_GET['type'])){
    $action = $_GET['type'];
	}
    $return = '';
	$context='view';
    $totalv = 0;
    $qtysub = 0;
    $subtt = 0;
    $suboff = 0;
    foreach ($order->get_items() as $item) {
        // get the product; if this variation or product has been deleted, this will return null...
        $_product = $order->get_product_from_item($item);
		$item_id = $_product->get_id();
        $sku = $variation = $vahed = $idpacking = '';
        if ($_product) $sku = $_product->get_sku();
        $vahed = get_post_meta($order->get_id(), 'vahed', true);
        $idpacking = get_post_meta($order->get_id(), 'idpacking', true);
        //$item_meta = new WC_Order_Item_Product($item['variation_id']);
		// grab the meta from the item
                    $meta_data = $item->get_formatted_meta_data( '', true );

                    if( $_product->is_type('variation') ){
		
                        // Get the variation attributes
                      $variation_attributes = $_product->get_variation_attributes();
                      // Loop through each selected attributes
                      foreach($variation_attributes as $attribute_taxonomy => $term_slug ){
                          // Get product attribute name or taxonomy
                          $taxonomy = str_replace('attribute_', '', $attribute_taxonomy );
                          // The label name from the product attribute
                          $attribute_name = str_replace('pa_', '',wc_attribute_label( $taxonomy, $_product ));
                          // The term name (or value) from this attribute
                          if( taxonomy_exists($taxonomy) ) {
                              $variation .= '</br>'.$attribute_name. ' : ' .get_term_by( 'slug', $term_slug, $taxonomy )->name;
                          } else {
                              $variation .= '</br>'.$attribute_name. ' : ' . wc_sanitize_taxonomy_name($term_slug)  ; // For custom product attributes
                          }
                      }
                      
                      
                      $variation = $variation;
                  } else {
                      // Loop though the data array to set the fields
                                  foreach ( $meta_data as $meta_id => $meta ) {
              
                                      // grab the key and strip anything that may be junky
                                      $field_display_label =  wp_kses_post($meta->display_key);
                                      // grab the key value and stip anything that may be junky, as well as ensuring things are properly wrapped
                                      $field_display_value = wp_kses_post( force_balance_tags( $meta->display_value ) );
                                      // by default, the key value has p tags wrapping it, so lets remove those for now
                                      $field_display_value = str_replace('<p>','',$field_display_value);
                                      $field_display_value = str_replace('</p>','',$field_display_value);
              
                                      $variation .= '<br>'. $field_display_label .' : '. $field_display_value ;
              
                                  }
                      $variation = $variation;
                  }
		
		
        $image = wp_get_attachment_image_src(get_post_thumbnail_id($_product->get_image_id()), 'single-post-thumbnail');
        $return.= '<tr>';
		if(woocommerce_factor_theme() != "4"){
        if (woocommerce_factor_theme() == "5" || woocommerce_factor_theme() == "6") {
			if ($action == 'print_packing') {
            $return.= '<td align="center" valign="middle" style="border: 1px solid #797878;text-align:center; padding: 3px;">' . $sku . '</td>';
        }
        } else {
            $return.= '<td align="center" valign="middle" style="border: 1px solid #797878;text-align:center; padding: 3px;">' . $sku . '</td>';
        }
		
        if ($action != 'print_label' && $action != 'print_invoice' && $action != 'print_packing' ) {
            $return.= '<td align="center" valign="middle" style="border: 1px solid #797878;text-align:center; padding: 3px;">' . $sku . '</td>';
        }
		} else{
			$return.= '<td align="center" valign="middle" style="border: 1px solid #797878;text-align:center; padding: 3px;"></td>';
		}

        if ($action == 'print_packing' || $action == 'email_packing') {
            if (get_option('woocommerce_factor_idpacking') == 'enabled') {
                $return.= '<td align="center" valign="middle" style="border: 1px solid #797878;text-align:center; padding: 3px;">' . $idpacking . '</td>';
            }
			
        }
		if (class_exists('WeDevs_Dokan')) {
        $seller = get_post_field( 'post_author', $item_id);
        $author  = get_user_by( 'id', $seller );
        $vendor = dokan()->vendor->get( $seller );

        $store_info = dokan_get_store_info( $author->ID );

        if ( !empty( $store_info['store_name'] ) ) {
		if(woocommerce_factor_theme() != "4"){
        $return.= '<td style="border: 1px solid #797878;text-align:right; padding: 3px;">';
        if (get_option('woocommerce_factor_productimg') == 'enabled') {
            $return.= '<img class="thumb" src="' . $_product->get_image() ;
        }
		
        $return.= $_product->get_name().'</br>فروشنده : '.$vendor->get_shop_name(). $variation .'</td>';
		} else{
			$return.= '<td align="center" valign="middle" style="border: 1px solid #797878;text-align:right; padding: 3px;">';
        $return.= apply_filters('woocommerce_order_product_title', $item['name'], $_product).'</br>فروشنده : '.$vendor->get_shop_name() . '</br>'.$sku.'</td>';
		}
		} else {
			if(woocommerce_factor_theme() != "4"){
        $return.= '<td style="border: 1px solid #797878;text-align:right; padding: 3px;">';
        if (get_option('woocommerce_factor_productimg') == 'enabled') {
            $return.= '<img class="thumb" src="' . $_product->get_image() ;
        }
		
        $return.= $_product->get_name() . $variation .'</td>';
		} else{
			$return.= '<td align="center" valign="middle" style="border: 1px solid #797878;text-align:right; padding: 3px;">';
        $return.= apply_filters('woocommerce_order_product_title', $item['name'], $_product) . '</br>'.$sku.'</td>';
		}
		}
		} else{
			if(woocommerce_factor_theme() != "4"){
        $return.= '<td style="border: 1px solid #797878;text-align:right; padding: 3px;">';
        if (get_option('woocommerce_factor_productimg') == 'enabled') {
            $return.= '<img class="thumb" src="' . $_product->get_image() ;
        }
		
        $return.= $_product->get_name() . $variation .'</td>';
		} else{
			$return.= '<td align="center" valign="middle" style="border: 1px solid #797878;text-align:right; padding: 3px;">';
        $return.= apply_filters('woocommerce_order_product_title', $item['name'], $_product) . '</br>'.$sku.'</td>';
		}
		}
        if (get_option('woocommerce_factor_vaheds') == 'enabled') {
            $return.= '<td align="center" valign="middle" style="border: 1px solid #797878;text-align:center; padding: 3px;">' . $vahed . '</td>';
        }
        if ($show_price) {
            if (!$order->get_prices_include_tax( $context )) {
                $pricefi = $order->get_line_subtotal($item) / $item['qty'];
            } else {
                $pricefi = $order->get_line_subtotal($item) / $item['qty'];
            }
			if(woocommerce_factor_theme() != "4"){
            if (get_option('woocommerce_factor_offo') == 'enabled') {
                if ($_product->get_sale_price() != "") {
                    
                        $return.= '<td align="center" valign="middle" class="item-vs" style="border: 1px solid #797878;text-align:center; padding: 3px;"><del>' . wc_price($_product->get_regular_price()) . '</del><ins style="text-decoration: none;margin-right:10px;">' . wc_price($pricefi) . '<ins></td>';
                    
                } else {
                    
                        $return.= '<td align="center" valign="middle" class="item-vs" style="border: 1px solid #797878;text-align:center; padding: 3px;">' . wc_price($pricefi) . '</td>';
                    
                }
            } else {
                
                    $return.= '<td align="center" valign="middle" class="item-vs" style="border: 1px solid #797878;text-align:center; padding: 3px;">' . wc_price($pricefi) . '</td>';
                
            }
        
        $return.= '<td align="center" valign="middle" class= "item-q" style="border: 1px solid #797878;text-align:center; padding: 3px;">' . $item['qty'] . '</td>';
        if (get_option('woocommerce_factor_offo') == 'enabled') {
			if($_product->get_regular_price() !=""){
            if ($show_price) {
                $off = ($_product->get_regular_price() - $pricefi) * $item['qty'];
                $return.= '<td align="center" valign="middle" class="item-vs" style="border: 1px solid #797878;text-align:center; padding: 3px;">' . wc_price($off) . '</td>';
            }
			} else{
				  $return.= '<td align="center" valign="middle" class="item-vs" style="border: 1px solid #797878;text-align:center; padding: 3px;">' . wc_price(0) . '</td>';
			}
        }
		} else{
				if($_product->get_regular_price() !=""){
				$off = ($_product->get_regular_price() - $pricefi) * $item['qty'];
				} else{
					$off = 0;
				}
			$return.= '<td align="center" valign="middle" class= "item-q" style="border: 1px solid #797878;text-align:center; padding: 3px;vertical-align: middle;">' . $item['qty'] . '</td>';
				if ($_product->get_sale_price() != "") {
			$return.= '<td align="center" valign="middle" class="item-vs" style="border: 1px solid #797878;text-align:center; padding: 3px;"><ins style="text-decoration: none">' . wc_price($_product->get_regular_price()) . '</ins><hr style="border-top: 1px solid #595959;"><ins style="text-decoration: none;margin-right:10px;">-'.wc_price($off).'</ins></td>';
				} else{
					$return.= '<td align="center" valign="middle" class="item-vs" style="border: 1px solid #797878;text-align:center; padding: 3px;">' . wc_price($pricefi) . '</td>';
				}
			
		}
		}
        if ($show_price) {
            $return.= '<td align="center" valign="middle" style="border: 1px solid #797878;text-align:center; padding: 3px;vertical-align: middle;">';
            if (!$order->get_prices_include_tax( $context )) {
                if (class_exists('WC_Deposits')) {
                    // item price
                    $item_total = $order->get_line_total($item);
                    $item_price = '<span class="price">' . $order->get_formatted_line_subtotal($item) . '</span>';
                    // handle refunds
                    if ($order->get_total_refunded_for_item($item_id) > 0) {
                        $refund_total = $order->get_total_refunded_for_item($item_id);
                        $item_price = '<span class="price"><del>' . $order->get_formatted_line_subtotal($item) . '</del></span> <span class="refund-price">' . wc_price(max(0, $item_total - $refund_total), array('currency' => $order->get_order_currency())) . '</span>';
                    }
                    $ex_tax_label = ($order->get_prices_include_tax( $context )) ? 1 : 0;
                    $return.= $item_price;
                } else {
                    $ex_tax_label = ($order->get_prices_include_tax( $context )) ? 1 : 0;
                    $return.= wc_price($order->get_line_subtotal($item), array('ex_tax_label' => $ex_tax_label));
                }
            } else {
                if (class_exists('WC_Deposits')) {
                    // item price
                    $item_total = $order->get_line_total($item);
                    $item_price = '<span class="price">' . $order->get_formatted_line_subtotal($item) . '</span>';
                    // handle refunds
                    if ($order->get_total_refunded_for_item($item_id) > 0) {
                        $refund_total = $order->get_total_refunded_for_item($item_id);
                        $item_price = '<span class="price"><del>' . $order->get_formatted_line_subtotal($item) . '</del></span> <span class="refund-price">' . wc_price(max(0, $item_total - $refund_total), array('currency' => $order->get_order_currency())) . '</span>';
                    }
                    $ex_tax_label = ($order->get_prices_include_tax( $context )) ? 1 : 0;
                    $return.= $item_price;
                } else {
                    $return.= wc_price($order->get_line_subtotal($item));
                }
            }
            $return.= '
			</td>';
        } else {
			 $return.= '<td align="center" valign="middle" class= "item-q" style="border: 1px solid #797878;text-align:center; padding: 3px;">' . $item['qty'] . '</td>';
            $return.= '<td align="center" align="center" valign="middle" style="border: 1px solid #797878;text-align:center; padding: 3px;">';
            $return.= ($_product && $_product->get_weight()) ? $_product->get_weight() * $item['qty'] . ' ' . get_option('woocommerce_weight_unit') : __('n/a', 'woocommerce-factor');
            $return.= '</td>';
        }
        $return.= '</tr>';
		if ($show_price) {
        $qtysub = $qtysub + $item['qty'];
        $totalv = $totalv + $pricefi;
        if (!$order->get_prices_include_tax( $context )) {
            $subtt = $subtt + $order->get_line_subtotal($item);
        } else {
            $subtt = $subtt + $order->get_line_subtotal($item);
        }
        $suboff = $suboff + $off;
		}
    }
    $subvahed = $totalv;
    if ($action == 'print_invoice') {
        if (woocommerce_factor_theme() == "4") {
            $return.= '<tr>';
			$return.= '<th colspan="5" style="border: 1px solid #797878;text-align:center; padding: 3px;">جمع اقلام خرید شده در فاکتور :  '.$qtysub.'</td></tr>';
			$return.= '<tr><th colspan="5" style="border: 1px solid #797878;text-align:center; padding: 3px;background: #000;color:#fff;">سود شما از این خرید :  '.wc_price($suboff).'</td></tr>';
            
        }
        if (woocommerce_factor_theme() == "5") {
            $return.= '<tfoot><tr>';
            if ((get_option('woocommerce_factor_offo') == 'enabled') && (get_option('woocommerce_factor_vaheds') == 'enabled')) {
                $return.= '<th colspan="3" style="border: 1px solid #797878;text-align:center; padding: 3px;">جمع موارد</td>';
            } elseif ((get_option('woocommerce_factor_offo') == 'enabled') && (get_option('woocommerce_factor_vaheds') != 'enabled')) {
                $return.= '<th colspan="2" style="border: 1px solid #797878;text-align:center; padding: 3px;">جمع موارد</td>';
            } elseif ((get_option('woocommerce_factor_offo') != 'enabled') && (get_option('woocommerce_factor_vaheds') == 'enabled')) {
                $return.= '<th colspan="3" style="border: 1px solid #797878;text-align:center; padding: 3px;">جمع موارد</td>';
            } elseif ((get_option('woocommerce_factor_offo') != 'enabled') && (get_option('woocommerce_factor_vaheds') != 'enabled')) {
                $return.= '<th colspan="2" style="border: 1px solid #797878;text-align:center; padding: 3px;">جمع موارد</td>';
            }
            $return.= '<th style="border: 1px solid #797878;text-align:center; padding: 3px;">' . wc_price($subvahed) . '</td>';
            $return.= '<th style="border: 1px solid #797878;text-align:center; padding: 3px;">' . $qtysub . '</td>';
            if (get_option('woocommerce_factor_offo') == 'enabled') {
				
                $return.= '<th style="border: 1px solid #797878;text-align:center; padding: 3px;">' . wc_price($suboff) . '</td>';
            }
            $return.= '<th style="border: 1px solid #797878;text-align:center; padding: 3px;">' . wc_price($subtt) . '</td>';
            $return.= '</tr></tfoot>';
        }
        if (woocommerce_factor_theme() == "3") {
            $return.= '<tfoot>';
            $return.= '<tr>';
            if ((get_option('woocommerce_factor_offo') == 'enabled') && (get_option('woocommerce_factor_vaheds') == 'enabled')) {
                $return.= '<th colspan="3" style="border: 1px solid #ddd;text-align:center; padding: 3px;">جمع موارد</td>';
            } elseif ((get_option('woocommerce_factor_offo') == 'enabled') && (get_option('woocommerce_factor_vaheds') != 'enabled')) {
                $return.= '<th colspan="2" style="border: 1px solid #ddd;text-align:center; padding: 3px;">جمع موارد</td>';
            } elseif ((get_option('woocommerce_factor_offo') != 'enabled') && (get_option('woocommerce_factor_vaheds') == 'enabled')) {
                $return.= '<th colspan="3" style="border: 1px solid #ddd;text-align:center; padding: 3px;">جمع موارد</td>';
            } elseif ((get_option('woocommerce_factor_offo') != 'enabled') && (get_option('woocommerce_factor_vaheds') != 'enabled')) {
                $return.= '<th colspan="2" style="border: 1px solid #ddd;text-align:center; padding: 3px;">جمع موارد</td>';
            }
            $return.= '<th style="border: 1px solid #ddd;text-align:center; padding: 3px;">' . wc_price($subvahed) . '</td>';
            $return.= '<th style="border: 1px solid #ddd;text-align:center; padding: 3px;">' . $qtysub . '</td>';
            if (get_option('woocommerce_factor_offo') == 'enabled') {
                $return.= '<th style="border: 1px solid #ddd;text-align:center; padding: 3px;">' . wc_price($suboff) . '</td>';
            }
            $return.= '<th style="border: 1px solid #ddd;text-align:center; padding: 3px;">' . wc_price($subtt) . '</td>';
            $return.= '</tr></tfoot>';
        }
        if (woocommerce_factor_theme() == "") {
            $return.= '<tfoot>';
            $return.= '<tr>';
            if (get_option('woocommerce_factor_offo') == 'enabled') {
                $return.= '<th colspan="2" style="border: 1px solid #797878;text-align:center; padding: 3px;">جمع موارد</td>';
            } else {
                $return.= '<th colspan="2" style="border: 1px solid #797878;text-align:center; padding: 3px;">جمع موارد</td>';
            }
            $return.= '<th style="border: 1px solid #797878;text-align:center; padding: 3px;">' . wc_price($subvahed) . '</td>';
            $return.= '<th style="border: 1px solid #797878;text-align:center; padding: 3px;">' . $qtysub . '</td>';
            if (get_option('woocommerce_factor_offo') == 'enabled') {
                $return.= '<th style="border: 1px solid #797878;text-align:center; padding: 3px;">' . wc_price($suboff) . '</td>';
            }
            $return.= '<th style="border: 1px solid #797878;text-align:center; padding: 3px;">' . wc_price($subtt) . '</td>';
            $return.= '</tr></tfoot>';
        }
        if (woocommerce_factor_theme() == "1") {
            $return.= '<tfoot>';
            $return.= '<tr>';
            if ((get_option('woocommerce_factor_offo') == 'enabled') && (get_option('woocommerce_factor_vaheds') == 'enabled')) {
                $return.= '<th colspan="3" style="border: 1px solid #797878;text-align:center; padding: 3px;">جمع موارد</td>';
            } elseif ((get_option('woocommerce_factor_offo') == 'enabled') && (get_option('woocommerce_factor_vaheds') != 'enabled')) {
                $return.= '<th colspan="2" style="border: 1px solid #797878;text-align:center; padding: 3px;">جمع موارد</td>';
            } elseif ((get_option('woocommerce_factor_offo') != 'enabled') && (get_option('woocommerce_factor_vaheds') == 'enabled')) {
                $return.= '<th colspan="3" style="border: 1px solid #797878;text-align:center; padding: 3px;">جمع موارد</td>';
            } elseif ((get_option('woocommerce_factor_offo') != 'enabled') && (get_option('woocommerce_factor_vaheds') != 'enabled')) {
                $return.= '<th colspan="2" style="border: 1px solid #797878;text-align:center; padding: 3px;">جمع موارد</td>';
            }
            $return.= '<th style="border: 1px solid #797878;text-align:center; padding: 3px;">' . wc_price($subvahed) . '</td>';
            $return.= '<th style="border: 1px solid #797878;text-align:center; padding: 3px;">' . $qtysub . '</td>';
            if (get_option('woocommerce_factor_offo') == 'enabled') {
                $return.= '<th style="border: 1px solid #797878;text-align:center; padding: 3px;">' . wc_price($suboff) . '</td>';
            }
            $return.= '<th style="border: 1px solid #797878;text-align:center; padding: 3px;">' . wc_price($subtt) . '</td>';
            $return.= '</tr></tfoot>';
        }
        if (woocommerce_factor_theme() == "2") {
            $return.= '<tfoot>';
            $return.= '<tr>';
            if ((get_option('woocommerce_factor_offo') == 'enabled') && (get_option('woocommerce_factor_vaheds') == 'enabled')) {
                $return.= '<th colspan="3" style="border: 1px solid #797878;text-align:center; padding: 3px;">جمع موارد</td>';
            } elseif ((get_option('woocommerce_factor_offo') == 'enabled') && (get_option('woocommerce_factor_vaheds') != 'enabled')) {
                $return.= '<th colspan="2" style="border: 1px solid #797878;text-align:center; padding: 3px;">جمع موارد</td>';
            } elseif ((get_option('woocommerce_factor_offo') != 'enabled') && (get_option('woocommerce_factor_vaheds') == 'enabled')) {
                $return.= '<th colspan="3" style="border: 1px solid #797878;text-align:center; padding: 3px;">جمع موارد</td>';
            } elseif ((get_option('woocommerce_factor_offo') != 'enabled') && (get_option('woocommerce_factor_vaheds') != 'enabled')) {
                $return.= '<th colspan="2" style="border: 1px solid #797878;text-align:center; padding: 3px;">جمع موارد</td>';
            }
            $return.= '<th style="border: 1px solid #797878;text-align:center; padding: 3px;">' . wc_price($subvahed) . '</td>';
            $return.= '<th style="border: 1px solid #797878;text-align:center; padding: 3px;">' . $qtysub . '</td>';
            if (get_option('woocommerce_factor_offo') == 'enabled') {
                $return.= '<th style="border: 1px solid #797878;text-align:center; padding: 3px;">' . wc_price($suboff) . '</td>';
            }
            $return.= '<th style="border: 1px solid #797878;text-align:center; padding: 3px;">' . wc_price($subtt) . '</td>';
            $return.= '</tr></tfoot>';
        }
        if (woocommerce_factor_theme() == "0") {
            $return.= '<tfoot>';
            $return.= '<tr>';
            if ((get_option('woocommerce_factor_offo') == 'enabled') && (get_option('woocommerce_factor_vaheds') == 'enabled')) {
                $return.= '<th colspan="3" style="border: 1px solid #797878;text-align:center; padding: 3px;">جمع موارد</td>';
            } elseif ((get_option('woocommerce_factor_offo') == 'enabled') && (get_option('woocommerce_factor_vaheds') != 'enabled')) {
                $return.= '<th colspan="2" style="border: 1px solid #797878;text-align:center; padding: 3px;">جمع موارد</td>';
            } elseif ((get_option('woocommerce_factor_offo') != 'enabled') && (get_option('woocommerce_factor_vaheds') == 'enabled')) {
                $return.= '<th colspan="3" style="border: 1px solid #797878;text-align:center; padding: 3px;">جمع موارد</td>';
            } elseif ((get_option('woocommerce_factor_offo') != 'enabled') && (get_option('woocommerce_factor_vaheds') != 'enabled')) {
                $return.= '<th colspan="2" style="border: 1px solid #797878;text-align:center; padding: 3px;">جمع موارد</td>';
            }
            $return.= '<th style="border: 1px solid #797878;text-align:center; padding: 3px;">' . wc_price($subvahed) . '</td>';
            $return.= '<th style="border: 1px solid #797878;text-align:center; padding: 3px;">' . $qtysub . '</td>';
            if (get_option('woocommerce_factor_offo') == 'enabled') {
                $return.= '<th style="border: 1px solid #797878;text-align:center; padding: 3px;">' . wc_price($suboff) . '</td>';
            }
            $return.= '<th style="border: 1px solid #797878;text-align:center; padding: 3px;">' . wc_price($subtt) . '</td>';
            $return.= '</tr></tfoot>';
        }
    }
    $return = apply_filters('woocommerce_factor_order_items_table', $return);
    return $return;
}
/**
 * woocommerce_factor_template function.
 *
 * Get template directory
 * @access public
 * @param mixed $type
 * @param mixed $template
 * @return void
 */
function woocommerce_factor_template($type, $template) {
    $templates = array();
    if (file_exists(trailingslashit(get_stylesheet_directory()) . 'woocommerce/woocommerce-factor-template/' . $template)) {
        $templates['uri'] = trailingslashit(get_stylesheet_directory_uri()) . 'woocommerce/woocommerce-factor-template/';
        $templates['dir'] = trailingslashit(get_stylesheet_directory()) . 'woocommerce/woocommerce-factor-template/';
    } else {
        $templates['uri'] = woocommerce_factor_get_plugin_url() . '/woocommerce-factor-template/';
        $templates['dir'] = woocommerce_factor_get_plugin_path() . '/woocommerce-factor-template/';
    }
    return $templates[$type];
}
function woocommerce_factor_templates($type, $template) {
    $templates = array();
    if (file_exists(trailingslashit(get_stylesheet_directory()) . 'woocommerce/woocommerce-factor-template/' . $template)) {
        $templates['uri'] = trailingslashit(get_stylesheet_directory_uri()) . 'woocommerce/woocommerce-factor-template/';
        $templates['dir'] = trailingslashit(get_stylesheet_directory()) . 'woocommerce/woocommerce-factor-template/';
    } else {
        $templates['uri'] = woocommerce_factor_get_plugin_url() . '/woocommerce-factor-template/';
        $templates['dir'] = woocommerce_factor_get_plugin_path() . '/woocommerce-factor-template/';
    }
    return $templates[$type];
}
/**
 * woocommerce_factor_preview function.
 *
 * Output preview if needed
 * @access public
 * @return void
 */
function woocommerce_factor_preview() {
    if (get_option('woocommerce_factor_preview') != 'enabled') {
        return 'onload="window.print()"';
    }
}
function woocommerce_factor_linko() {
    if (get_option('woocommerce_factor_linko') != 'enabled') {
        return 'onload="window.print()"';
    }
}
/**
 * woocommerce_factor_print_logo function.
 *
 * Output logo if needed
 * @access public
 * @return void
 */
function woocommerce_factor_print_logo() {
    if (get_option('woocommerce_factor_logo') != '') {
        return '<img src="' . get_option('woocommerce_factor_logo') . '" />';
    }
}
/**
 * woocommerce_factor_print_company_name function.
 *
 * Output company name if needed
 * @access public
 * @return void
 */
function woocommerce_factor_print_company_name() {
    if (get_option('woocommerce_factor_company_name') != '') {
        return get_option('woocommerce_factor_company_name');
    }
}
function woocommerce_factor_font() {
    if (get_option('woocommerce_factor_font') != '') {
        return get_option('woocommerce_factor_font');
    }
}
function woocommerce_factor_titles() {
    if (get_option('woocommerce_factor_titles') != '') {
        return get_option('woocommerce_factor_titles');
    }
}
function woocommerce_factor_titlein() {
    if (get_option('woocommerce_factor_titlein') != '') {
        return get_option('woocommerce_factor_titlein');
    }
}
function woocommerce_factor_papersize() {
    if (get_option('woocommerce_factor_papersize') != '') {
        return get_option('woocommerce_factor_papersize');
    }
}
function woocommerce_factor_codeposti() {
    if (get_option('woocommerce_factor_codeposti') != '') {
        return get_option('woocommerce_factor_codeposti');
    }
}
function woocommerce_factor_namefamily() {
    if (get_option('woocommerce_factor_bnamefamily') != '') {
        echo get_option('woocommerce_factor_bnamefamily');
    }
	else{
		echo "نام نام خانوادگی";
	}
}
function woocommerce_factor_bcompany() {
    if (get_option('woocommerce_factor_bcompany') != '') {
        echo get_option('woocommerce_factor_bcompany');
    }
	else{
		echo "شرکت";
	}
}
function woocommerce_factor_bphone() {
    if (get_option('woocommerce_factor_bphone') != '') {
        echo get_option('woocommerce_factor_bphone');
    }
	else{
		echo "شماره تماس";
	}
}
function woocommerce_factor_bemail() {
    if (get_option('woocommerce_factor_bemail') != '') {
        echo get_option('woocommerce_factor_bemail');
    }
	else{
		echo "ایمیل";
	}
}
function woocommerce_factor_baddress() {
    if (get_option('woocommerce_factor_baddress') != '') {
        echo get_option('woocommerce_factor_baddress');
    }
	else{
		echo "آدرس";
	}
}
	function woocommerce_factor_bpostcode() {
    if (get_option('woocommerce_factor_bpostcode') != '') {
        echo get_option('woocommerce_factor_bpostcode');
    }
	else{
		echo "کد پستی";
	}
}
		function woocommerce_factor_bshipping_metod() {
    if (get_option('woocommerce_factor_bshipping_metod') != '') {
        echo get_option('woocommerce_factor_bshipping_metod');
    }
	else{
		echo "ارسال از طریق";
	}
}
	function woocommerce_factor_bpay_metod() {
    if (get_option('woocommerce_factor_bpay_metod') != '') {
        echo get_option('woocommerce_factor_bpay_metod');
    }
	else{
		echo "پرداخت از طریق";
	}
}
function woocommerce_factor_addressshop() {
    if (get_option('woocommerce_factor_addressshop') != '') {
        return get_option('woocommerce_factor_addressshop');
    }
}
function woocommerce_factor_nameshop() {
    if (get_option('woocommerce_factor_nameshop') != '') {
        return get_option('woocommerce_factor_nameshop');
    }
}
function woocommerce_factor_paperlayout() {
    if (get_option('woocommerce_factor_paperlayout') != '') {
        return get_option('woocommerce_factor_paperlayout');
    }
}
function woocommerce_factor_phoneshop() {
    if (get_option('woocommerce_factor_phoneshop') != '') {
        return get_option('woocommerce_factor_phoneshop');
    }
}
function woocommerce_factor_barcodem() {
    if (get_option('woocommerce_factor_barcodem') != '') {
        return get_option('woocommerce_factor_barcodem');
    }
}
function woocommerce_factor_fontfamily() {
    if (get_option('woocommerce_factor_fontfamily') != '') {
        return get_option('woocommerce_factor_fontfamily');
    }
}
function woocommerce_factor_theme() {
    if (get_option('woocommerce_factor_theme') != '') {
        return get_option('woocommerce_factor_theme');
    }
}
function woocommerce_factor_labeltheme() {
    if (get_option('woocommerce_factor_labeltheme') != '') {
        return get_option('woocommerce_factor_labeltheme');
    }
}
function woocommerce_factor_margin_top() {
    if (get_option('woocommerce_factor_margin_top') != '') {
        return get_option('woocommerce_factor_margin_top');
    }
}
function woocommerce_factor_margin_bottom() {
    if (get_option('woocommerce_factor_margin_bottom') != '') {
        return get_option('woocommerce_factor_margin_bottom');
    }
}
function woocommerce_factor_margin_left() {
    if (get_option('woocommerce_factor_margin_left') != '') {
        return get_option('woocommerce_factor_margin_left');
    }
}
function woocommerce_factor_margin_right() {
    if (get_option('woocommerce_factor_margin_right') != '') {
        return get_option('woocommerce_factor_margin_right');
    }
}
/**
 * woocommerce_factor_print_company_extra function.
 *
 * Output company extra if needed
 * @access public
 * @return void
 */
function woocommerce_factor_print_company_extra() {
    if (get_option('woocommerce_factor_company_extra') != '') {
        return nl2br(stripslashes(get_option('woocommerce_factor_company_extra')));
    }
}
/**
 * woocommerce_factor_print_return_policy function.
 *
 * Output return policy if needed
 * @access public
 * @return void
 */
function woocommerce_factor_print_return_policy() {
    if (get_option('woocommerce_factor_return_policy') != '') {
        return nl2br(stripslashes(get_option('woocommerce_factor_return_policy')));
    }
}
/**
 * woocommerce_factor_print_footer function.
 *
 * Output footer if needed
 * @access public
 * @return void
 */
function woocommerce_factor_print_footer() {
    if (get_option('woocommerce_factor_footer') != '') {
        return nl2br(stripslashes(get_option('woocommerce_factor_footer')));
    }
}
/**
 * woocommerce_factor_invoice_number function.
 *
 * Output invoice number if needed
 * @access public
 * @param mixed $order_id
 * @return void
 */
function woocommerce_factor_invoice_number($order_id) {
    $invoice_number = get_option('woocommerce_factor_invoice_start');
    $d = factor_jdates("d", '', '', '', 'en');
    $yy = factor_jdates("y", '', '', '', 'en');
    $Y = factor_jdates("Y", '', '', '', 'en');
    $m = factor_jdates("m", '', '', '', 'en');
    $H = factor_jdates("H", '', '', '', 'en');
    $N = factor_jdates("N", '', '', '', 'en');
    $S = factor_jdates("S", '', '', '', 'en');
    $suffix = get_option('woocommerce_factor_invoice_suffix');
    $B1 = str_replace("{d}", $d, $suffix);
    $B2 = str_replace("{y}", $yy, $B1);
    $B3 = str_replace("{Y}", $Y, $B2);
    $B4 = str_replace("{m}", $m, $B3);
    $B5 = str_replace("{H}", $H, $B4);
    $B6 = str_replace("{N}", $N, $B5);
    $B = str_replace("{S}", $m, $B6);
    $prefix = get_option('woocommerce_factor_invoice_prefix');
    $P1 = str_replace("{d}", $d, $prefix);
    $P2 = str_replace("{y}", $yy, $P1);
    $P3 = str_replace("{Y}", $Y, $P2);
    $P4 = str_replace("{m}", $m, $P3);
    $P5 = str_replace("{H}", $H, $P4);
    $P6 = str_replace("{N}", $N, $P5);
    $P = str_replace("{S}", $m, $P6);
    if (add_post_meta($order_id, '_factor_invoice_number', $P . $invoice_number . $B, true)) {
        update_option('woocommerce_factor_invoice_start', $invoice_number + 1);
    }
    return get_post_meta($order_id, '_factor_invoice_number', true);
}
/**
 * woocommerce_factor_order_fees function.
 *
 * Output order fees if needed
 * @access public
 * @param mixed $order
 * @return void
 */
function woocommerce_factor_order_fees($order) {
    $print_fees = '';
    if ($fees = $order->get_fees()) {
        foreach ($fees as $id => $fee) {
            $print_fees.= '<tr><th colspan="2" style="text-align:center; padding-top: 12px;">&nbsp;</th>
											<th scope="row" style="text-align:right;">' . $fee["name"] . '</th>
											<td style="text-align:center;">' . wc_price($fee["line_total"]) . '</td>
											</tr>';
        }
    }
    return $print_fees;
}
/**
 * woocommerce_factor_user_access function.
 *
 * Helper function to check access rights.
 * Support for 1.6.6 and 2.0.
 * @access public
 * @return void
 */
function woocommerce_factor_user_access() {
    $access = (current_user_can('edit_shop_orders') || current_user_can('manage_woocommerce_orders')) ? false : true;
    return $access;
}
/**
 * woocommerce_factor_window function.
 *
 * Function to output the printing window for single item and bulk printing.
 * @access public
 * @return void
 */
function woocommerce_factor_window() {
    if (isset($_GET['print_factor'])) {
		if(woocommerce_factor_theme() == "4"){
			$nonce = $_REQUEST['_wpnonce'];
        $client = false;
        // Check that current user has needed access rights.
        if (!wp_verify_nonce($nonce, 'print-factor') || !is_user_logged_in() || woocommerce_factor_user_access()) die('خطا در تولید فاکتور : لطفا مجدد صفحه سفارشات را بررسی کنید.');
        // unhook the admin bar to compensate for crappy NextGEN Gallery by Photocrati which causes it to be rendered on our factor windows
        remove_action('wp_footer', 'wp_admin_bar_render', 1500);
        $orders = explode(',', $_GET['post']);
        $action = $_GET['type'];
        $number_of_orders = count($orders);
        $order_loop = 0;
        // Build the output.
        ob_start();
        require_once woocommerce_factor_template('dir', 'template-header.php') . 'template-header.php';
        $content = ob_get_clean();
        // Loop through all orders (bulk printing).
        foreach ($orders as $order_id) {
            $order_loop++;
            $order = wc_get_order($order_id);
            ob_start();
            include woocommerce_factor_template('dir', 'template-body.php') . 'template-body.php';
            $content.= ob_get_clean();
            if ($action == 'print_label') {
                if ($number_of_orders == 3) {
                    $content.= '<p class="pagebreak"></p>';
                }
            } else {
                if ($number_of_orders > 1 && $order_loop < $number_of_orders) {
                    
                }
            }
        }
        ob_start();
        require_once woocommerce_factor_template('dir', 'template-footer.php') . 'template-footer.php';
        $content.= ob_get_clean();
        echo $content;
        exit;
		} else{
        $nonce = $_REQUEST['_wpnonce'];
        $client = false;
        // Check that current user has needed access rights.
        if (!wp_verify_nonce($nonce, 'print-factor') || !is_user_logged_in() || woocommerce_factor_user_access()) die('خطا در تولید فاکتور : لطفا مجدد صفحه سفارشات را بررسی کنید.');
        // unhook the admin bar to compensate for crappy NextGEN Gallery by Photocrati which causes it to be rendered on our factor windows
        remove_action('wp_footer', 'wp_admin_bar_render', 1500);
        $orders = explode(',', $_GET['post']);
        $action = $_GET['type'];
        $number_of_orders = count($orders);
        $order_loop = 0;
        // Build the output.
        ob_start();
        require_once woocommerce_factor_template('dir', 'template-header.php') . 'template-header.php';
        $content = ob_get_clean();
        // Loop through all orders (bulk printing).
        foreach ($orders as $order_id) {
            $order_loop++;
            $order = wc_get_order($order_id);
            ob_start();
            include woocommerce_factor_template('dir', 'template-body.php') . 'template-body.php';
            $content.= ob_get_clean();
            if ($action == 'print_label') {
                if ($number_of_orders == 3) {
                    $content.= '<p class="pagebreak"></p>';
                }
            } else {
                if ($number_of_orders > 1 && $order_loop < $number_of_orders) {
                    $content.= '<p class="pagebreak"></p>';
                }
            }
        }
        ob_start();
        require_once woocommerce_factor_template('dir', 'template-footer.php') . 'template-footer.php';
        $content.= ob_get_clean();
        echo $content;
        exit;
	}
    }
}
/**
 * woocommerce_factor_client_window function.
 *
 * Function to output the printing window for single item for customers.
 * @access public
 * @return void
 */
function woocommerce_factor_client_window() {
    if (isset($_GET['print_factor_invoice']) && isset($_GET['post'])) {
        $nonce = $_REQUEST['_wpnonce'];
        $orderidss = $_GET['post'];
        $order = new WC_Order($orderidss); // phpcs:ignore WordPress.WP.GlobalVariablesOverride.OverrideProhibited
		echo $orderidss;
        $current_user = wp_get_current_user();
        $action = 'print_invoice';
        $client = true;
        // Check that current user has needed access rights.
        if (!wp_verify_nonce($nonce, 'client-print-factor') || !is_user_logged_in() || $order->get_customer_id() != $current_user->ID) die('خطا در تولید فاکتور : لطفا مجدد صفحه سفارشات را بررسی کنید.');
        // unhook the admin bar to compensate for crappy NextGEN Gallery by Photocrati which causes it to be rendered on our factor windows (actually this one might not be needed, are the customers in the admin for this?)
        remove_action('wp_footer', 'wp_admin_bar_render', 1500);
        // Build the output.
        ob_start();
        require_once woocommerce_factor_template('dir', 'template-header.php') . 'template-header.php';
        $content = ob_get_clean();
        ob_start();
        include woocommerce_factor_template('dir', 'template-body.php') . 'template-body.php';
        $content.= ob_get_clean();
        ob_start();
        require_once woocommerce_factor_template('dir', 'template-footer.php') . 'template-footer.php';
        $content.= ob_get_clean();
        echo $content;
        exit;
    }
}
/**
 * woocommerce_factor_order_bulk_action function.
 *
 * Process the new bulk actions for printing invoices and packing lists.
 * @access public
 * @return void
 */
function woocommerce_factor_order_bulk_action() {
    $wp_list_table = _get_list_table('WP_Posts_List_Table');
    $action = $wp_list_table->current_action();
    if ($action == 'print_invoice' || $action == 'print_packing' || $action == 'print_label') {
        $posts = '';
        foreach ($_REQUEST['post'] as $post_id) {
            if (empty($posts)) {
                $posts = $post_id;
            } else {
                $posts.= ',' . $post_id;
            }
        }
        $forward = wp_nonce_url(admin_url(), 'print-factor');
        $forward = add_query_arg(array('print_factor' => 'true', 'post' => $posts, 'type' => $action), $forward);
        wp_redirect($forward);
        exit();
    }
}
/**
 * woocommerce_factor_resend_email function.
 *
 * @access public
 * @return void
 */
function woocommerce_factor_resend_email() {
    if (isset($_GET['email_factor'])) {
        $nonce = $_REQUEST['_wpnonce'];
        // Check that current user has needed access rights.
        if (!wp_verify_nonce($nonce, 'email-factor') || !is_user_logged_in() || woocommerce_factor_user_access()) die('خطا در تولید فاکتور : لطفا مجدد صفحه سفارشات را بررسی کنید.');
        woocommerce_factor_send_email($_GET['post']);
    }
}
function woocommerce_factor_resend_emailpack() {
    if (isset($_GET['email_factorpack'])) {
        $nonce = $_REQUEST['_wpnonce'];
        // Check that current user has needed access rights.
        if (!wp_verify_nonce($nonce, 'email-factorpack') || !is_user_logged_in() || woocommerce_factor_user_access()) die('خطا در تولید فاکتور : لطفا مجدد صفحه سفارشات را بررسی کنید.');
        woocommerce_factor_send_emailpack($_GET['post']);
    }
}
function woocommerce_factor_resend_emailpacks($order_id) {
    if (isset($_GET['email_factorpack'])) {
        $nonce = $_REQUEST['_wpnonce'];
        // Check that current user has needed access rights.
        if (!wp_verify_nonce($nonce, 'email-factorpack') || !is_user_logged_in() || woocommerce_factor_user_access()) die('خطا در تولید فاکتور : لطفا مجدد صفحه سفارشات را بررسی کنید.');
        woocommerce_factor_send_emailpack($order_id);
    }
}
/**
 * woocommerce_factor_send_email function.
 *
 * Function to send invoice as email
 * @access public
 * @param mixed $order_id
 * @return void
 */
function woocommerce_factor_send_email($order_id) {
    $_GET["type"] = "email_factor";
    if (get_option('woocommerce_factor_send_email') == 'enabled') {
        ob_start();
        require_once woocommerce_factor_template('dir', 'email-template.php') . 'email-template.php';
        $message = ob_get_clean();
        // Build email information
        $order = new WC_Order($order_id);
        $to = $order->get_billing_email();
        $subject = __('صورت حساب سفارش', 'woocommerce-factor');
        $subject = get_bloginfo('name') . ' - ' . $subject;
        $attachments = "";
        $headers = "Content-Type: text/html\r\n";
        // Send the mail
        WC_mail($to, $subject, $message, $headers, $attachments);
    }
}
function woocommerce_factor_send_emailpack($order_id) {
    $_GET["type"] = "email_packing";
    if (get_option('woocommerce_factor_send_emailpack') == 'enabled') {
        ob_start();
        require_once woocommerce_factor_templates('dir', 'email-templatepack.php') . 'email-templatepack.php';
        $message = ob_get_clean();
        // Build email information
        $order = new WC_Order($order_id);
        $to = get_option('woocommerce_factor_send_emailpacklist');
        $subject = __('لیست بسته بندی', 'woocommerce-factor');
        $subject = get_bloginfo('name') . ' - ' . $subject;
        $attachments = "";
        $headers = "Content-Type: text/html\r\n";
        // Send the mail
        WC_mail($to, $subject, $message, $headers, $attachments);
    }
}
/**
 * Don't copy over plugin-specific order meta when creating a parent renewal order.
 *
 * @since 2.4.3
 * @param array $order_meta_query MySQL query for pulling the metadata
 * @param int $original_order_id Post ID of the order being used to purchased the subscription being renewed
 * @param int $renewal_order_id Post ID of the order created for renewing the subscription
 * @param string $new_order_role The role the renewal order is taking, one of 'parent' or 'child'
 * @return string MySQL meta query for pulling the metadata, excluding data added by this gateway
 */
function woocommerce_factor_remove_subscription_renewal_order_meta($order_meta_query, $original_order_id, $renewal_order_id, $new_order_role) {
    // guessing we don't want to carry the factor invoice number meta to either parent or child orders
    $order_meta_query.= " AND `meta_key` NOT IN ( '_factor_invoice_number' )";
    return $order_meta_query;
}
function woocommerce_factor_remove_subscription_renewal_order_metas($order_meta_query, $original_order_id, $renewal_order_id, $new_order_role) {
    // guessing we don't want to carry the factor invoice number meta to either parent or child orders
    $order_meta_query.= " AND `meta_key` NOT IN ( '_factor_barcodes' )";
    return $order_meta_query;
}
/**
 * woocommerce_factor_get_plugin_url function.
 *
 * Gets the plugin url without a trailing slash, e.g. http://skyverge.com/wp-content/plugins/plugin-directory
 *
 * @since 2.3.1
 * @return string the plugin url
 * @access public
 * @return void
 */
function woocommerce_factor_get_plugin_url() {
    return untrailingslashit(plugins_url('/', __FILE__));
}
/**
 * Gets the absolute plugin path without a trailing slash, e.g.
 * /path/to/wp-content/plugins/plugin-directory
 *
 * @since 2.3.1
 * @return string plugin path
 */
function woocommerce_factor_get_plugin_path() {
    return untrailingslashit(plugin_dir_path(__FILE__));
}
function digit_to_persain_letters($money) {
    $one = array('صفر', 'يک', 'دو', 'سه', 'چهار', 'پنج', 'شش', 'هفت', 'هشت', 'نه');
    $ten = array('', 'ده', 'بيست', 'سي', 'چهل', 'پنجاه', 'شصت', 'هفتاد', 'هشتاد', 'نود',);
    $hundred = array('', 'يکصد', 'دويست', 'سيصد', 'چهارصد', 'پانصد', 'ششصد', 'هفتصد', 'هشتصد', 'نهصد',);
    $categories = array('', 'هزار', 'ميليون', 'ميليارد',);
    $exceptions = array('', 'يازده', 'دوازده', 'سيزده', 'چهارده', 'پانزده', 'شانزده', 'هفده', 'هجده', 'نوزده',);
    // echo count($categories);
    if (strlen($money) > count($categories) + 5) {
        throw new Exception('number is longger!');
    }
    $letters_separator = ' و ';
    $money = (string)(int)$money;
    $money_len = strlen($money);
    $persian_letters = '';
    for ($i = $money_len - 1;$i >= 0;$i-= 3) {
        $i_one = (int)isset($money[$i]) ? $money[$i] : -1;
        $i_ten = (int)isset($money[$i - 1]) ? $money[$i - 1] : -1;
        $i_hundred = (int)isset($money[$i - 2]) ? $money[$i - 2] : -1;
        $i_thousand = (int)isset($money[$i - 3]) ? $money[$i - 3] : -1;
        // echo "test = ".$i_thousand;
        $isset_one = false;
        $isset_ten = false;
        $isset_hundred = false;
        $letters = '';
        // zero
        if ($i_one == 0 && $i_ten < 0 && $i_hundred < 0) {
            $letters = $one[$i_one];
        }
        // one
        if (($i >= 0) && $i_one > 0 && $i_ten != 1 && isset($one[$i_one])) {
            $letters = $one[$i_one];
            $isset_one = true;
        }
        // ten
        if (($i - 1 >= 0) && $i_ten > 0 && isset($ten[$i_ten])) {
            if ($isset_one) {
                $letters = $letters_separator . $letters;
            }
            if ($i_one == 0) {
                $letters = $ten[$i_ten];
            } elseif ($i_ten == 1 && $i_one > 0) {
                $letters = $exceptions[$i_one];
            } else {
                $letters = $ten[$i_ten] . $letters;
            }
            $isset_ten = true;
        }
        // hundred
        if (($i - 2 >= 0) && $i_hundred > 0 && isset($hundred[$i_hundred])) {
            if ($isset_ten || $isset_one) {
                $letters = $letters_separator . $letters;
            }
            $letters = $hundred[$i_hundred] . $letters;
            $isset_hundred = true;
        }
        if ($i_one < 1 && $i_ten < 1 && $i_hundred < 1) {
            $letters = '';
        } else {
            $letters.= ' ' . $categories[($money_len - $i - 1) / 3];
        }
        if (!empty($letters) && $i >= 3) {
            $letters = $letters_separator . $letters;
        }
        $persian_letters = $letters . $persian_letters;
    }
    return $persian_letters;
}
function woocommerce_factor_action_header($columns) {
    $new_columns = array();
    foreach ($columns as $column_name => $column_info) {
        $new_columns[$column_name] = $column_info;
        if ('order_total' === $column_name) {
            $new_columns['order_factor'] = __('فاکتور', 'my-textdomain');
        }
    }
    return $new_columns;
}
add_filter('manage_edit-shop_order_columns', 'woocommerce_factor_action_header', 20);
if (!function_exists('sv_helper_get_order_meta')):
    function sv_helper_get_order_meta($order, $key = '', $single = true, $context = 'edit') {
        // WooCommerce > 3.0
        if (defined('WC_VERSION') && WC_VERSION && version_compare(WC_VERSION, '3.0', '>=')) {
            $value = $order->get_meta($key, $single, $context);
        } else {
            // have the $order->get_id() check here just in case the WC_VERSION isn't defined correctly
            $order_id = is_callable(array($order, 'get_id')) ? $order->get_id() : get_the_ID();
            $value = get_post_meta($order_id, $key, $single);
        }
        return $value;
    }
endif;
function woocommerce_factor_action_content($column) {
    global $post;
    if ('order_factor' === $column) {
        $order = wc_get_order(get_the_ID());
?>
<style>
    .widefat .column-order_actions a.button, .widefat .column-user_actions a.button, .widefat .column-wc_actions a.button,.dokan-dashboard .dokan-dashboard-content a.button {
    float: right;
    margin: 0 0 2px 4px;
    cursor: pointer;
    padding: 3px 4px;
    height: auto;
    color: #333;
    background-color: #fff;
    border-color: #ccc;
box-shadow: none;
        border: 1px solid #ccc;
}
	.notfactor{
		background: #f8d7da !important;
		border-color: #f5c6cb !important;
	}
    .widefat .column-order_actions a.button,.dokan-dashboard .dokan-dashboard-content a.button,.dokan-dashboard .dokan-dashboard-content a.tips{    width: 32px !important;}
    .factor-link img,.widefat .column-order_actions a.button img,.dokan-dashboard .dokan-dashboard-content a.button img{width: 15px !important;    margin: 5px 2px !important;}
	a.factor-link{
		float: right;
    margin: 0 0 2px 4px !important;
    cursor: pointer !important;
    padding: 3px 4px !important;
    height: auto;
    color: #333 !important;
    background-color: #fff !important;
    border-color: #ccc !important;
    box-shadow: none;
    border: 1px solid #ccc;
    line-height: 7px !important;
	}
</style>
<?php if (class_exists('WeDevs_Dokan')) { ?>
<?php if (get_option('woocommerce_factor_getfactorco') == 'enabled') {
                if (get_post_meta(get_the_ID(), 'factorres', true)) { ?>
			<div style="width: 100%;margin-bottom: 5px;color: #155724;border: 1px solid #eee;background-color: #d4edda;border-color: #c3e6cb;padding: 0px;text-align: center;font-size: 12px;">پذیرش دریافت برگه <span style="margin-right: -3px;font-size: 10px;">ی</span> فاکتور</div>


<?php
                } else { ?>
			<div style="width: 100%;margin-bottom: 5px;border: 1px solid #eee;color: #721c24;background-color: #f8d7da;border-color: #f5c6cb;padding: 0px;text-align: center;font-size: 12px;">عدم دریافت برگه <span style="margin-right: -3px;font-size: 10px;">ی</span> فاکتور</div>
		<?php
                }
            } ?>
<a class="button tips factor-link" data-tip="" href="<?php echo wp_nonce_url(admin_url('?print_factor=true&post=' . get_the_ID() . '&type=print_invoice'), 'print-factor'); ?>" data-toggle="tooltip" data-placement="top" title="" data-original-title="<?php esc_attr_e('چاپ صورت حساب', 'woocommerce-factor'); ?>"><img src="<?php echo woocommerce_factor_get_plugin_url() . '/assets/images/printer.svg'; ?>" alt="<?php esc_attr_e('چاپ صورت حساب', 'woocommerce-factor'); ?>" width="18"></a>
				<a class="button tips factor-link" data-tip="" href="<?php echo wp_nonce_url(admin_url('?print_factor=true&post=' . get_the_ID() . '&type=print_packing'), 'print-factor'); ?>"  data-toggle="tooltip" data-placement="top" title="" data-original-title="<?php esc_attr_e('چاپ لیست سفارش', 'woocommerce-factor'); ?>"><img src="<?php echo woocommerce_factor_get_plugin_url() . '/assets/images/box.svg'; ?>" alt="<?php esc_attr_e('چاپ لیست سفارش List', 'woocommerce-factor'); ?>" width="18"></a>
<a class="button tips factor-link" data-tip="" href="<?php echo wp_nonce_url(admin_url('?print_factor=true&post=' . get_the_ID() . '&type=print_label'), 'print-factor'); ?>"   data-toggle="tooltip" data-placement="top" title="" data-original-title="<?php esc_attr_e('چاپ برچسب', 'woocommerce-factor'); ?>"><img src="<?php echo woocommerce_factor_get_plugin_url() . '/assets/images/label.svg'; ?>" alt="<?php esc_attr_e('چاپ برچسب', 'woocommerce-factor'); ?>" width="18"></a>


<?php
        } else { ?>
<?php if (get_option('woocommerce_factor_getfactorco') == 'enabled') {
                if (get_post_meta(get_the_ID(), 'factorres', true)) { ?>
			<div style="width: 100%;margin-bottom: 5px;color: #155724;border: 1px solid #eee;background-color: #d4edda;border-color: #c3e6cb;padding: 0px;text-align: center;font-size: 12px;">پذیرش دریافت برگه <span style="margin-right: -3px;font-size: 10px;">ی</span> فاکتور</div>


<?php
                } else { ?>
			<div style="width: 100%;margin-bottom: 5px;border: 1px solid #eee;color: #721c24;background-color: #f8d7da;border-color: #f5c6cb;padding: 0px;text-align: center;font-size: 12px;">عدم دریافت برگه <span style="margin-right: -3px;font-size: 10px;">ی</span> فاکتور</div>
		<?php
                }
            } ?>
<a class="button tips factor-link" data-tip="<?php esc_attr_e('چاپ صورت حساب', 'woocommerce-factor'); ?>" href="<?php echo wp_nonce_url(admin_url('?print_factor=true&post=' . get_the_ID() . '&type=print_invoice'), 'print-factor'); ?>" ><img src="<?php echo woocommerce_factor_get_plugin_url() . '/assets/images/printer.svg'; ?>" alt="<?php esc_attr_e('چاپ صورت حساب', 'woocommerce-factor'); ?>" width="18"></a>
				<a class="button tips factor-link" data-tip="<?php esc_attr_e('چاپ لیست سفارش', 'woocommerce-factor'); ?>" href="<?php echo wp_nonce_url(admin_url('?print_factor=true&post=' . get_the_ID() . '&type=print_packing'), 'print-factor'); ?>"><img src="<?php echo woocommerce_factor_get_plugin_url() . '/assets/images/box.svg'; ?>" alt="<?php esc_attr_e('چاپ لیست سفارش List', 'woocommerce-factor'); ?>" width="18"></a>
<a class="button tips factor-link" data-tip="<?php esc_attr_e('چاپ برچسب', 'woocommerce-factor'); ?>" href="<?php echo wp_nonce_url(admin_url('?print_factor=true&post=' . get_the_ID() . '&type=print_label'), 'print-factor'); ?>"><img src="<?php echo woocommerce_factor_get_plugin_url() . '/assets/images/label.svg'; ?>" alt="<?php esc_attr_e('چاپ برچسب', 'woocommerce-factor'); ?>" width="18"></a>
<?php
        }
    }
}
add_action('manage_shop_order_posts_custom_column', 'woocommerce_factor_action_content');
function isa_get_wc_print_receipt_link($order) {
    return '<style>#wc-print-button {
    display: inline-block;
    text-decoration:none;
    margin: 0;
    padding: 5px;
    border:0;
    color: #fff;
    background-color: #6496c8;
    border-radius: 3px;
    float: left;
}
#wc-print-button:hover {
    opacity: .7;
    color: #fff;
}
#wc-print-button img{width:20px;}
.woocommerce-order-overview{clear: both;
    margin-top: 17px;}</style><a href="' . wp_nonce_url(site_url('?print_factor_invoice=true&type=print_invoice&post=' . $order), 'client-print-factor') . '" id="wc-print-button" target="_blank"><img src="' . woocommerce_factor_get_plugin_url() . '/assets/images/printers.svg" width="18"> چاپ فاکتور </a>';
}
/**
 * Add "Print receipt" link to WooCommerce View Order page
 */
function isa_woo_view_order_print_receipts() {
}
add_action('woocommerce_view_order', 'isa_woo_view_order_print_receipts', 8);
/**
 * Add "Print receipt" link to WooCommerce Order Received page TOP
 */
if (get_option('woocommerce_factor_linko') == 'enabled') {
    function isa_woo_order_print_receipt_top($text, $order) {
        $out = isa_get_wc_print_receipt_link($order->get_id());
        return $out . ' ' . $text;
    }
    add_filter('woocommerce_thankyou_order_received_text', 'isa_woo_order_print_receipt_top', 999, 2);
} else {
    function isa_woo_order_print_receipt_top($text, $order) {
        $out = isa_get_wc_print_receipt_link($order->get_id());
        return $out . ' ' . $text;
    }
    remove_filter('woocommerce_thankyou_order_received_text', 'isa_woo_order_print_receipt_top', 999, 2);
}
add_action('woocommerce_product_options_sold_individually', 'misha_adv_product_options');
function misha_adv_product_options() {
    echo '<div class="options_group">';
    woocommerce_wp_text_input(array('id' => 'vahed', 'value' => get_post_meta(get_the_ID(), 'vahed', true), 'label' => 'واحد محصول', 'desc_tip' => true, 'description' => 'واحد اندازه گیری مانند(عدد ، جعبه و..)',));
    echo '</div>';
}
add_action('woocommerce_process_product_meta', 'misha_save_fields', 10, 2);
function misha_save_fields($id, $post) {
    //if( !empty( $_POST['vahed'] ) ) {
    update_post_meta($id, 'vahed', $_POST['vahed']);
    //} else {
    //	delete_post_meta( $id, 'vahed' );
    //}
    
}
add_action('woocommerce_product_options_sold_individually', 'idpacking_product_options');
function idpacking_product_options() {
    echo '<div class="options_group">';
    woocommerce_wp_text_input(array('id' => 'idpacking', 'value' => get_post_meta(get_the_ID(), 'idpacking', true), 'label' => 'شناسه قفسه انبار', 'desc_tip' => true, 'description' => 'کد قفسه ای که محصول در انبار است',));
    echo '</div>';
}
add_action('woocommerce_process_product_meta', 'idpacking_save_fields', 10, 2);
function idpacking_save_fields($id, $post) {
    update_post_meta($id, 'idpacking', $_POST['idpacking']);
}
function cw_factorres_checkbox_fields($checkout) {
?>
<style>
	.cw_custom_class{}
	.cw_custom_class h3{}
	.cw_custom_class .notfactor{
	font-size: 11px;
    position: relative;
    padding: 5px;
    margin-bottom: 1rem;
    border: 1px solid transparent;
    border-radius: 0.25rem;
    color: #155724;
    background-color: #d4edda;
    border-color: #c3e6cb;
    font-weight: bold;
	}
	.cw_custom_class .notfactor img{
		width: 30px;
		    vertical-align: middle;
    margin-left: 2px;
	}
	.cw_custom_class .notfactor::before {
    content: "";
    display: block;
    border: 1em solid #c3e6cb;
    border-left-color: transparent;
    border-right-color: transparent;
    border-top-color: transparent;
    position: absolute;
    top: -.99em;
    right: -14px;
    margin: -1em 2em 0 0;
}
</style>
<?php
    echo '<div class="cw_custom_class"><h3>' . __('صدور فاکتور : ') . '</h3>';
    woocommerce_form_field('factorres_checkbox', array('type' => 'checkbox', 'label' => __('درخواست ارسال فاکتور خرید'), 'required' => false,), $checkout->get_value('factorres_checkbox'));
    echo '<div class="notfactor"><img src="' . woocommerce_factor_template("uri", "template-body.php") . '/css/images/forest.svg"/> با نگرفتن پرینت های کاغذی به سبز بودن کره زمین کمک کنید،فاکتور برای شما ایمیل می شود.</div></div>';
}
if (get_option('woocommerce_factor_getfactorco') == 'enabled') {
    add_action('woocommerce_after_order_notes', 'cw_factorres_checkbox_fields');
} else {
    remove_action('woocommerce_after_order_notes', 'cw_factorres_checkbox_fields');
}
add_action('woocommerce_checkout_update_order_meta', 'cw_checkout_order_meta');
function cw_checkout_order_meta($order_id) {
    if ($_POST['factorres_checkbox']) update_post_meta($order_id, 'factorres', esc_attr($_POST['factorres_checkbox']));
}

function state_text($state) {
			if ($state == 'TE') {
                $state = 'تهران';
            }
            if ($state == 'THR') {
                $state = 'تهران';
            }
            if ($state == 'KZ') {
                $state = 'خوزستان';
            }
            if ($state == 'KHZ') {
                $state = 'خوزستان';
            }
            if ($state == 'AL') {
                $state = 'البرز';
            }
            if ($state == 'ABZ') {
                $state = 'البرز';
            }
            if ($state == 'Al') {
                $state = 'اردبیل';
            }
            if ($state == 'ADL') {
                $state = 'اردبیل';
            }
            if ($state == 'AE') {
                $state = 'آذربایجان شرقی';
            }
            if ($state == 'EAZ') {
                $state = 'آذربایجان شرقی';
            }
            if ($state == 'AW') {
                $state = 'آذربایجان غربی';
            }
            if ($state == 'WAZ') {
                $state = 'آذربایجان غربی';
            }
            if ($state == 'BU') {
                $state = 'بوشهر';
            }
            if ($state == 'BHR') {
                $state = 'بوشهر';
            }
            if ($state == 'CM') {
                $state = 'چهارمحال و بختیاری';
            }
            if ($state == 'CHB') {
                $state = 'چهارمحال و بختیاری';
            }
            if ($state == 'FA') {
                $state = 'فارس';
            }
            if ($state == 'FRS') {
                $state = 'فارس';
            }
            if ($state == 'GI') {
                $state = 'گیلان';
            }
            if ($state == 'GIL') {
                $state = 'گیلان';
            }
            if ($state == 'GO') {
                $state = 'گلستان';
            }
            if ($state == 'GLS') {
                $state = 'گلستان';
            }
            if ($state == 'HD') {
                $state = 'همدان';
            }
            if ($state == 'HDN') {
                $state = 'همدان';
            }
            if ($state == 'HG') {
                $state = 'هرمزگان';
            }
            if ($state == 'HRZ') {
                $state = 'هرمزگان';
            }
            if ($state == 'IL') {
                $state = 'ایلام';
            }
            if ($state == 'ILM') {
                $state = 'ایلام';
            }
            if ($state == 'IS') {
                $state = 'اصفهان';
            }
            if ($state == 'ESF') {
                $state = 'اصفهان';
            }
            if ($state == 'KE') {
                $state = 'کرمان';
            }
            if ($state == 'KRN') {
                $state = 'کرمان';
            }
            if ($state == 'BK') {
                $state = 'کرمانشاه';
            }
            if ($state == 'KRH') {
                $state = 'کرمانشاه';
            }
            if ($state == 'KS') {
                $state = 'خراسان شمالی';
            }
            if ($state == 'NKH') {
                $state = 'خراسان شمالی';
            }
            if ($state == 'KV') {
                $state = 'خراسان رضوی';
            }
            if ($state == 'RKH') {
                $state = 'خراسان رضوی';
            }
            if ($state == 'KJ') {
                $state = 'خراسان جنوبی';
            }
            if ($state == 'SKH') {
                $state = 'خراسان جنوبی';
            }
            if ($state == 'KB') {
                $state = 'کهگیلویه و بویراحمد';
            }
            if ($state == 'KBD') {
                $state = 'کهگیلویه و بویراحمد';
            }
            if ($state == 'KD') {
                $state = 'کردستان';
            }
            if ($state == 'KRD') {
                $state = 'کردستان';
            }
            if ($state == 'LO') {
                $state = 'لرستان';
            }
            if ($state == 'LRS') {
                $state = 'لرستان';
            }
            if ($state == 'MK') {
                $state = 'مرکزی';
            }
            if ($state == 'MKZ') {
                $state = 'مرکزی';
            }
            if ($state == 'MN') {
                $state = 'مازندران';
            }
            if ($state == 'MZN') {
                $state = 'مازندران';
            }
            if ($state == 'QZ') {
                $state = 'قزوین';
            }
            if ($state == 'GZN') {
                $state = 'قزوین';
            }
            if ($state == 'QM') {
                $state = 'قم';
            }
            if ($state == 'QHM') {
                $state = 'قم';
            }
            if ($state == 'SM') {
                $state = 'سمنان';
            }
            if ($state == 'SMN') {
                $state = 'سمنان';
            }
            if ($state == 'YA') {
                $state = 'یزد';
            }
            if ($state == 'YZD') {
                $state = 'یزد';
            }
            if ($state == 'ZA') {
                $state = 'زنجان';
            }
            if ($state == 'ZJN') {
                $state = 'زنجان';
            }
            if ($state == 'SB') {
                $state = 'سیستان و بلوچستان';
            }
            if ($state == 'SBN') {
                $state = 'سیستان و بلوچستان';
            }
	return $state;
}
function status_text($status) {
	if($status == "processing"){
		$status ='<span class="processing">درحال انجام</div>';
	}
	if($status == "on-hold"){
		$status ='<span class="on-hold">درحال بررسی</div>';
	}
	if($status == "pending"){
		$status ='<span class="on-hold">درحال بررسی</div>';
	}
	if($status == "cancelled"){
		$status ='<span class="on-hold">لغو سفارش</div>';
	}
	if($status == "completed"){
		$status ='<span class="completed">تکمیل شده</div>';
	}
	if($status == "post_status"){
		$status ='<span class="post-status">ارسال به پست</div>';
	}
	return $status;
}
if (class_exists('WeDevs_Dokan')) {
// Add your custom order status action button (for orders with "processing" status)
add_filter( 'woocommerce_admin_order_actions', 'add_custom_order_status_actions_button', 100, 2 );
}
function add_custom_order_status_actions_button( $actions, $order ) {
    // Display the button for all orders that have a 'processing' status
    ?>
<style>
    .widefat .column-order_actions a.button, .widefat .column-user_actions a.button, .widefat .column-wc_actions a.button,.dokan-dashboard .dokan-dashboard-content a.button {
    float: right;
    margin: 0 0 2px 4px;
    cursor: pointer;
    padding: 3px 4px;
    height: auto;
    color: #333;
    background-color: #fff;
    border-color: #ccc;
box-shadow: none;
        border: 1px solid #ccc;
		background: #fff !important;
		border-radius: 2px;
}
	.notfactor{
		background: #f8d7da !important;
		border-color: #f5c6cb !important;
	}
    .widefat .column-order_actions a.button,.dokan-dashboard .dokan-dashboard-content a.button,.dokan-dashboard .dokan-dashboard-content a.tips{    width: 32px !important;}
    .factor-link img,.widefat .column-order_actions a.button img,.dokan-dashboard .dokan-dashboard-content a.button img{width: 15px !important;    margin: 5px 2px !important;}
	a.factor-link{
		float: right;
    margin: 0 0 2px 4px !important;
    cursor: pointer !important;
    padding: 3px 4px !important;
    height: auto;
    color: #333 !important;
    background-color: #fff !important;
    border-color: #ccc !important;
    box-shadow: none;
    border: 1px solid #ccc;
    line-height: 7px !important;
		background: #ff;
		border-radius: 2px;
	}
</style>
<a class="button tips factor-link" data-tip="" href="<?php echo wp_nonce_url(admin_url('?print_factor=true&post=' . $order->get_id() . '&type=print_invoice'), 'print-factor'); ?>" data-toggle="tooltip" data-placement="top" title="" data-original-title="<?php esc_attr_e('چاپ صورت حساب', 'woocommerce-factor'); ?>"><img src="<?php echo woocommerce_factor_get_plugin_url() . '/assets/images/printer.svg'; ?>" alt="<?php esc_attr_e('چاپ صورت حساب', 'woocommerce-factor'); ?>" width="18"></a>
				<a class="button tips factor-link" data-tip="" href="<?php echo wp_nonce_url(admin_url('?print_factor=true&post=' . $order->get_id() . '&type=print_packing'), 'print-factor'); ?>"  data-toggle="tooltip" data-placement="top" title="" data-original-title="<?php esc_attr_e('چاپ لیست سفارش', 'woocommerce-factor'); ?>"><img src="<?php echo woocommerce_factor_get_plugin_url() . '/assets/images/box.svg'; ?>" alt="<?php esc_attr_e('چاپ لیست سفارش List', 'woocommerce-factor'); ?>" width="18"></a>
<a class="button tips factor-link" data-tip="" href="<?php echo wp_nonce_url(admin_url('?print_factor=true&post=' . $order->get_id() . '&type=print_label'), 'print-factor'); ?>"   data-toggle="tooltip" data-placement="top" title="" data-original-title="<?php esc_attr_e('چاپ برچسب', 'woocommerce-factor'); ?>"><img src="<?php echo woocommerce_factor_get_plugin_url() . '/assets/images/label.svg'; ?>" alt="<?php esc_attr_e('چاپ برچسب', 'woocommerce-factor'); ?>" width="18"></a>
<?php
    return $actions;
}

?>