<?php
function woocommerce_factor_page() {
    //Check the user capabilities
    if (!current_user_can('manage_woocommerce')) {
		echo "<h2>";
        wp_die(__('شما دسترسی به این صفحه را ندارید یا به حساب کاربری خود وارد نشده اید', 'woocommerce-factor'));
		echo "</h2>";
    }
    //Load needed WP resources for media uploader
    wp_enqueue_media();
    //Save the field values
    if (isset($_POST['factor_fields_submitted']) && $_POST['factor_fields_submitted'] == 'submitted') {
        foreach ($_POST as $key => $value) {
            if ($key == 'woocommerce_factor_invoice_start' && isset($_POST['woocommerce_factor_reset_start'])) {
                if ($_POST['woocommerce_factor_reset_start'] == 'Yes') {
                    update_option($key, ltrim($value, '0'));
                }
            } elseif ($key == 'woocommerce_factor_reset_start') {
            } else {
                if (get_option($key) != $value) {
                    update_option($key, $value);
                } else {
                    add_option($key, $value, '', 'no');
                }
            }
        }
    }
?>
    <link href="<?php echo woocommerce_factor_template('uri', 'template-body.php'); ?>css/woocommerce-factor.css" rel=" stylesheet" type="text/css" media="screen,print" />
<link href='https://fonts.googleapis.com/css?family=Roboto' rel='stylesheet'>

    <link href="<?php echo woocommerce_factor_template('uri', 'template-body.php'); ?>css/jquery.colorpicker.css" rel="stylesheet" type="text/css"/>
    <style>
	body {
    font-family: roboto,Yekan;
}
	</style>
	<div class="wrap">
		<div id="poststuff">
					<div class="postbox">
    <div class="factor-body">
        
        <?php if (isset($_POST['factor_fields_submitted']) && $_POST['factor_fields_submitted'] == 'submitted') { ?>
		<div id="message" class="update-setting"><?php _e('تنظیمات با موفقیت ثبت شد.', 'woocommerce-factor'); ?></div>
		<?php
    	} ?>
		<script>
			setTimeout(function() {
                document.getElementById("message").style.display = "none";
                
            }, 4000);
		</script>
		
        
		<div id="content" class="body-factor">
			 <form method="post" action="" id="factor_settings">
				<input type="hidden" name="factor_fields_submitted" value="submitted">
				
                    <div class="tabs">
  <div class="tabs-header">
	  <div class="header-factor">
		<h2><?php _e('افزونه فارسی فاکتور ووکامرس', 'woocommerce-factor'); ?></h2>
		<p><?php _e('نسخه : 6.4', 'woocommerce-factor'); ?></p>
        </div>
    <div class="border"></div>
    <ul>
      <li class="actives"><a href="#tab-1" tab-id="1" ripple="ripple" ripple-color="#FFF">مشخصات فروشگاه</a></li>
      <li><a href="#tab-2" tab-id="2" ripple="ripple" ripple-color="#FFF">پانوشت فاکتور</a></li>
      <li><a href="#tab-3" tab-id="3" ripple="ripple" ripple-color="#FFF">تنظیمات فاکتور</a></li>
      <li><a href="#tab-4" tab-id="4" ripple="ripple" ripple-color="#FFF">قالب فاکتور</a></li>
        <li><a href="#tab-5" tab-id="5" ripple="ripple" ripple-color="#FFF">برچسب آدرس</a></li>
        <li><a href="#tab-6" tab-id="6" ripple="ripple" ripple-color="#FFF">تنظیمات ایمیل</a></li>
		<li><a href="#tab-7" tab-id="7" ripple="ripple" ripple-color="#FFF">اجزاء فاکتور</a></li>
		<li><a href="#tab-8" tab-id="8" ripple="ripple" ripple-color="#FFF">درباره طراح</a></li>
    </ul>
  </div>
<div class="tabs-content">
    <div tab-id="1" class="tab actives">
        <div class="item">
            <label for="woocommerce_factor_company_name"><b><?php _e('نام فروشگاه:', 'woocommerce-factor'); ?></b></label>

            <input type="text" name="woocommerce_factor_company_name" class="regular-text" value="<?php echo stripslashes(get_option('woocommerce_factor_company_name')); ?>"/><br/>
            <span class="description">
                <?php
    echo __('نام فروشگاه شما برای نمایش در فاکتور.', 'woocommerce-factor');
?>
            </span>
        </div>
        <div class="item">
            <label for="woocommerce_factor_logo"><b><?php _e('لگو فروشگاه:', 'woocommerce-factor'); ?></b></label>

            <input id="woocommerce_factor_logo" type="text" size="36" name="woocommerce_factor_logo" value="<?php echo get_option('woocommerce_factor_logo'); ?>"/>
            <input id="upload_image_button" type="button" value="<?php _e('بارگذاری تصویر', 'woocommerce-factor'); ?>"/>
            <br/>
            <span class="description">
                <?php
    echo __('انتخاب لگو فروشگاه برای درج در فاکتور.', 'woocommerce-factor');
?>
            </span>
        </div>
        <div class="item">
            <label for="woocommerce_factor_company_extra"><b><?php _e('درباره فروشگاه:', 'woocommerce-factor'); ?></b></label>

            <textarea name="woocommerce_factor_company_extra" cols="45" rows="3" class="regular-text"><?php echo stripslashes(get_option('woocommerce_factor_company_extra')); ?>
            </textarea>
            <span class="description"></br>
                <?php
    echo __('می توانید شماره تلفن و یا آدرس فروشگاه را واردکنید.', 'woocommerce-factor');
?>
            </span>
        </div>
	<div class="item">
            <label for="woocommerce_factor_company_code"><b><?php _e('کد اقتصادی:', 'woocommerce-factor'); ?></b></label>

            <input id="woocommerce_factor_company_code" type="text" name="woocommerce_factor_company_code" value="<?php echo get_option('woocommerce_factor_company_code'); ?>"/>
        </div>
	<div class="item">
            <label for="woocommerce_factor_company_codesabt"><b><?php _e('شماره ثبت:', 'woocommerce-factor'); ?></b></label>

            <input id="woocommerce_factor_company_codesabt" type="text" name="woocommerce_factor_company_codesabt" value="<?php echo get_option('woocommerce_factor_company_codesabt'); ?>"/>
        </div>
	<div class="item">
            <label for="woocommerce_factor_company_natid"><b><?php _e('شناسه ملی:', 'woocommerce-factor'); ?></b></label>

            <input id="woocommerce_factor_company_natid" type="text" name="woocommerce_factor_company_natid" value="<?php echo get_option('woocommerce_factor_company_natid'); ?>"/>
        </div>
    </div>
    <div tab-id="2" class="tab">

        <div class="item">
            <label for="woocommerce_factor_return_policy"><b><?php _e('توضیحات فاکتور.:', 'woocommerce-factor'); ?></b></label>

            <textarea name="woocommerce_factor_return_policy" cols="45" rows="3" class="regular-text"><?php echo stripslashes(get_option('woocommerce_factor_return_policy')); ?>
            </textarea>
            <span class="description"><br/>
                <?php
    echo __('می توانید متن توضیحات پس از فروش را وارد کنید..', 'woocommerce-factor');
?>
            </span>
        </div>
        <div class="item">
            <label for="woocommerce_factor_footer"><b><?php _e('متن پانوشت:', 'woocommerce-factor'); ?></b></label>

            <textarea name="woocommerce_factor_footer" cols="45" rows="3" class="regular-text"><?php echo stripslashes(get_option('woocommerce_factor_footer')); ?>
            </textarea>
            <span class="description"><br/>
                <?php
    echo __('متنی برای پانوشت برگه انتخاب کنید..', 'woocommerce-factor');
?>
            </span>
        </div>

    </div>
    <div tab-id="3" class="tab">
		<div class="item radio">
            <label for="preview"><b><?php _e('شماره سفارش عنوان شماره فاکتور :', 'woocommerce-factor'); ?></b></label>
			<?php if (get_option('woocommerce_factor_ordernum') == "enabled") {
?>
			<div class="toggle">
  			<input id="woocommerce_factor_ordernum" checked onClick="ordernum()" type="checkbox" class="check" >
				<div id="factor_ordernum"></div>
  			<b class="b switch"></b>
  			<b class="b track"></b>
			</div>
			<?php
    } else { ?>
			<div class="toggle">
			  <input id="woocommerce_factor_ordernum" onClick="ordernum()" type="checkbox" class="check">
				<div id="factor_ordernum"></div>
			  <b class="b switch"></b>
			  <b class="b track"></b>
			</div>
			<?php
    } ?>
			<script>
				function ordernum() {
				var check = document.getElementById("woocommerce_factor_ordernum");
				if(check.checked == true){
					//check.classList.add("actives");
					document.getElementById("factor_ordernum").innerHTML='<input type="hidden" value="enabled" name="woocommerce_factor_ordernum"/>';
				}
				else{
					//check.classList.remove("actives");
					document.getElementById("factor_ordernum").innerHTML='<input type="hidden" value="uncheched" name="woocommerce_factor_ordernum"/>';
					
				}
				}
			</script>
            
			<smal>اگر می خواهید شماره سفارش شما عنوان شماره فاکتور نمایش داده شود فعال کنید</smal>
        </div>
        
        <div class="item">
            <label for="woocommerce_factor_invoice_start" style="margin-bottom: 8px;"><b><?php _e('شماره آغازین صورت حساب:', 'woocommerce-factor'); ?></b></label>

			<div class="toggle" style="float: right;margin-left: 10px;">
  			<input onClick="frestpass()" type="checkbox" class="check" id="woocommerce_factor_reset_start" name="woocommerce_factor_reset_start" value="Yes"/>
  			<b class="b switch"></b>
  			<b class="b track"></b>
			</div>
            <p style="margin-top: 27px;"><?php _e('برگرداندن شماره های صورت حساب', 'woocommerce-factor'); ?></p>
			<div style="clear: both"></div>
			
            <input type="text" readonly id="woocommerce_factor_invoice_start" name="woocommerce_factor_invoice_start" class="regular-text" value="<?php echo wp_kses_stripslashes(get_option('woocommerce_factor_invoice_start')); ?>"/><br/>
            <smal>
                <?php
    echo __('شمارشگر فاکتور برای شروع موقعیت های سفارشی خود را به عنوان مثال 103. صفر پیشرو توان کمرنگ خواهد شد . عنوان استفاده از پیشوند.', 'woocommerce-factor');
?>
            </smal>
			<script>
				function frestpass() {
				var check = document.getElementById("woocommerce_factor_reset_start");
				if(check.checked == true){
					$('#woocommerce_factor_invoice_start').attr('readonly',false);
				}
				else{
					$('#woocommerce_factor_invoice_start').attr('readonly',true)
					
				}
				}
			</script>
        </div>

        <div class="item">
            <label for="woocommerce_factor_invoice_prefix"><b><?php _e('پیشوند شماره فاکتور:', 'woocommerce-factor'); ?></b></label>

            <input type="text" name="woocommerce_factor_invoice_prefix" class="regular-text" value="<?php echo stripslashes(get_option('woocommerce_factor_invoice_prefix')); ?>" style="font-family: verdana;text-align: left;direction: ltr;"/><br/>
            <div class="description">
                <p>مقادیر قبل از شروع شماره فاکتور </p>
				<ul>
					<li>می توانید برای سال از کلمه <span>{Y}</span> به صورت 4 رقمی استفاده کنید<li>
					<li>می توانید برای سال از کلمه <span>{y}</span> به صورت 2 رقمی استفاده کنید<li>
					<li>می توانید برای ماه از کلمه <span>{m}</span> استفاده کنید</li>
					<li>می توانید برای روز از کلمه <span>{d}</span> استفاده کنید</li>
					<li>می توانید برای ساعت از کلمه <span>{H}</span> به صورت 24 ساعته استفاده کنید</li>
					<li>می توانید برای دقیقه از کلمه <span>{N}</span> استفاده کنید</li>
					<li>می توانید برای ثانیه از کلمه <span>{H}</span> استفاده کنید</li>
			   </ul>
            </div>
        </div>

        <div class="item">
            <label for="woocommerce_factor_invoice_suffix"><b><?php _e('پسوند شماره فاکتور:', 'woocommerce-factor'); ?></b></label>

            <input type="text" name="woocommerce_factor_invoice_suffix" class="regular-text" value="<?php echo stripslashes(get_option('woocommerce_factor_invoice_suffix')); ?>" style="font-family: verdana;text-align: left;direction: ltr;"/><br/>
            <div class="description">
                <p>مقادیر بعد از شروع شماره فاکتور </p>
				<ul>
					<li>می توانید برای سال از کلمه <span>{Y}</span> به صورت 4 رقمی استفاده کنید<li>
					<li>می توانید برای سال از کلمه <span>{y}</span> به صورت 2 رقمی استفاده کنید<li>
					<li>می توانید برای ماه از کلمه <span>{m}</span> استفاده کنید</li>
					<li>می توانید برای روز از کلمه <span>{d}</span> استفاده کنید</li>
					<li>می توانید برای ساعت از کلمه <span>{H}</span> به صورت 24 ساعته استفاده کنید</li>
					<li>می توانید برای دقیقه از کلمه <span>{N}</span> استفاده کنید</li>
					<li>می توانید برای ثانیه از کلمه <span>{H}</span> استفاده کنید</li>
			   </ul>
            </div>
        </div>


		<div class="item  radio">
            <label><b><?php _e('پیشنمایش قبل از چاپ :', 'woocommerce-factor'); ?></b></label>
			<?php if (get_option('woocommerce_factor_preview') == "enabled") {
?>
			<div class="toggle">
  			<input id="woocommerce_factor_preview" checked onClick="factor_preview()" type="checkbox" class="check" >
			<div id="factor_previewshow"></div>
  			<b class="b switch"></b>
  			<b class="b track"></b>
			</div>
			<?php
    } else { ?>
			<div class="toggle">
			  <input id="woocommerce_factor_preview" onClick="factor_preview()" type="checkbox" class="check">
				<div id="factor_previewshow"></div>
			  <b class="b switch"></b>
			  <b class="b track"></b>
			</div>
			<?php
    } ?>
			<script>
				function factor_preview() {
				var check = document.getElementById("woocommerce_factor_preview");
				if(check.checked == true){
					//check.classList.add("actives");
					document.getElementById("factor_previewshow").innerHTML='<input type="hidden" value="enabled" name="woocommerce_factor_preview"/>';
				}
				else{
					//check.classList.remove("actives");
					document.getElementById("factor_previewshow").innerHTML='<input type="hidden" value="uncheched" name="woocommerce_factor_preview"/>';
					
				}
				}
			</script>
           </div>
		<div class="item  radio">
            <label><b><?php _e('فعال سازی لینک فاکتور در صفحه سفارش :', 'woocommerce-factor'); ?></b></label>
			<?php if (get_option('woocommerce_factor_linko') == "enabled") {
?>
			<div class="toggle">
  			<input id="woocommerce_factor_linko" checked onClick="factor_linko()" type="checkbox" class="check" >
			<div id="factor_linko"></div>
  			<b class="b switch"></b>
  			<b class="b track"></b>
			</div>
			<?php
    } else { ?>
			<div class="toggle">
			  <input id="woocommerce_factor_linko" onClick="factor_linko()" type="checkbox" class="check">
				<div id="factor_linko"></div>
			  <b class="b switch"></b>
			  <b class="b track"></b>
			</div>
			<?php
    } ?>
			<script>
				function factor_linko() {
				var check = document.getElementById("woocommerce_factor_linko");
				if(check.checked == true){
					//check.classList.add("actives");
					document.getElementById("factor_linko").innerHTML='<input type="hidden" value="enabled" name="woocommerce_factor_linko"/>';
				}
				else{
					//check.classList.remove("actives");
					document.getElementById("factor_linko").innerHTML='<input type="hidden" value="uncheched" name="woocommerce_factor_linko"/>';
					
				}
				}
			</script>
           </div>
		<div class="item  radio">
            <label><b><?php _e('نمایش میزان تخفیف :', 'woocommerce-factor'); ?></b></label>
			<?php if (get_option('woocommerce_factor_offo') == "enabled") {
?>
			<div class="toggle">
  			<input id="woocommerce_factor_offo" checked onClick="factor_offo()" type="checkbox" class="check" >
			<div id="factor_offo"></div>
  			<b class="b switch"></b>
  			<b class="b track"></b>
			</div>
			<?php
    } else { ?>
			<div class="toggle">
			  <input id="woocommerce_factor_offo" onClick="factor_offo()" type="checkbox" class="check">
				<div id="factor_offo"></div>
			  <b class="b switch"></b>
			  <b class="b track"></b>
			</div>
			<?php
    } ?>
			<script>
				function factor_offo() {
				var check = document.getElementById("woocommerce_factor_offo");
				if(check.checked == true){
					//check.classList.add("actives");
					document.getElementById("factor_offo").innerHTML='<input type="hidden" value="enabled" name="woocommerce_factor_offo"/>';
				}
				else{
					//check.classList.remove("actives");
					document.getElementById("factor_offo").innerHTML='<input type="hidden" value="uncheched" name="woocommerce_factor_offo"/>';
					
				}
				}
			</script>
           </div>
  <div class="item  radio">
            <label><b><?php _e('نمایش واحد شمارش محصول :', 'woocommerce-factor'); ?></b></label>
			<?php if (get_option('woocommerce_factor_vaheds') == "enabled") {
?>
			<div class="toggle">
  			<input id="woocommerce_factor_vaheds" checked onClick="factor_vaheds()" type="checkbox" class="check" >
			<div id="factor_vaheds"></div>
  			<b class="b switch"></b>
  			<b class="b track"></b>
			</div>
			<?php
    } else { ?>
			<div class="toggle">
			  <input id="woocommerce_factor_vaheds" onClick="factor_vaheds()" type="checkbox" class="check">
				<div id="factor_vaheds"></div>
			  <b class="b switch"></b>
			  <b class="b track"></b>
			</div>
			<?php
    } ?>
			<script>
				function factor_vaheds() {
				var check = document.getElementById("woocommerce_factor_vaheds");
				if(check.checked == true){
					//check.classList.add("actives");
					document.getElementById("factor_vaheds").innerHTML='<input type="hidden" value="enabled" name="woocommerce_factor_vaheds"/>';
				}
				else{
					//check.classList.remove("actives");
					document.getElementById("factor_vaheds").innerHTML='<input type="hidden" value="uncheched" name="woocommerce_factor_vaheds"/>';
					
				}
				}
			</script>
	  <smal>واحد شمارش محصول مانند (عدد،جعبه،دستگاه،رول و...)</smal>
           </div>

		<div class="item radio">
            <label for="preview"><b><?php _e('نمایش کد قفسه انبار :', 'woocommerce-factor'); ?></b></label>
			<?php if (get_option('woocommerce_factor_idpacking') == "enabled") {
?>
			<div class="toggle">
  			<input id="checkbox-item" checked onClick="myFunctionidpacking()" type="checkbox" class="check" >
			<div id="statuscheck"></div>
  			<b class="b switch"></b>
  			<b class="b track"></b>
			</div>
			<?php
    } else { ?>
			<div class="toggle">
			  <input id="checkbox-item" onClick="myFunctionidpacking()" type="checkbox" class="check">
				<div id="statuscheck"></div>
			  <b class="b switch"></b>
			  <b class="b track"></b>
			</div>
			<?php
    } ?>
			<script>
				function myFunctionidpacking() {
				var check = document.getElementById("checkbox-item");
				if(check.checked == true){
					//check.classList.add("actives");
					document.getElementById("statuscheck").innerHTML='<input type="hidden" value="enabled" name="woocommerce_factor_idpacking"/>';
				}
				else{
					//check.classList.remove("actives");
					document.getElementById("statuscheck").innerHTML='<input type="hidden" value="uncheched" name="woocommerce_factor_idpacking"/>';
					
				}
				}
			</script>
            
			<smal>شماره مکانی در انبار که محصول در آنجا وجود دارد</smal>
        </div>
		
		<div class="item  radio">
            <label><b><?php _e('نمایش تصویر محصول در فاکتور :', 'woocommerce-factor'); ?></b></label>
			<?php if (get_option('woocommerce_factor_productimg') == "enabled") {
?>
			<div class="toggle">
  			<input id="woocommerce_factor_productimg" checked onClick="factor_productimg()" type="checkbox" class="check" >
			<div id="factor_productimg"></div>
  			<b class="b switch"></b>
  			<b class="b track"></b>
			</div>
			<?php
    } else { ?>
			<div class="toggle">
			  <input id="woocommerce_factor_productimg" onClick="factor_productimg()" type="checkbox" class="check">
				<div id="factor_productimg"></div>
			  <b class="b switch"></b>
			  <b class="b track"></b>
			</div>
			<?php
    } ?>
			<script>
				function factor_productimg() {
				var check = document.getElementById("woocommerce_factor_productimg");
				if(check.checked == true){
					//check.classList.add("actives");
					document.getElementById("factor_productimg").innerHTML='<input type="hidden" value="enabled" name="woocommerce_factor_productimg"/>';
				}
				else{
					//check.classList.remove("actives");
					document.getElementById("factor_productimg").innerHTML='<input type="hidden" value="uncheched" name="woocommerce_factor_productimg"/>';
					
				}
				}
			</script>
	  <smal>نمایش تصویر شاخص محصول فاکتور</smal>
           </div>
		<div class="item  radio">
            <label><b><?php _e('نمایش صدور فاکتور در برگه تصویه حساب :', 'woocommerce-factor'); ?></b></label>
			<?php if (get_option('woocommerce_factor_getfactorco') == "enabled") {
?>
			<div class="toggle">
  			<input id="woocommerce_factor_getfactorco" checked onClick="factor_getfactorco()" type="checkbox" class="check" >
			<div id="factor_getfactorco"></div>
  			<b class="b switch"></b>
  			<b class="b track"></b>
			</div>
			<?php
    } else { ?>
			<div class="toggle">
			  <input id="woocommerce_factor_getfactorco" onClick="factor_getfactorco()" type="checkbox" class="check">
				<div id="factor_getfactorco"></div>
			  <b class="b switch"></b>
			  <b class="b track"></b>
			</div>
			<?php
    } ?>
			<script>
				function factor_getfactorco() {
				var check = document.getElementById("woocommerce_factor_getfactorco");
				if(check.checked == true){
					//check.classList.add("actives");
					document.getElementById("factor_getfactorco").innerHTML='<input type="hidden" value="enabled" name="woocommerce_factor_getfactorco"/>';
				}
				else{
					//check.classList.remove("actives");
					document.getElementById("factor_getfactorco").innerHTML='<input type="hidden" value="uncheched" name="woocommerce_factor_getfactorco"/>';
					
				}
				}
			</script>
	  <smal>ایجاد یک سوال برای مشتری که آیا نیاز به ارسال فیزیکی فاکتور سفارش  را دارید، در صفحه تسویه حساب</smal>
           </div>

    </div>
    <div tab-id="4" class="tab">
         <div class="item">
            <label for="woocommerce_factor_theme"><b><?php _e('قالب فاکتور : ', 'woocommerce-factor'); ?></b></label>
            <?php if (woocommerce_factor_theme() == "") { ?>
            <select id="select" name="woocommerce_factor_theme">
							<option value="0">قالب پیشفرض</option>
							<option value="1">قالب شماره یک</option>
							<option value="2">قالب شماره دو</option>
							 <option value="3">قالب شماره سه</option>
                            <option value="4">قالب شماره چهار مخصوص پرینترهای حرارتی</option>
							<option value="5">قالب شماره پنج</option>
							<option value="6">قالب شماره شش</option>
					</select>
					 <div id="pr"><div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>پیشنمایش قالب شماره پیشفرض</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/t3.jpg"/></div></div></div> </br>
			<script src="https://ajax.googleapis.com/ajax/libs/jquery/1.11.1/jquery.min.js"></script>
			<script type="text/javascript">
	/*<![CDATA[*/
	$( "#select" ).on( "change", function () {
			if ( this.value == "0" ) {
					document.getElementById( "pr" ).innerHTML = '<div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>پیشنمایش قالب پیشفرض</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/t1.jpg"/></div></div>';
				document.getElementById( "themecolor" ).style.display ='none';
			}
			if ( this.value == "1" ) {
					document.getElementById( "pr" ).innerHTML = '<div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>پیشنمایش قالب شماره یک</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/t2.jpg"/></div></div>';
				document.getElementById( "themecolor" ).style.display ='none';
			}
			if ( this.value == "2" ) {
					document.getElementById( "pr" ).innerHTML = '<div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>پیشنمایش قالب شماره دو</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/t3.jpg"/></div></div>';
				document.getElementById( "themecolor" ).style.display ='none';
			}
			if ( this.value == "3" ) {
					document.getElementById( "pr" ).innerHTML = '<div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>پیشنمایش قالب شماره سه</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/t4.jpg"/></div></div>';
				document.getElementById( "themecolor" ).style.display ='none';
			}
        if ( this.value == "4" ) {
					document.getElementById( "pr" ).innerHTML = '<div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>قالب شماره چهار مخصوص پرینترهای حرارتی</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/t5.jpg"/></div></div>';
				document.getElementById( "themecolor" ).style.display ='none';
			}
		if ( this.value == "5" ) {
					document.getElementById( "pr" ).innerHTML = '<div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>قالب شماره پنج</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/t6.jpg"/></div></div>';
				document.getElementById( "themecolor" ).style.display ='none';
			}
		if ( this.value == "6" ) {
					document.getElementById( "pr" ).innerHTML = '<div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>قالب شماره شش</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/t7.jpg"/></div></div>';
			        document.getElementById( "themecolor" ).style.display ='block';
			}

    } ); /*]]>*/
</script>

            <?php
    } ?>
            <?php if (woocommerce_factor_theme() == "0") { ?>
            <select id="select" name="woocommerce_factor_theme">
							<option value="0"  selected>قالب پیشفرض</option>
							<option value="1">قالب شماره یک</option>
							<option value="2">قالب شماره دو</option>
							 <option value="3">قالب شماره سه</option>
                <option value="4">قالب شماره چهار مخصوص پرینترهای حرارتی</option>
				<option value="5">قالب شماره پنج</option>
				<option value="6">قالب شماره شش</option>
					</select>
					 <div id="pr"><div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>پیشنمایش قالب شماره دو</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/t3.jpg"/></div></div></div></br>

			<script src="https://ajax.googleapis.com/ajax/libs/jquery/1.11.1/jquery.min.js"></script>
			<script type="text/javascript">
	/*<![CDATA[*/
	$( "#select" ).on( "change", function () {
			if ( this.value == "0" ) {
					document.getElementById( "pr" ).innerHTML = '<div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>پیشنمایش قالب پیشفرض</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/t1.jpg"/></div></div>';
				document.getElementById( "themecolor" ).style.display ='none';
			}
			if ( this.value == "1" ) {
					document.getElementById( "pr" ).innerHTML = '<div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>پیشنمایش قالب شماره یک</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/t2.jpg"/></div></div>';
				document.getElementById( "themecolor" ).style.display ='none';
			}
			if ( this.value == "2" ) {
					document.getElementById( "pr" ).innerHTML = '<div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>پیشنمایش قالب شماره دو</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/t3.jpg"/></div></div>';
				document.getElementById( "themecolor" ).style.display ='none';
			}
			if ( this.value == "3" ) {
					document.getElementById( "pr" ).innerHTML = '<div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>پیشنمایش قالب شماره سه</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/t4.jpg"/></div></div>';
				document.getElementById( "themecolor" ).style.display ='none';
			}
        if ( this.value == "4" ) {
					document.getElementById( "pr" ).innerHTML = '<div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>قالب شماره چهار مخصوص پرینترهای حرارتی</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/t5.jpg"/></div></div>';
				document.getElementById( "themecolor" ).style.display ='none';
			}
		if ( this.value == "5" ) {
					document.getElementById( "pr" ).innerHTML = '<div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>قالب شماره پنج</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/t6.jpg"/></div></div>';
				document.getElementById( "themecolor" ).style.display ='none';
			}
		if ( this.value == "6" ) {
					document.getElementById( "pr" ).innerHTML = '<div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>قالب شماره شش</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/t7.jpg"/></div></div>';
			        document.getElementById( "themecolor" ).style.display ='block';
			}

    } ); /*]]>*/
</script>
            <?php
    } ?>
            <?php if (woocommerce_factor_theme() == "1") { ?>
            <select id="select" name="woocommerce_factor_theme">
							<option value="0">قالب پیشفرض</option>
							<option value="1"  selected>قالب شماره یک</option>
							<option value="2">قالب شماره دو</option>
							 <option value="3">قالب شماره سه</option>
                <option value="4">قالب شماره چهار مخصوص پرینترهای حرارتی</option>
				<option value="5">قالب شماره پنج</option>
				<option value="6">قالب شماره شش</option>
					</select>
					 <div id="pr"><div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>پیشنمایش قالب شماره دو</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/t3.jpg"/></div></div></div></br>
			<script src="https://ajax.googleapis.com/ajax/libs/jquery/1.11.1/jquery.min.js"></script>
			<script type="text/javascript">
	/*<![CDATA[*/
	$( "#select" ).on( "change", function () {
			if ( this.value == "0" ) {
					document.getElementById( "pr" ).innerHTML = '<div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>پیشنمایش قالب پیشفرض</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/t1.jpg"/></div></div>';
				document.getElementById( "themecolor" ).style.display ='none';
			}
			if ( this.value == "1" ) {
					document.getElementById( "pr" ).innerHTML = '<div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>پیشنمایش قالب شماره یک</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/t2.jpg"/></div></div>';
				document.getElementById( "themecolor" ).style.display ='none';
			}
			if ( this.value == "2" ) {
					document.getElementById( "pr" ).innerHTML = '<div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>پیشنمایش قالب شماره دو</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/t3.jpg"/></div></div>';
				document.getElementById( "themecolor" ).style.display ='none';
			}
			if ( this.value == "3" ) {
					document.getElementById( "pr" ).innerHTML = '<div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>پیشنمایش قالب شماره سه</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/t4.jpg"/></div></div>';
				document.getElementById( "themecolor" ).style.display ='none';
			}
        if ( this.value == "4" ) {
					document.getElementById( "pr" ).innerHTML = '<div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>قالب شماره چهار مخصوص پرینترهای حرارتی</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/t5.jpg"/></div></div>';
				document.getElementById( "themecolor" ).style.display ='none';
			}
		if ( this.value == "5" ) {
					document.getElementById( "pr" ).innerHTML = '<div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>قالب شماره پنج</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/t6.jpg"/></div></div>';
				document.getElementById( "themecolor" ).style.display ='none';
			}
		if ( this.value == "6" ) {
					document.getElementById( "pr" ).innerHTML = '<div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>قالب شماره شش</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/t7.jpg"/></div></div>';
			        document.getElementById( "themecolor" ).style.display ='block';
			}


    } ); /*]]>*/
</script>
            <?php
    } ?>
             <?php if (woocommerce_factor_theme() == "2") { ?>
            <select id="select" name="woocommerce_factor_theme">
							<option value="0">قالب پیشفرض</option>
							<option value="1">قالب شماره یک</option>
							<option value="2"  selected>قالب شماره دو</option>
							 <option value="3">قالب شماره سه</option>
                <option value="4">قالب شماره چهار مخصوص پرینترهای حرارتی</option>
				<option value="5">قالب شماره پنج</option>
				<option value="6">قالب شماره شش</option>
					</select>
					 <div id="pr"><div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>پیشنمایش قالب شماره دو</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/t3.jpg"/></div></div></div></br>
			<script src="https://ajax.googleapis.com/ajax/libs/jquery/1.11.1/jquery.min.js"></script>
			<script type="text/javascript">
	/*<![CDATA[*/
	$( "#select" ).on( "change", function () {
			if ( this.value == "0" ) {
					document.getElementById( "pr" ).innerHTML = '<div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>پیشنمایش قالب پیشفرض</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/t1.jpg"/></div></div>';
				document.getElementById( "themecolor" ).style.display ='none';
			}
			if ( this.value == "1" ) {
					document.getElementById( "pr" ).innerHTML = '<div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>پیشنمایش قالب شماره یک</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/t2.jpg"/></div></div>';
				document.getElementById( "themecolor" ).style.display ='none';
			}
			if ( this.value == "2" ) {
					document.getElementById( "pr" ).innerHTML = '<div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>پیشنمایش قالب شماره دو</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/t3.jpg"/></div></div>';
				document.getElementById( "themecolor" ).style.display ='none';
			}
			if ( this.value == "3" ) {
					document.getElementById( "pr" ).innerHTML = '<div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>پیشنمایش قالب شماره سه</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/t4.jpg"/></div></div>';
				document.getElementById( "themecolor" ).style.display ='none';
			}
        if ( this.value == "4" ) {
					document.getElementById( "pr" ).innerHTML = '<div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>قالب شماره چهار مخصوص پرینترهای حرارتی</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/t5.jpg"/></div></div>';
				document.getElementById( "themecolor" ).style.display ='none';
			}
		if ( this.value == "5" ) {
					document.getElementById( "pr" ).innerHTML = '<div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>قالب شماره پنج</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/t6.jpg"/></div></div>';
				document.getElementById( "themecolor" ).style.display ='none';
			}
		if ( this.value == "6" ) {
					document.getElementById( "pr" ).innerHTML = '<div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>قالب شماره شش</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/t7.jpg"/></div></div>';
			        document.getElementById( "themecolor" ).style.display ='block';
			}


    } ); /*]]>*/
</script>
            <?php
    } ?>
						<?php if (woocommerce_factor_theme() == "3") { ?>
					 <select id="select" name="woocommerce_factor_theme">
							 <option value="0">قالب پیشفرض</option>
							 <option value="1">قالب شماره یک</option>
							 <option value="2">قالب شماره دو</option>
							  <option value="3" selected>قالب شماره سه</option>
                         <option value="4">قالب شماره چهار مخصوص پرینترهای حرارتی</option>
						 <option value="5">قالب شماره پنج</option>
						 <option value="6">قالب شماره شش</option>
					 </select>
						<div id="pr"><div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>پیشنمایش قالب شماره سه</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/t4.jpg"/></div></div></div></br>
			 <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.11.1/jquery.min.js"></script>
			 <script type="text/javascript">
	 /*<![CDATA[*/
	 $( "#select" ).on( "change", function () {
			 if ( this.value == "0" ) {
					document.getElementById( "pr" ).innerHTML = '<div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>پیشنمایش قالب پیشفرض</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/t1.jpg"/></div></div>';
				document.getElementById( "themecolor" ).style.display ='none';
			}
			if ( this.value == "1" ) {
					document.getElementById( "pr" ).innerHTML = '<div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>پیشنمایش قالب شماره یک</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/t2.jpg"/></div></div>';
				document.getElementById( "themecolor" ).style.display ='none';
			}
			if ( this.value == "2" ) {
					document.getElementById( "pr" ).innerHTML = '<div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>پیشنمایش قالب شماره دو</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/t3.jpg"/></div></div>';
				document.getElementById( "themecolor" ).style.display ='none';
			}
			if ( this.value == "3" ) {
					document.getElementById( "pr" ).innerHTML = '<div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>پیشنمایش قالب شماره سه</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/t4.jpg"/></div></div>';
				document.getElementById( "themecolor" ).style.display ='none';
			}
        if ( this.value == "4" ) {
					document.getElementById( "pr" ).innerHTML = '<div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>قالب شماره چهار مخصوص پرینترهای حرارتی</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/t5.jpg"/></div></div>';
				document.getElementById( "themecolor" ).style.display ='none';
			}
		if ( this.value == "5" ) {
					document.getElementById( "pr" ).innerHTML = '<div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>قالب شماره پنج</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/t6.jpg"/></div></div>';
				document.getElementById( "themecolor" ).style.display ='none';
			}
		if ( this.value == "6" ) {
					document.getElementById( "pr" ).innerHTML = '<div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>قالب شماره شش</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/t7.jpg"/></div></div>';
			        document.getElementById( "themecolor" ).style.display ='block';
			}


	 } ); /*]]>*/
</script>
					 <?php
    } ?>
             <?php if (woocommerce_factor_theme() == "4") { ?>
					 <select id="select" name="woocommerce_factor_theme">
							 <option value="0">قالب پیشفرض</option>
							 <option value="1">قالب شماره یک</option>
							 <option value="2">قالب شماره دو</option>
							  <option value="3">قالب شماره سه</option>
                         <option value="4" selected>قالب شماره چهار مخصوص پرینترهای حرارتی</option>
						 <option value="5">قالب شماره پنج</option>
						 <option value="6">قالب شماره شش</option>
					 </select>
						<div id="pr"><div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>قالب شماره چهار مخصوص پرینترهای حرارتی</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/t5.jpg"/></div></div></div></br>

			 <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.11.1/jquery.min.js"></script>
			 <script type="text/javascript">
	 /*<![CDATA[*/
	 $( "#select" ).on( "change", function () {
			 if ( this.value == "0" ) {
					document.getElementById( "pr" ).innerHTML = '<div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>پیشنمایش قالب پیشفرض</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/t1.jpg"/></div></div>';
				document.getElementById( "themecolor" ).style.display ='none';
			}
			if ( this.value == "1" ) {
					document.getElementById( "pr" ).innerHTML = '<div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>پیشنمایش قالب شماره یک</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/t2.jpg"/></div></div>';
				document.getElementById( "themecolor" ).style.display ='none';
			}
			if ( this.value == "2" ) {
					document.getElementById( "pr" ).innerHTML = '<div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>پیشنمایش قالب شماره دو</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/t3.jpg"/></div></div>';
				document.getElementById( "themecolor" ).style.display ='none';
			}
			if ( this.value == "3" ) {
					document.getElementById( "pr" ).innerHTML = '<div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>پیشنمایش قالب شماره سه</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/t4.jpg"/></div></div>';
				document.getElementById( "themecolor" ).style.display ='none';
			}
        if ( this.value == "4" ) {
					document.getElementById( "pr" ).innerHTML = '<div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>قالب شماره چهار مخصوص پرینترهای حرارتی</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/t5.jpg"/></div></div>';
				document.getElementById( "themecolor" ).style.display ='none';
			}
		if ( this.value == "5" ) {
					document.getElementById( "pr" ).innerHTML = '<div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>قالب شماره پنج</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/t6.jpg"/></div></div>';
				document.getElementById( "themecolor" ).style.display ='none';
			}
		if ( this.value == "6" ) {
					document.getElementById( "pr" ).innerHTML = '<div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>قالب شماره شش</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/t7.jpg"/></div></div>';
			        document.getElementById( "themecolor" ).style.display ='block';
			}


	 } ); /*]]>*/
</script>
					 <?php
    } ?>
			 <?php if (woocommerce_factor_theme() == "5") { ?>
					 <select id="select" name="woocommerce_factor_theme">
							 <option value="0">قالب پیشفرض</option>
							 <option value="1">قالب شماره یک</option>
							 <option value="2">قالب شماره دو</option>
							  <option value="3">قالب شماره سه</option>
                         <option value="4">قالب شماره چهار مخصوص پرینترهای حرارتی</option>
						 <option value="5" selected>قالب شماره پنج</option>
						 <option value="6">قالب شماره شش</option>
					 </select>
						<div id="pr"><div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>قالب شماره پنج</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/t6.jpg"/></div></div></div></br>
			 <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.11.1/jquery.min.js"></script>
			 <script type="text/javascript">
	 /*<![CDATA[*/
	 $( "#select" ).on( "change", function () {
			if ( this.value == "0" ) {
					document.getElementById( "pr" ).innerHTML = '<div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>پیشنمایش قالب پیشفرض</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/t1.jpg"/></div></div>';
				document.getElementById( "themecolor" ).style.display ='none';
			}
			if ( this.value == "1" ) {
					document.getElementById( "pr" ).innerHTML = '<div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>پیشنمایش قالب شماره یک</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/t2.jpg"/></div></div>';
				document.getElementById( "themecolor" ).style.display ='none';
			}
			if ( this.value == "2" ) {
					document.getElementById( "pr" ).innerHTML = '<div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>پیشنمایش قالب شماره دو</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/t3.jpg"/></div></div>';
				document.getElementById( "themecolor" ).style.display ='none';
			}
			if ( this.value == "3" ) {
					document.getElementById( "pr" ).innerHTML = '<div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>پیشنمایش قالب شماره سه</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/t4.jpg"/></div></div>';
				document.getElementById( "themecolor" ).style.display ='none';
			}
        if ( this.value == "4" ) {
					document.getElementById( "pr" ).innerHTML = '<div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>قالب شماره چهار مخصوص پرینترهای حرارتی</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/t5.jpg"/></div></div>';
				document.getElementById( "themecolor" ).style.display ='none';
			}
		if ( this.value == "5" ) {
					document.getElementById( "pr" ).innerHTML = '<div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>قالب شماره پنج</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/t6.jpg"/></div></div>';
				document.getElementById( "themecolor" ).style.display ='none';
			}
		if ( this.value == "6" ) {
					document.getElementById( "pr" ).innerHTML = '<div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>قالب شماره شش</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/t7.jpg"/></div></div>';
			        document.getElementById( "themecolor" ).style.display ='block';
			}


	 } ); /*]]>*/
</script>
					 <?php
    } ?>
			 <?php if (woocommerce_factor_theme() == "6") { 
			 $color6 = "block"
			?>
					 <select id="select" name="woocommerce_factor_theme">
							 <option value="0">قالب پیشفرض</option>
							 <option value="1">قالب شماره یک</option>
							 <option value="2">قالب شماره دو</option>
							  <option value="3">قالب شماره سه</option>
                         <option value="4">قالب شماره چهار مخصوص پرینترهای حرارتی</option>
						 <option value="5">قالب شماره پنج</option>
						 <option value="6" selected>قالب شماره شش</option>
					 </select>
						<div id="pr"><div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>قالب شماره شش</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/t7.jpg"/></div></div></div></br>
			 <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.11.1/jquery.min.js"></script>
			 <script type="text/javascript">
	 /*<![CDATA[*/
	 $( "#select" ).on( "change", function () {
			 if ( this.value == "0" ) {
					document.getElementById( "pr" ).innerHTML = '<div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>پیشنمایش قالب پیشفرض</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/t1.jpg"/></div></div>';
				document.getElementById( "themecolor" ).style.display ='none';
			}
			if ( this.value == "1" ) {
					document.getElementById( "pr" ).innerHTML = '<div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>پیشنمایش قالب شماره یک</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/t2.jpg"/></div></div>';
				document.getElementById( "themecolor" ).style.display ='none';
			}
			if ( this.value == "2" ) {
					document.getElementById( "pr" ).innerHTML = '<div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>پیشنمایش قالب شماره دو</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/t3.jpg"/></div></div>';
				document.getElementById( "themecolor" ).style.display ='none';
			}
			if ( this.value == "3" ) {
					document.getElementById( "pr" ).innerHTML = '<div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>پیشنمایش قالب شماره سه</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/t4.jpg"/></div></div>';
				document.getElementById( "themecolor" ).style.display ='none';
			}
        if ( this.value == "4" ) {
					document.getElementById( "pr" ).innerHTML = '<div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>قالب شماره چهار مخصوص پرینترهای حرارتی</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/t5.jpg"/></div></div>';
				document.getElementById( "themecolor" ).style.display ='none';
			}
		if ( this.value == "5" ) {
					document.getElementById( "pr" ).innerHTML = '<div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>قالب شماره پنج</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/t6.jpg"/></div></div>';
				document.getElementById( "themecolor" ).style.display ='none';
			}
		if ( this.value == "6" ) {
					document.getElementById( "pr" ).innerHTML = '<div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>قالب شماره شش</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/t7.jpg"/></div></div>';
			        document.getElementById( "themecolor" ).style.display ='block';
			}


	 } ); /*]]>*/
</script>
					 <?php
    } else{
		$color6 = "none";
	} ?>
				<div id="themecolor" style="display: <?php echo $color6 ;?>;">
		<div class="item-color" style="display: inline-block;margin-left: 10px;">
				<p style="font-weight: bold">رنگ المان ها فاکتور 6 : </p>
			<div class="bgcolor" style="display: inline-block;">
            <label for="woocommerce_factor_theme_bgcolor"><b><?php _e('انتخاب رنگ :', 'woocommerce-factor'); ?></b></label>
            <input type="text" style="width: 80px;float: right;margin: 0;padding: 5px 6px 6px;border-left: 0;border-radius: 0px 3px 3px 0px;margin-top: 1px;" name="woocommerce_factor_theme_bgcolor" id="themebgcolor" class="regular-text cp-i18n" value="<?php echo stripslashes(get_option('woocommerce_factor_theme_bgcolor')); ?>"/><input style="height: 34px;border: 1px solid #cad2d9;border-radius: 3px 0 0 3px;cursor: pointer;border-right: 0;margin-right: -1px;" type="color" id="colorpickerbtheme" name="color" pattern="^#+([a-fA-F0-9]{6}|[a-fA-F0-9]{3})$" value="<?php echo stripslashes(get_option('woocommerce_factor_theme_bgcolor')); ?>">
			</div>
			</div>
			<div class="item-color" style="display: inline-block;margin-left: 10px;">
				<p style="font-weight: bold">رنگ متن فاکتور 6 : </p>
			<div class="bgcolor" style="display: inline-block;">
            <label for="woocommerce_factor_theme_txcolor"><b><?php _e('انتخاب رنگ :', 'woocommerce-factor'); ?></b></label>
            <input type="text" style="width: 80px;float: right;margin: 0;padding: 5px 6px 6px;border-left: 0;border-radius: 0px 3px 3px 0px;margin-top: 1px;" name="woocommerce_factor_theme_txcolor" id="themetxcolor" class="regular-text cp-i18n" value="<?php echo stripslashes(get_option('woocommerce_factor_theme_txcolor')); ?>"/><input style="height: 34px;border: 1px solid #cad2d9;border-radius: 3px 0 0 3px;cursor: pointer;border-right: 0;margin-right: -1px;" type="color" id="colorpickertxtheme" name="color" pattern="^#+([a-fA-F0-9]{6}|[a-fA-F0-9]{3})$" value="<?php echo stripslashes(get_option('woocommerce_factor_theme_txcolor')); ?>">
			</div>
			</div>
			</div>
			<script id="rendered-js">
			  	$('#colorpickerbtheme').on('change', function () {
				  $('#themebgcolor').val(this.value);
				});
				$('#themebgcolor').on('change', function () {
				  $('#colorpickerbtheme').val(this.value);
				});
				$('#colorpickertxtheme').on('change', function () {
				  $('#themetxcolor').val(this.value);
				});
				$('#themetxcolor').on('change', function () {
				  $('#colorpickertxtheme').val(this.value);
				});
					  //# sourceURL=pen.js
			</script>
        </div>
        <div class="item">
            <label for="woocommerce_factor_fontfamily"><b><?php _e('فونت فاکتور : ', 'woocommerce-factor'); ?></b></label>
            <?php if (woocommerce_factor_fontfamily() == "") { ?>
            <select  name="woocommerce_factor_fontfamily">
                <option value="BNazanin">BNazanin</option>
                <option value="BLotus">BLotus</option>
                <option value="BYekan">BYekan</option>
            </select>

            <?php
    } ?>
            <?php if (woocommerce_factor_fontfamily() == "BNazanin") { ?>
            <select name="woocommerce_factor_fontfamily">
                <option value="BNazanin" selected>BNazanin</option>
                <option value="BLotus">BLotus</option>
                <option value="BYekan">BYekan</option>
            </select>
            <?php
    } ?>
            <?php if (woocommerce_factor_fontfamily() == "BLotus") { ?>
            <select name="woocommerce_factor_fontfamily">
                <option value="BNazanin">BNazanin</option>
                <option value="BLotus" selected>BLotus</option>
                <option value="BYekan">BYekan</option>
            </select>
            <?php
    } ?>
            <?php if (woocommerce_factor_fontfamily() == "BYekan") { ?>
            <select name="woocommerce_factor_fontfamily">
                <option value="BNazanin">BNazanin</option>
                <option value="BLotus">BLotus</option>
                <option value="BYekan" selected>BYekan</option>
            </select>
            <?php
    } ?>

        </div>
				<div class="item">
            <label for="woocommerce_factor_papersize"><b><?php _e('سایز صفحه فاکتور : ', 'woocommerce-factor'); ?></b></label>
            <?php if (woocommerce_factor_papersize() == "") { ?>
            <select  name="woocommerce_factor_papersize">
                <option value="0" selected>پیشفرض</option>
                <option value="A4">A4</option>
                <option value="A5">A5</option>
            </select>

            <?php
    } ?>
            <?php if (woocommerce_factor_papersize() == "0") { ?>
            <select name="woocommerce_factor_papersize">
                <option value="0" selected>پیشفرض</option>
                <option value="A4">A4</option>
                <option value="A5">A5</option>
            </select>
            <?php
    } ?>
            <?php if (woocommerce_factor_papersize() == "A4") { ?>
            <select name="woocommerce_factor_papersize">
							<option value="0">پیشفرض</option>
							<option value="A4" selected>A4</option>
							<option value="A5">A5</option>
            </select>
            <?php
    } ?>
            <?php if (woocommerce_factor_papersize() == "A5") { ?>
            <select name="woocommerce_factor_papersize">
							<option value="0">پیشفرض</option>
							<option value="A4">A4</option>
							<option value="A5" selected>A5</option>
            </select>
            <?php
    } ?>


        </div>
			<div class="item">
            <label for="woocommerce_factor_paperlayout"><b><?php _e('طرح بندی صفحه : ', 'woocommerce-factor'); ?></b></label>
            <?php if (woocommerce_factor_paperlayout() == "") { ?>
            <select  name="woocommerce_factor_paperlayout">
                <option value="p" selected>Portrait</option>
                <option value="l">Landscape</option>
            </select>

            <?php
    } ?>
            <?php if (woocommerce_factor_paperlayout() == "p") { ?>
            <select name="woocommerce_factor_paperlayout">
                <option value="p" selected>Portrait</option>
                <option value="l">Landscape</option>
            </select>
            <?php
    } ?>
            <?php if (woocommerce_factor_paperlayout() == "l") { ?>
            <select name="woocommerce_factor_paperlayout">
			    <option value="p">Portrait</option>
				<option value="l" selected>Landscape</option>
            </select>
            <?php
    } ?>

        </div>
        <div class="item">
            <label for="woocommerce_factor_font"><b><?php _e('سایز فونت فاکتور:', 'woocommerce-factor'); ?></b></label>

            <input type="text" name="woocommerce_factor_font" class="regular-text" value="<?php echo stripslashes(get_option('woocommerce_factor_font')); ?>"/><br/>
            <span class="description">
                <?php
    echo __('مثلا : 15، پیشفرض روی 15 می باشد', 'woocommerce-factor');
?>
            </span>
        </div>
        <div class="item">
            <label for="woocommerce_factor_margin"><b><?php _e('تنظیمات Margin فاکتور:', 'woocommerce-factor'); ?></b></label>
            <div class="margin-setting">
				<?php if(get_option('woocommerce_factor_margin_top')== 0 || get_option('woocommerce_factor_margin_top')== "") { ?>
             <div class="item-setting">
              <span>Top</span>
              <input type="number" class="num-text" id="woocommerce_factor_margin_top" name="woocommerce_factor_margin_top" value="20"/>
             </div>
				<?php } else { ?>
				<div class="item-setting">
              <span>Top</span>
              <input type="number" class="num-text" id="woocommerce_factor_margin_top" name="woocommerce_factor_margin_top" value="<?php echo stripslashes(get_option('woocommerce_factor_margin_top')); ?>"/>
             </div>
				<?php } ?>
				<?php if(get_option('woocommerce_factor_margin_bottom')== 0 || get_option('woocommerce_factor_margin_bottom')== "") { ?>
             <div class="item-setting">
              <span>Bottom</span>
              <input type="number" class="num-text" id="woocommerce_factor_margin_bottom" name="woocommerce_factor_margin_bottom" value="20"/>
             </div>
				<?php } else { ?>
				<div class="item-setting">
              <span>Bottom</span>
              <input type="number" class="num-text" id="woocommerce_factor_margin_bottom" name="woocommerce_factor_margin_bottom" value="<?php echo stripslashes(get_option('woocommerce_factor_margin_bottom')); ?>"/>
             </div>
				<?php } ?>
				<?php if(get_option('woocommerce_factor_margin_right')== 0 || get_option('woocommerce_factor_margin_right')== "") { ?>
             <div class="item-setting">
              <span>Right</span>
              <input type="number" class="num-text" id="woocommerce_factor_margin_right" name="woocommerce_factor_margin_right" value="20"/>
             </div>
				<?php } else { ?>
				<div class="item-setting">
              <span>Right</span>
              <input type="number" class="num-text" id="woocommerce_factor_margin_right" name="woocommerce_factor_margin_right" value="<?php echo stripslashes(get_option('woocommerce_factor_margin_right')); ?>"/>
             </div>
				<?php } ?>
				<?php if(get_option('woocommerce_factor_margin_left')== 0 || get_option('woocommerce_factor_margin_left')== "") { ?>
             <div class="item-setting">
              <span>Left</span>
              <input type="number" class="num-text" id="woocommerce_factor_margin_left" name="woocommerce_factor_margin_left" value="20"/>
             </div>
				<?php } else { ?>
				<div class="item-setting">
              <span>Left</span>
              <input type="number" class="num-text" id="woocommerce_factor_margin_left" name="woocommerce_factor_margin_left" value="<?php echo stripslashes(get_option('woocommerce_factor_margin_right')); ?>"/>
             </div>
				<?php } ?>
             
            </div>
            <span class="description">
                <?php
    echo __('بر فرمت پیکسل می باشد ، PX . توصیه میکنیم رو 20 تنظیم شود', 'woocommerce-factor');
?>
            </span>
        </div>
		<div class="item  radio">
            <label><b><?php _e('بارکد فاکتور :', 'woocommerce-factor'); ?></b></label>
			<?php if (get_option('woocommerce_factor_barcode') == "enabled") {
?>
			<div class="toggle">
  			<input id="woocommerce_factor_barcode" checked onClick="factor_barcode()" type="checkbox" class="check" >
			<div id="factor_barcode"></div>
  			<b class="b switch"></b>
  			<b class="b track"></b>
			</div>
			<?php
    } else { ?>
			<div class="toggle">
			  <input id="woocommerce_factor_barcode" onClick="factor_barcode()" type="checkbox" class="check">
				<div id="factor_barcode"></div>
			  <b class="b switch"></b>
			  <b class="b track"></b>
			</div>
			<?php
    } ?>
			<script>
				function factor_barcode() {
				var check = document.getElementById("woocommerce_factor_barcode");
				if(check.checked == true){
					//check.classList.add("actives");
					document.getElementById("factor_barcode").innerHTML='<input type="hidden" value="enabled" name="woocommerce_factor_barcode"/>';
				}
				else{
					//check.classList.remove("actives");
					document.getElementById("factor_barcode").innerHTML='<input type="hidden" value="uncheched" name="woocommerce_factor_barcode"/>';
					
				}
				}
			</script>

           </div>
				</br>
			<div class="item">
            <label style="margin-bottom: 7px;"><b><?php _e('نمایش عنوان فاکتور :', 'woocommerce-factor'); ?></b></label>
			<?php if (get_option('woocommerce_factor_titles') == "enabled") {
?>
			<div class="toggle">
  			<input id="woocommerce_factor_titles" checked onClick="factor_titles()" type="checkbox" class="check" >
			<div id="factor_titles"></div>
  			<b class="b switch"></b>
  			<b class="b track"></b>
			</div>
			<?php
    } else { ?>
			<div class="toggle">
			  <input id="woocommerce_factor_titles" onClick="factor_titles()" type="checkbox" class="check">
				<div id="factor_titles"></div>
			  <b class="b switch"></b>
			  <b class="b track"></b>
			</div>
			<?php
    } ?>
			<script>
				function factor_titles() {
				var check = document.getElementById("woocommerce_factor_titles");
				if(check.checked == true){
					//check.classList.add("actives");
					document.getElementById("factor_titles").innerHTML='<input type="hidden" value="enabled" name="woocommerce_factor_titles"/>';
				}
				else{
					//check.classList.remove("actives");
					document.getElementById("factor_titles").innerHTML='<input type="hidden" value="uncheched" name="woocommerce_factor_titles"/>';
					
				}
				}
			</script>

           
			<label for="woocommerce_factor_titlein"><b><?php _e('عنوان جایگزین فاکتور :', 'woocommerce-factor'); ?></b></label>

			<input type="text" name="woocommerce_factor_titlein" class="regular-text" value="<?php echo stripslashes(get_option('woocommerce_factor_titlein')); ?>"/><br/>
			<span class="description">
				<?php
    echo __('مثلا : فاکتور فروش (در مواقعی که عنوان فاکتور را غیرفعال می کنید)', 'woocommerce-factor');
?>
			</span>
		        </div>

    </div>
        <div tab-id="5" class="tab">
            <div class="item">
            <label for="woocommerce_factor_labeltheme"><b><?php _e('قالب برچسب : ', 'woocommerce-factor'); ?></b></label>
            <?php if (woocommerce_factor_labeltheme() == "") { ?>
            <select id="selects" name="woocommerce_factor_labeltheme">
                <option value="0">قالب پیشفرض</option>
                <option value="1">قالب شماره یک</option>
				<option value="2">قالب ویژه بارکد پستی</option>
            </select>
             <div id="prs"><div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>پیشنمایش قالب پیشفرض</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/l1.jpg"/></div></div></div>
        <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.11.1/jquery.min.js"></script>
        <script type="text/javascript">
    /*<![CDATA[*/
    $( "#selects" ).on( "change", function () {
       if ( this.value == "0" ) {
            document.getElementById( "prs" ).innerHTML = '<div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>پیشنمایش قالب پیشفرض</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/l1.jpg"/></div></div>'
        }
        if ( this.value == "1" ) {
            document.getElementById( "prs" ).innerHTML = '<div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>پیشنمایش قالب شماره یک</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/l2.jpg"/></div></div>'
        }
		if ( this.value == "2" ) {
            document.getElementById( "prs" ).innerHTML = '<div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>پیشنمایش قالب ویژه بارکد پستی</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/l3.jpg"/></div></div>'
        }

    } ); /*]]>*/
</script>

            <?php
    } ?>
            <?php if (woocommerce_factor_labeltheme() == "0") { ?>
            <select id="selects" name="woocommerce_factor_labeltheme">
                <option value="0" selected>قالب پیشفرض</option>
                <option value="1">قالب شماره یک</option>
				<option value="2">قالب ویژه بارکد پستی</option>
				<option value="3">قالب شماره سه</option>
            </select>
             <div id="prs"><div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>پیشنمایش قالب پیشفرض</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/l1.jpg"/></div></div></div>
        <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.11.1/jquery.min.js"></script>
        <script type="text/javascript">
    /*<![CDATA[*/
    $( "#selects" ).on( "change", function () {
        if ( this.value == "0" ) {
            document.getElementById( "prs" ).innerHTML = '<div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>پیشنمایش قالب پیشفرض</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/l1.jpg"/></div></div>'
        }
        if ( this.value == "1" ) {
            document.getElementById( "prs" ).innerHTML = '<div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>پیشنمایش قالب شماره یک</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/l2.jpg"/></div></div>'
        }
		if ( this.value == "2" ) {
            document.getElementById( "prs" ).innerHTML = '<div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>پیشنمایش قالب ویژه بارکد پستی</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/l3.jpg"/></div></div>'
        }
		if ( this.value == "3" ) {
            document.getElementById( "prs" ).innerHTML = '<div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>پیشنمایش قالب شماره سه</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/l4.jpg"/></div></div>'
        }
    } ); /*]]>*/
</script>
            <?php
    } ?>
            <?php if (woocommerce_factor_labeltheme() == "1") { ?>
            <select id="selects" name="woocommerce_factor_labeltheme">
                <option value="0">قالب پیشفرض</option>
                <option value="1" selected>قالب شماره یک</option>
				<option value="2">قالب ویژه بارکد پستی</option>
				<option value="3">قالب شماره سه</option>
            </select>
             <div id="prs"><div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>پیشنمایش قالب شماره یک</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/l2.jpg"/></div></div></div>
        <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.11.1/jquery.min.js"></script>
            <script type="text/javascript">
    /*<![CDATA[*/
    $( "#selects" ).on( "change", function () {
        if ( this.value == "0" ) {
            document.getElementById( "prs" ).innerHTML = '<div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>پیشنمایش قالب پیشفرض</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/l1.jpg"/></div></div>'
        }
        if ( this.value == "1" ) {
            document.getElementById( "prs" ).innerHTML = '<div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>پیشنمایش قالب شماره یک</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/l2.jpg"/></div></div>'
        }
		if ( this.value == "2" ) {
            document.getElementById( "prs" ).innerHTML = '<div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>پیشنمایش قالب ویژه بارکد پستی</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/l3.jpg"/></div></div>'
        }
		if ( this.value == "3" ) {
            document.getElementById( "prs" ).innerHTML = '<div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>پیشنمایش قالب شماره سه</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/l4.jpg"/></div></div>'
        }

    } ); /*]]>*/
</script>
            <?php
    } ?>
				<?php if (woocommerce_factor_labeltheme() == "2") { ?>
            <select id="selects" name="woocommerce_factor_labeltheme">
                <option value="0">قالب پیشفرض</option>
                <option value="1">قالب شماره یک</option>
				<option value="2" selected>قالب ویژه بارکد پستی</option>
				<option value="3">قالب شماره سه</option>
            </select>
             <div id="prs"><div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>پیشنمایش قالبقالب ویژه بارکد پستی</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/l1.jpg"/></div></div></div>
        <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.11.1/jquery.min.js"></script>
        <script type="text/javascript">
    /*<![CDATA[*/
    $( "#selects" ).on( "change", function () {
        if ( this.value == "0" ) {
            document.getElementById( "prs" ).innerHTML = '<div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>پیشنمایش قالب پیشفرض</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/l1.jpg"/></div></div>'
        }
        if ( this.value == "1" ) {
            document.getElementById( "prs" ).innerHTML = '<div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>پیشنمایش قالب شماره یک</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/l2.jpg"/></div></div>'
        }
		if ( this.value == "2" ) {
            document.getElementById( "prs" ).innerHTML = '<div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>پیشنمایش قالب ویژه بارکد پستی</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/l3.jpg"/></div></div>'
        }
		if ( this.value == "3" ) {
            document.getElementById( "prs" ).innerHTML = '<div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>پیشنمایش قالب شماره سه</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/l4.jpg"/></div></div>'
        }
    } ); /*]]>*/
</script>
            <?php
    } ?>
				<?php if (woocommerce_factor_labeltheme() == "3") { ?>
            <select id="selects" name="woocommerce_factor_labeltheme">
                <option value="0">قالب پیشفرض</option>
                <option value="1">قالب شماره یک</option>
				<option value="2">قالب ویژه بارکد پستی</option>
				<option value="3" selected>قالب شماره سه</option>
            </select>
             <div id="prs"><div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>پیشنمایش قالبقالب ویژه بارکد پستی</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/l4.jpg"/></div></div></div>
        <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.11.1/jquery.min.js"></script>
        <script type="text/javascript">
    /*<![CDATA[*/
    $( "#selects" ).on( "change", function () {
        if ( this.value == "0" ) {
            document.getElementById( "prs" ).innerHTML = '<div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>پیشنمایش قالب پیشفرض</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/l1.jpg"/></div></div>'
        }
        if ( this.value == "1" ) {
            document.getElementById( "prs" ).innerHTML = '<div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>پیشنمایش قالب شماره یک</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/l2.jpg"/></div></div>'
        }
		if ( this.value == "2" ) {
            document.getElementById( "prs" ).innerHTML = '<div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>پیشنمایش قالب ویژه بارکد پستی</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/l3.jpg"/></div></div>'
        }
		if ( this.value == "3" ) {
            document.getElementById( "prs" ).innerHTML = '<div class="css-popup-container"><a tabindex="0" class="btn">پیشنمایش</a><div class="css-popup"><span class="close"></span><h2>پیشنمایش قالب شماره سه</h2><img src="<?php echo woocommerce_factor_get_plugin_url() ?>/assets/images/l4.jpg"/></div></div>'
        }
    } ); /*]]>*/
</script>
            <?php
    } ?>
        </div>
			<div class="item  radio">
            <label><b><?php _e('نمایش آدرس فرستنده  :', 'woocommerce-factor'); ?></b></label>
			<?php if (get_option('woocommerce_factor_labelsend') == "enabled") {
?>
			<div class="toggle">
  			<input id="woocommerce_factor_labelsend" checked onClick="factor_labelsend()" type="checkbox" class="check" >
			<div id="factor_labelsend"></div>
  			<b class="b switch"></b>
  			<b class="b track"></b>
			</div>
			<?php
    } else { ?>
			<div class="toggle">
			  <input id="woocommerce_factor_labelsend" onClick="factor_labelsend()" type="checkbox" class="check">
				<div id="factor_labelsend"></div>
			  <b class="b switch"></b>
			  <b class="b track"></b>
			</div>
			<?php
    } ?>
			<script>
				function factor_labelsend() {
				var check = document.getElementById("woocommerce_factor_labelsend");
				if(check.checked == true){
					//check.classList.add("actives");
					document.getElementById("factor_labelsend").innerHTML='<input type="hidden" value="enabled" name="woocommerce_factor_labelsend"/>';
				}
				else{
					//check.classList.remove("actives");
					document.getElementById("factor_labelsend").innerHTML='<input type="hidden" value="uncheched" name="woocommerce_factor_labelsend"/>';
					
				}
				}
			</script>

           </div>
        <div class="item">
            <label for="woocommerce_factor_nameshop"><b><?php _e('نام فروشگاه :', 'woocommerce-factor'); ?></b></label>

            <input type="text" name="woocommerce_factor_nameshop" class="regular-text" value="<?php echo stripslashes(get_option('woocommerce_factor_nameshop')); ?>"/><br/>
            <span class="description">
                <?php
    echo __('نام فروشگاه درج در برچسب', 'woocommerce-factor');
?>
            </span>
        </div>

        <div class="item">
            <label for="woocommerce_factor_addressshop"><b><?php _e('آدرس فروشگاه : ', 'woocommerce-factor'); ?></b></label>

            <textarea name="woocommerce_factor_addressshop" cols="45" rows="3" class="regular-text"><?php echo stripslashes(get_option('woocommerce_factor_addressshop')); ?>
            </textarea>
            <span class="description"><br/>
                <?php
    echo __('آدرس فروشگاه درج در برچسب', 'woocommerce-factor');
?>
            </span>
        </div>
            <div class="item">
            <label for="woocommerce_factor_codeposti"><b><?php _e('کد پستی :', 'woocommerce-factor'); ?></b></label>

            <input type="text" name="woocommerce_factor_codeposti" class="regular-text" value="<?php echo stripslashes(get_option('woocommerce_factor_codeposti')); ?>"/><br/>
            <span class="description">
                <?php
    echo __('کدپستی فروشگاه درج در برچسب', 'woocommerce-factor');
?>
            </span>
        </div>
<div class="item">
            <label for="woocommerce_factor_phoneshop"><b><?php _e('شماره تماس :', 'woocommerce-factor'); ?></b></label>

            <input type="text" name="woocommerce_factor_phoneshop" class="regular-text" value="<?php echo stripslashes(get_option('woocommerce_factor_phoneshop')); ?>"/><br/>
            <span class="description">
                <?php
    echo __('شماره تماس فروشگاه درج در برچسب', 'woocommerce-factor');
?>
            </span>
        </div>
			<div class="item  radio">
            <label><b><?php _e('نمایش لگو در برچسب  :', 'woocommerce-factor'); ?></b></label>
			<?php if (get_option('woocommerce_factor_labellogo') == "enabled") {
?>
			<div class="toggle">
  			<input id="woocommerce_factor_labellogo" checked onClick="factor_labellogo()" type="checkbox" class="check" >
			<div id="factor_labellogo"></div>
  			<b class="b switch"></b>
  			<b class="b track"></b>
			</div>
			<?php
    } else { ?>
			<div class="toggle">
			  <input id="woocommerce_factor_labellogo" onClick="factor_labellogo()" type="checkbox" class="check">
				<div id="factor_labellogo"></div>
			  <b class="b switch"></b>
			  <b class="b track"></b>
			</div>
			<?php
    } ?>
			<script>
				function factor_labellogo() {
				var check = document.getElementById("woocommerce_factor_labellogo");
				if(check.checked == true){
					//check.classList.add("actives");
					document.getElementById("factor_labellogo").innerHTML='<input type="hidden" value="enabled" name="woocommerce_factor_labellogo"/>';
				}
				else{
					//check.classList.remove("actives");
					document.getElementById("factor_labellogo").innerHTML='<input type="hidden" value="uncheched" name="woocommerce_factor_labellogo"/>';
					
				}
				}
			</script>

           </div>
			<div class="item  radio">
            <label><b><?php _e('نمایش اطلاعات سفارش  :', 'woocommerce-factor'); ?></b></label>
			<?php if (get_option('woocommerce_factor_labelorderdes') == "enabled") {
?>
			<div class="toggle">
  			<input id="woocommerce_factor_labelorderdes" checked onClick="factor_labelorderdes()" type="checkbox" class="check" >
			<div id="factor_labelorderdes"></div>
  			<b class="b switch"></b>
  			<b class="b track"></b>
			</div>
			<?php
    } else { ?>
			<div class="toggle">
			  <input id="woocommerce_factor_labelorderdes" onClick="factor_labelorderdes()" type="checkbox" class="check">
				<div id="factor_labelorderdes"></div>
			  <b class="b switch"></b>
			  <b class="b track"></b>
			</div>
			<?php
    } ?>
			<script>
				function factor_labelorderdes() {
				var check = document.getElementById("woocommerce_factor_labelorderdes");
				if(check.checked == true){
					//check.classList.add("actives");
					document.getElementById("factor_labelorderdes").innerHTML='<input type="hidden" value="enabled" name="woocommerce_factor_labelorderdes"/>';
				}
				else{
					//check.classList.remove("actives");
					document.getElementById("factor_labelorderdes").innerHTML='<input type="hidden" value="uncheched" name="woocommerce_factor_labelorderdes"/>';
					
				}
				}
			</script>

           </div>
    </div>
   <div tab-id="6" class="tab">
	   <div class="item  radio">
            <label><b><?php _e('فعال سازی ارسال ایمیل  :', 'woocommerce-factor'); ?></b></label>
			<?php if (get_option('woocommerce_factor_send_email') == "enabled") {
?>
			<div class="toggle">
  			<input id="woocommerce_factor_send_email" checked onClick="factor_send_email()" type="checkbox" class="check" >
			<div id="factor_send_email"></div>
  			<b class="b switch"></b>
  			<b class="b track"></b>
			</div>
			<?php
    } else { ?>
			<div class="toggle">
			  <input id="woocommerce_factor_send_email" onClick="factor_send_email()" type="checkbox" class="check">
				<div id="factor_send_email"></div>
			  <b class="b switch"></b>
			  <b class="b track"></b>
			</div>
			<?php
    } ?>
			<script>
				function factor_send_email() {
				var check = document.getElementById("woocommerce_factor_send_email");
				if(check.checked == true){
					//check.classList.add("actives");
					document.getElementById("factor_send_email").innerHTML='<input type="hidden" value="enabled" name="woocommerce_factor_send_email"/>';
				}
				else{
					//check.classList.remove("actives");
					document.getElementById("factor_send_email").innerHTML='<input type="hidden" value="uncheched" name="woocommerce_factor_send_email"/>';
					
				}
				}
			</script>

           </div>
	   <div class="item  radio">
            <label><b><?php _e('ارسال صورت حساب بلافاصله بعد از ثبت سفارش  :', 'woocommerce-factor'); ?></b></label>
			<?php if (get_option('woocommerce_factor_send_emailjob') == "enabled") {
?>
			<div class="toggle">
  			<input id="woocommerce_factor_send_emailjob" checked onClick="factor_send_emailjob()" type="checkbox" class="check" >
			<div id="factor_send_emailjob"></div>
  			<b class="b switch"></b>
  			<b class="b track"></b>
			</div>
			<?php
    } else { ?>
			<div class="toggle">
			  <input id="woocommerce_factor_send_emailjob" onClick="factor_send_emailjob()" type="checkbox" class="check">
				<div id="factor_send_emailjob"></div>
			  <b class="b switch"></b>
			  <b class="b track"></b>
			</div>
			<?php
    } ?>
			<script>
				function factor_send_emailjob() {
				var check = document.getElementById("woocommerce_factor_send_emailjob");
				if(check.checked == true){
					//check.classList.add("actives");
					document.getElementById("factor_send_emailjob").innerHTML='<input type="hidden" value="enabled" name="woocommerce_factor_send_emailjob"/>';
				}
				else{
					//check.classList.remove("actives");
					document.getElementById("factor_send_emailjob").innerHTML='<input type="hidden" value="uncheched" name="woocommerce_factor_send_emailjob"/>';
					
				}
				}
			</script>

           </div>
	   <div class="item">
            <label style="margin-bottom: 7px;"><b><?php _e('فعال سازی ارسال ایمیل بسته بندی  :', 'woocommerce-factor'); ?></b></label>
			<?php if (get_option('woocommerce_factor_send_emailpack') == "enabled") {
?>
			<div class="toggle">
  			<input id="woocommerce_factor_send_emailpack" checked onClick="factor_send_emailpack()" type="checkbox" class="check" >
			<div id="factor_send_emailpack"></div>
  			<b class="b switch"></b>
  			<b class="b track"></b>
			</div>
			<?php
    } else { ?>
			<div class="toggle">
			  <input id="woocommerce_factor_send_emailpack" onClick="factor_send_emailpack()" type="checkbox" class="check">
				<div id="factor_send_emailpack"></div>
			  <b class="b switch"></b>
			  <b class="b track"></b>
			</div>
			<?php
    } ?>
			<script>
				function factor_send_emailpack() {
				var check = document.getElementById("woocommerce_factor_send_emailpack");
				if(check.checked == true){
					//check.classList.add("actives");
					document.getElementById("factor_send_emailpack").innerHTML='<input type="hidden" value="enabled" name="woocommerce_factor_send_emailpack"/>';
				}
				else{
					//check.classList.remove("actives");
					document.getElementById("factor_send_emailpack").innerHTML='<input type="hidden" value="uncheched" name="woocommerce_factor_send_emailpack"/>';
					
				}
				}
			</script>

           
            <label for="woocommerce_factor_send_emailpacklist"><b><?php _e('ایمیل گیرنده :', 'woocommerce-factor'); ?></b></label>

            <input type="text" name="woocommerce_factor_send_emailpacklist" class="regular-text" value="<?php echo stripslashes(get_option('woocommerce_factor_send_emailpacklist')); ?>"/><br/>
            <span class="description">
                <?php
    echo __('ایمیل هایی که لیست بسته بندی را دریافت می کنن ، لطفا با کاما <<,>> جدا کنید', 'woocommerce-factor');
?>
            </span>
        </div>
	    <div class="item">
			<p style="font-weight: bold">رنگ پس زمینه ایمیل : </p>
			<div class="bgcolor" style="display: inline-block;">
            <label for="woocommerce_factor_send_emailbgcolor1"><b><?php _e('رنگ پس زمینه 1 :', 'woocommerce-factor'); ?></b></label>
            <input type="text" style="width: 80px;float: right;margin: 0;padding: 5px 6px 6px;border-left: 0;border-radius: 0px 3px 3px 0px;margin-top: 1px;" name="woocommerce_factor_send_emailbgcolor1" id="emailbgcolor1" class="regular-text cp-i18n" value="<?php echo stripslashes(get_option('woocommerce_factor_send_emailbgcolor1')); ?>"/><input style="height: 34px;border: 1px solid #cad2d9;border-radius: 3px 0 0 3px;cursor: pointer;border-right: 0;margin-right: -1px;" type="color" id="colorpickerbgemail1" name="color" pattern="^#+([a-fA-F0-9]{6}|[a-fA-F0-9]{3})$" value="<?php echo stripslashes(get_option('woocommerce_factor_send_emailbgcolor1')); ?>">
			<script id="rendered-js">
      $('#colorpickerbgemail1').on('change', function () {
  $('#emailbgcolor1').val(this.value);
});
$('#emailbgcolor1').on('change', function () {
  $('#colorpickerbgemail1').val(this.value);
});
      //# sourceURL=pen.js
    </script>
			</div>
			<div class="bgcolor" style="display: inline-block;">
            <label for="woocommerce_factor_send_emailbgcolor1"><b><?php _e('رنگ پس زمینه 2 :', 'woocommerce-factor'); ?></b></label>
            <input type="text" style="width: 80px;float: right;margin: 0;padding: 5px 6px 6px;border-left: 0;border-radius: 0px 3px 3px 0px;margin-top: 1px;" name="woocommerce_factor_send_emailbgcolor2" id="emailbgcolor2" class="regular-text cp-i18n" value="<?php echo stripslashes(get_option('woocommerce_factor_send_emailbgcolor2')); ?>"/><input style="height: 34px;border: 1px solid #cad2d9;border-radius: 3px 0 0 3px;cursor: pointer;border-right: 0;margin-right: -1px;" type="color" id="colorpickerbgemail2" name="color" pattern="^#+([a-fA-F0-9]{6}|[a-fA-F0-9]{3})$" value="<?php echo stripslashes(get_option('woocommerce_factor_send_emailbgcolor2')); ?>">
			<script id="rendered-js">
      $('#colorpickerbgemail2').on('change', function () {
  $('#emailbgcolor2').val(this.value);
});
$('#emailbgcolor2').on('change', function () {
  $('#colorpickerbgemail2').val(this.value);
});
      //# sourceURL=pen.js
    </script>
			</div>
			</br>
			<span class="description">رنگ پس زمینه ایمیل را انتخاب کنید، در صورتی که می خواهید از دورنگ به صورت Gradient استفاده کنید رنگ دوم را هم انتخاب کنید</span>
        </div>
	   <div class="item">
			<p style="font-weight: bold">رنگ پس زمینه سربرگ فاکتور : </p>
			<div class="bgcolor" style="display: inline-block;">
            <label for="woocommerce_factor_send_emailbgheadcolor1"><b><?php _e('رنگ 1 :', 'woocommerce-factor'); ?></b></label>
            <input type="text" style="width: 80px;float: right;margin: 0;padding: 5px 6px 6px;border-left: 0;border-radius: 0px 3px 3px 0px;margin-top: 1px;" name="woocommerce_factor_send_emailbgheadcolor1" id="emailbgheadcolor1" class="regular-text cp-i18n" value="<?php echo stripslashes(get_option('woocommerce_factor_send_emailbgheadcolor1')); ?>"/><input style="height: 34px;border: 1px solid #cad2d9;border-radius: 3px 0 0 3px;cursor: pointer;border-right: 0;margin-right: -1px;" type="color" id="colorpickerbgheademail1" name="color" pattern="^#+([a-fA-F0-9]{6}|[a-fA-F0-9]{3})$" value="<?php echo stripslashes(get_option('woocommerce_factor_send_emailbgheadcolor1')); ?>">
			<script id="rendered-js">
      $('#colorpickerbgheademail1').on('change', function () {
  $('#emailbgheadcolor1').val(this.value);
});
$('#emailbgheadcolor1').on('change', function () {
  $('#colorpickerbgheademail1').val(this.value);
});
      //# sourceURL=pen.js
    </script>
			</div>
			<div class="bgcolor" style="display: inline-block;">
            <label for="woocommerce_factor_send_emailbgheadcolor2"><b><?php _e('رنگ 1 :', 'woocommerce-factor'); ?></b></label>
            <input type="text" style="width: 80px;float: right;margin: 0;padding: 5px 6px 6px;border-left: 0;border-radius: 0px 3px 3px 0px;margin-top: 1px;" name="woocommerce_factor_send_emailbgheadcolor2" id="emailbgheadcolor2" class="regular-text cp-i18n" value="<?php echo stripslashes(get_option('woocommerce_factor_send_emailbgheadcolor2')); ?>"/><input style="height: 34px;border: 1px solid #cad2d9;border-radius: 3px 0 0 3px;cursor: pointer;border-right: 0;margin-right: -1px;" type="color" id="colorpickerbgheademail2" name="color" pattern="^#+([a-fA-F0-9]{6}|[a-fA-F0-9]{3})$" value="<?php echo stripslashes(get_option('woocommerce_factor_send_emailbgheadcolor2')); ?>">
			<script id="rendered-js">
      $('#colorpickerbgheademail2').on('change', function () {
  $('#emailbgheadcolor2').val(this.value);
});
$('#emailbgheadcolor2').on('change', function () {
  $('#colorpickerbgheademail2').val(this.value);
});
      //# sourceURL=pen.js
    </script>
			</div>
		   </br>
			<span class="description">رنگ سربرگ فاکتور را انتخاب کنید، در صورتی که می خواهید از دورنگ به صورت Gradient استفاده کنید رنگ دوم را هم انتخاب کنید</span>
        </br>
		</br>
		</br>
			<div class="bgcolor" style="display: inline-block;">
            <label for="woocommerce_factor_send_emailtextheadcolor1"><b><?php _e('رنگ متن سربرگ :', 'woocommerce-factor'); ?></b></label>
            <input type="text" style="width: 80px;float: right;margin: 0;padding: 5px 6px 6px;border-left: 0;border-radius: 0px 3px 3px 0px;margin-top: 1px;" name="woocommerce_factor_send_emailtextheadcolor1" id="emailtextheadcolor1" class="regular-text cp-i18n" value="<?php echo stripslashes(get_option('woocommerce_factor_send_emailtextheadcolor1')); ?>"/><input style="height: 34px;border: 1px solid #cad2d9;border-radius: 3px 0 0 3px;cursor: pointer;border-right: 0;margin-right: -1px;" type="color" id="colorpickertextheademail1" name="color" pattern="^#+([a-fA-F0-9]{6}|[a-fA-F0-9]{3})$" value="<?php echo stripslashes(get_option('woocommerce_factor_send_emailtextheadcolor1')); ?>">
			<script id="rendered-js">
      $('#colorpickertextheademail1').on('change', function () {
  $('#emailtextheadcolor1').val(this.value);
});
$('#emailtextheadcolor1').on('change', function () {
  $('#colorpickertextheademail1').val(this.value);
});
      //# sourceURL=pen.js
    </script>
			</div>
		   </br>
			<span class="description">رنگ متن سربرگ</span>
        </div>
	  <div class="item">
			<p style="font-weight: bold">رنگ بندی المان های فاکتور : </p>
			<div class="bgcolor" style="display: inline-block;">
            <label for="woocommerce_factor_send_emailbgelcolor1"><b><?php _e('رنگ پس زمینه المان ها :', 'woocommerce-factor'); ?></b></label>
            <input type="text" style="width: 80px;float: right;margin: 0;padding: 5px 6px 6px;border-left: 0;border-radius: 0px 3px 3px 0px;margin-top: 1px;" name="woocommerce_factor_send_emailbgelcolor1" id="emailbgelcolor1" class="regular-text cp-i18n" value="<?php echo stripslashes(get_option('woocommerce_factor_send_emailbgelcolor1')); ?>"/><input style="height: 34px;border: 1px solid #cad2d9;border-radius: 3px 0 0 3px;cursor: pointer;border-right: 0;margin-right: -1px;" type="color" id="colorpickerbgelemail1" name="color" pattern="^#+([a-fA-F0-9]{6}|[a-fA-F0-9]{3})$" value="<?php echo stripslashes(get_option('woocommerce_factor_send_emailbgelcolor1')); ?>">
			<script id="rendered-js">
      $('#colorpickerbgelemail1').on('change', function () {
  $('#emailbgelcolor1').val(this.value);
});
$('#emailbgelcolor1').on('change', function () {
  $('#colorpickerbgelemail1').val(this.value);
});
      //# sourceURL=pen.js
    </script>
			</div>
		  <div class="bgcolor" style="display: inline-block;">
            <label for="woocommerce_factor_send_emailbgtextcolor1"><b><?php _e('رنگ متن المان ها :', 'woocommerce-factor'); ?></b></label>
            <input type="text" style="width: 80px;float: right;margin: 0;padding: 5px 6px 6px;border-left: 0;border-radius: 0px 3px 3px 0px;margin-top: 1px;" name="woocommerce_factor_send_emailbgtextcolor1" id="emailbgtextcolor1" class="regular-text cp-i18n" value="<?php echo stripslashes(get_option('woocommerce_factor_send_emailbgtextcolor1')); ?>"/><input style="height: 34px;border: 1px solid #cad2d9;border-radius: 3px 0 0 3px;cursor: pointer;border-right: 0;margin-right: -1px;" type="color" id="colorpickerbgtextemail1" name="color" pattern="^#+([a-fA-F0-9]{6}|[a-fA-F0-9]{3})$" value="<?php echo stripslashes(get_option('woocommerce_factor_send_emailbgtextcolor1')); ?>">
			<script id="rendered-js">
      $('#colorpickerbgtextemail1').on('change', function () {
  $('#emailbgtextcolor1').val(this.value);
});
$('#emailbgtextcolor1').on('change', function () {
  $('#colorpickerbgtextemail1').val(this.value);
});
      //# sourceURL=pen.js
    </script>
			</div>
		   </br>
			<span class="description">رنگ بندی المان های فاکتور همانند (سربرگ جداول و المان های دیگر)</span>
        </div>
    </div>
<div tab-id="7" class="tab">
	<div class="float-div">
	<div class="item radio">
		<h2>نام گیرنده </h2>
		<div class="radio-float">
            <label style="font-size: 13px;"><b><?php _e('نمایش در فاکتور  :', 'woocommerce-factor'); ?></b></label>
			<?php if (get_option('woocommerce_factor_shownameindactor') == "enabled" || get_option('woocommerce_factor_shownameindactor') == "") {
?>
			<div class="toggle">
  			<input id="woocommerce_factor_shownameindactor" checked onClick="factor_shownameindactor()" type="checkbox" class="check" >
			<div id="factor_shownameindactor"></div>
  			<b class="b switch"></b>
  			<b class="b track"></b>
			</div>
			<?php
    } else { ?>
			<div class="toggle">
			  <input id="woocommerce_factor_shownameindactor" onClick="factor_shownameindactor()" type="checkbox" class="check">
				<div id="factor_shownameindactor"></div>
			  <b class="b switch"></b>
			  <b class="b track"></b>
			</div>
			<?php
    } ?>
			<script>
				function factor_shownameindactor() {
				var check = document.getElementById("woocommerce_factor_shownameindactor");
				if(check.checked == true){
					//check.classList.add("actives");
					document.getElementById("factor_shownameindactor").innerHTML='<input type="hidden" value="enabled" name="woocommerce_factor_shownameindactor"/>';
				}
				else{
					//check.classList.remove("actives");
					document.getElementById("factor_shownameindactor").innerHTML='<input type="hidden" value="uncheched" name="woocommerce_factor_shownameindactor"/>';
					
				}
				}
			</script>
		</div>
		<div class="radio-float">
            <label style="font-size: 13px;"><b><?php _e('نمایش در لیست بسته بندی  :', 'woocommerce-factor'); ?></b></label>
			<?php if (get_option('woocommerce_factor_shownameinpacking') == "enabled" || get_option('woocommerce_factor_shownameinpacking') == "") {
?>
			<div class="toggle">
  			<input id="woocommerce_factor_shownameinpacking" checked onClick="factor_shownameinpacking()" type="checkbox" class="check" >
			<div id="factor_shownameinpacking"></div>
  			<b class="b switch"></b>
  			<b class="b track"></b>
			</div>
			<?php
    } else { ?>
			<div class="toggle">
			  <input id="woocommerce_factor_shownameinpacking" onClick="factor_shownameinpacking()" type="checkbox" class="check">
				<div id="factor_shownameinpacking"></div>
			  <b class="b switch"></b>
			  <b class="b track"></b>
			</div>
			<?php
    } ?>
			<script>
				function factor_shownameinpacking() {
				var check = document.getElementById("woocommerce_factor_shownameinpacking");
				if(check.checked == true){
					//check.classList.add("actives");
					document.getElementById("factor_shownameinpacking").innerHTML='<input type="hidden" value="enabled" name="woocommerce_factor_shownameinpacking"/>';
				}
				else{
					//check.classList.remove("actives");
					document.getElementById("factor_shownameinpacking").innerHTML='<input type="hidden" value="uncheched" name="woocommerce_factor_shownameinpacking"/>';
					
				}
				}
			</script>
		</div>
		<div class="radio-float">
            <label style="font-size: 13px;"><b><?php _e('نمایش در لیبل  :', 'woocommerce-factor'); ?></b></label>
			<?php if (get_option('woocommerce_factor_shownameinlabel') == "enabled" || get_option('woocommerce_factor_shownameinlabel') == "" || get_option('woocommerce_factor_shownameinlabel') == "") {
?>
			<div class="toggle">
  			<input id="woocommerce_factor_shownameinlabel" checked onClick="factor_shownameinlabel()" type="checkbox" class="check" >
			<div id="factor_shownameinlabel"></div>
  			<b class="b switch"></b>
  			<b class="b track"></b>
			</div>
			<?php
    } else { ?>
			<div class="toggle">
			  <input id="woocommerce_factor_shownameinlabel" onClick="factor_shownameinlabel()" type="checkbox" class="check">
				<div id="factor_shownameinlabel"></div>
			  <b class="b switch"></b>
			  <b class="b track"></b>
			</div>
			<?php
    } ?>
			<script>
				function factor_shownameinlabel() {
				var check = document.getElementById("woocommerce_factor_shownameinlabel");
				if(check.checked == true){
					//check.classList.add("actives");
					document.getElementById("factor_shownameinlabel").innerHTML='<input type="hidden" value="enabled" name="woocommerce_factor_shownameinlabel"/>';
				}
				else{
					//check.classList.remove("actives");
					document.getElementById("factor_shownameinlabel").innerHTML='<input type="hidden" value="uncheched" name="woocommerce_factor_shownameinlabel"/>';
					
				}
				}
			</script>
		</div>
            <label for="woocommerce_factor_bnamefamily"><b><?php _e('عنوان نام نام خانوادگی:', 'woocommerce-factor'); ?></b></label>

            <input style="opacity: 1;" type="text" name="woocommerce_factor_bnamefamily" class="regular-text" value="<?php echo stripslashes(get_option('woocommerce_factor_bnamefamily')); ?>"/>
            <span class="description">
                <?php
    echo __('عنوان پیشفرض ( نام و نام خانوادگی ) می باشد.', 'woocommerce-factor');
?>
            </span>
        </div>
	<div class="item radio">
		<h2>نام شرکت گیرنده</h2>
		<div class="radio-float">
            <label style="font-size: 13px;"><b><?php _e('نمایش در فاکتور  :', 'woocommerce-factor'); ?></b></label>
			<?php if (get_option('woocommerce_factor_showcompanyindactor') == "enabled" || get_option('woocommerce_factor_showcompanyindactor') == "") {
?>
			<div class="toggle">
  			<input id="woocommerce_factor_showcompanyindactor" checked onClick="factor_showcompanyindactor()" type="checkbox" class="check" >
			<div id="factor_showcompanyindactor"></div>
  			<b class="b switch"></b>
  			<b class="b track"></b>
			</div>
			<?php
    } else { ?>
			<div class="toggle">
			  <input id="woocommerce_factor_showcompanyindactor" onClick="factor_showcompanyindactor()" type="checkbox" class="check">
				<div id="factor_showcompanyindactor"></div>
			  <b class="b switch"></b>
			  <b class="b track"></b>
			</div>
			<?php
    } ?>
			<script>
				function factor_showcompanyindactor() {
				var check = document.getElementById("woocommerce_factor_showcompanyindactor");
				if(check.checked == true){
					//check.classList.add("actives");
					document.getElementById("factor_showcompanyindactor").innerHTML='<input type="hidden" value="enabled" name="woocommerce_factor_showcompanyindactor"/>';
				}
				else{
					//check.classList.remove("actives");
					document.getElementById("factor_showcompanyindactor").innerHTML='<input type="hidden" value="uncheched" name="woocommerce_factor_showcompanyindactor"/>';
					
				}
				}
			</script>
		</div>
		<div class="radio-float">
            <label style="font-size: 13px;"><b><?php _e('نمایش در لیست بسته بندی  :', 'woocommerce-factor'); ?></b></label>
			<?php if (get_option('woocommerce_factor_showcompanyinpacking') == "enabled" || get_option('woocommerce_factor_showcompanyinpacking') == "") {
?>
			<div class="toggle">
  			<input id="woocommerce_factor_showcompanyinpacking" checked onClick="factor_showcompanyinpacking()" type="checkbox" class="check" >
			<div id="factor_showcompanyinpacking"></div>
  			<b class="b switch"></b>
  			<b class="b track"></b>
			</div>
			<?php
    } else { ?>
			<div class="toggle">
			  <input id="woocommerce_factor_showcompanyinpacking" onClick="factor_showcompanyinpacking()" type="checkbox" class="check">
				<div id="factor_showcompanyinpacking"></div>
			  <b class="b switch"></b>
			  <b class="b track"></b>
			</div>
			<?php
    } ?>
			<script>
				function factor_showcompanyinpacking() {
				var check = document.getElementById("woocommerce_factor_showcompanyinpacking");
				if(check.checked == true){
					//check.classList.add("actives");
					document.getElementById("factor_showcompanyinpacking").innerHTML='<input type="hidden" value="enabled" name="woocommerce_factor_showcompanyinpacking"/>';
				}
				else{
					//check.classList.remove("actives");
					document.getElementById("factor_showcompanyinpacking").innerHTML='<input type="hidden" value="uncheched" name="woocommerce_factor_showcompanyinpacking"/>';
					
				}
				}
			</script>
		</div>
		<div class="radio-float">
            <label style="font-size: 13px;"><b><?php _e('نمایش در لیبل  :', 'woocommerce-factor'); ?></b></label>
			<?php if (get_option('woocommerce_factor_showcompanyinlabel') == "enabled" || get_option('woocommerce_factor_showcompanyinlabel') == "") {
?>
			<div class="toggle">
  			<input id="woocommerce_factor_showcompanyinlabel" checked onClick="factor_showcompanyinlabel()" type="checkbox" class="check" >
			<div id="factor_showcompanyinlabel"></div>
  			<b class="b switch"></b>
  			<b class="b track"></b>
			</div>
			<?php
    } else { ?>
			<div class="toggle">
			  <input id="woocommerce_factor_showcompanyinlabel" onClick="factor_showcompanyinlabel()" type="checkbox" class="check">
				<div id="factor_showcompanyinlabel"></div>
			  <b class="b switch"></b>
			  <b class="b track"></b>
			</div>
			<?php
    } ?>
			<script>
				function factor_showcompanyinlabel() {
				var check = document.getElementById("woocommerce_factor_showcompanyinlabel");
				if(check.checked == true){
					//check.classList.add("actives");
					document.getElementById("factor_showcompanyinlabel").innerHTML='<input type="hidden" value="enabled" name="woocommerce_factor_showcompanyinlabel"/>';
				}
				else{
					//check.classList.remove("actives");
					document.getElementById("factor_showcompanyinlabel").innerHTML='<input type="hidden" value="uncheched" name="woocommerce_factor_showcompanyinlabel"/>';
					
				}
				}
			</script>
		</div>
            <label for="woocommerce_factor_bcompany"><b><?php _e('عنوان شرکت:', 'woocommerce-factor'); ?></b></label>

            <input style="opacity: 1;" type="text" name="woocommerce_factor_bcompany" class="regular-text" value="<?php echo stripslashes(get_option('woocommerce_factor_bcompany')); ?>"/>
            <span class="description">
                <?php
    echo __('عنوان پیشفرض ( شرکت ) می باشد.', 'woocommerce-factor');
?>
            </span>
        </div>
	<div class="item radio">
		<h2>شماره تماس گیرنده</h2>
		<div class="radio-float">
            <label style="font-size: 13px;"><b><?php _e('نمایش در فاکتور  :', 'woocommerce-factor'); ?></b></label>
			<?php if (get_option('woocommerce_factor_showphoneindactor') == "enabled" || get_option('woocommerce_factor_showphoneindactor') == "") {
?>
			<div class="toggle">
  			<input id="woocommerce_factor_showphoneindactor" checked onClick="factor_showphoneindactor()" type="checkbox" class="check" >
			<div id="factor_showphoneindactor"></div>
  			<b class="b switch"></b>
  			<b class="b track"></b>
			</div>
			<?php
    } else { ?>
			<div class="toggle">
			  <input id="woocommerce_factor_showphoneindactor" onClick="factor_showphoneindactor()" type="checkbox" class="check">
				<div id="factor_showphoneindactor"></div>
			  <b class="b switch"></b>
			  <b class="b track"></b>
			</div>
			<?php
    } ?>
			<script>
				function factor_showphoneindactor() {
				var check = document.getElementById("woocommerce_factor_showphoneindactor");
				if(check.checked == true){
					//check.classList.add("actives");
					document.getElementById("factor_showphoneindactor").innerHTML='<input type="hidden" value="enabled" name="woocommerce_factor_showphoneindactor"/>';
				}
				else{
					//check.classList.remove("actives");
					document.getElementById("factor_showphoneindactor").innerHTML='<input type="hidden" value="uncheched" name="woocommerce_factor_showphoneindactor"/>';
					
				}
				}
			</script>
		</div>
		<div class="radio-float">
            <label style="font-size: 13px;"><b><?php _e('نمایش در لیست بسته بندی  :', 'woocommerce-factor'); ?></b></label>
			<?php if (get_option('woocommerce_factor_showphoneinpacking') == "enabled" || get_option('woocommerce_factor_showphoneinpacking') == "") {
?>
			<div class="toggle">
  			<input id="woocommerce_factor_showphoneinpacking" checked onClick="factor_showphoneinpacking()" type="checkbox" class="check" >
			<div id="factor_showphoneinpacking"></div>
  			<b class="b switch"></b>
  			<b class="b track"></b>
			</div>
			<?php
    } else { ?>
			<div class="toggle">
			  <input id="woocommerce_factor_showphoneinpacking" onClick="factor_showphoneinpacking()" type="checkbox" class="check">
				<div id="factor_showphoneinpacking"></div>
			  <b class="b switch"></b>
			  <b class="b track"></b>
			</div>
			<?php
    } ?>
			<script>
				function factor_showphoneinpacking() {
				var check = document.getElementById("woocommerce_factor_showphoneinpacking");
				if(check.checked == true){
					//check.classList.add("actives");
					document.getElementById("factor_showphoneinpacking").innerHTML='<input type="hidden" value="enabled" name="woocommerce_factor_showphoneinpacking"/>';
				}
				else{
					//check.classList.remove("actives");
					document.getElementById("factor_showphoneinpacking").innerHTML='<input type="hidden" value="uncheched" name="woocommerce_factor_showphoneinpacking"/>';
					
				}
				}
			</script>
		</div>
		<div class="radio-float">
            <label style="font-size: 13px;"><b><?php _e('نمایش در لیبل  :', 'woocommerce-factor'); ?></b></label>
			<?php if (get_option('woocommerce_factor_showphoneinlabel') == "enabled" || get_option('woocommerce_factor_showphoneinlabel') == "") {
?>
			<div class="toggle">
  			<input id="woocommerce_factor_showphoneinlabel" checked onClick="factor_showphoneinlabel()" type="checkbox" class="check" >
			<div id="factor_showphoneinlabel"></div>
  			<b class="b switch"></b>
  			<b class="b track"></b>
			</div>
			<?php
    } else { ?>
			<div class="toggle">
			  <input id="woocommerce_factor_showphoneinlabel" onClick="factor_showphoneinlabel()" type="checkbox" class="check">
				<div id="factor_showphoneinlabel"></div>
			  <b class="b switch"></b>
			  <b class="b track"></b>
			</div>
			<?php
    } ?>
			<script>
				function factor_showphoneinlabel() {
				var check = document.getElementById("woocommerce_factor_showphoneinlabel");
				if(check.checked == true){
					//check.classList.add("actives");
					document.getElementById("factor_showphoneinlabel").innerHTML='<input type="hidden" value="enabled" name="woocommerce_factor_showphoneinlabel"/>';
				}
				else{
					//check.classList.remove("actives");
					document.getElementById("factor_showphoneinlabel").innerHTML='<input type="hidden" value="uncheched" name="woocommerce_factor_showphoneinlabel"/>';
					
				}
				}
			</script>
		</div>
            <label for="woocommerce_factor_bphone"><b><?php _e('عنوان شماره تماس:', 'woocommerce-factor'); ?></b></label>

            <input style="opacity: 1;" type="text" name="woocommerce_factor_bphone" class="regular-text" value="<?php echo stripslashes(get_option('woocommerce_factor_bphone')); ?>"/>
            <span class="description">
                <?php
    echo __('عنوان پیشفرض ( شماره تماس ) می باشد.', 'woocommerce-factor');
?>
            </span>
        </div>
	<div class="item radio">
		<h2>ایمیل گیرنده</h2>
		<div class="radio-float">
            <label style="font-size: 13px;"><b><?php _e('نمایش در فاکتور  :', 'woocommerce-factor'); ?></b></label>
			<?php if (get_option('woocommerce_factor_showemailindactor') == "enabled" || get_option('woocommerce_factor_showemailindactor') == "") {
?>
			<div class="toggle">
  			<input id="woocommerce_factor_showemailindactor" checked onClick="factor_showemailindactor()" type="checkbox" class="check" >
			<div id="factor_showemailindactor"></div>
  			<b class="b switch"></b>
  			<b class="b track"></b>
			</div>
			<?php
    } else { ?>
			<div class="toggle">
			  <input id="woocommerce_factor_showemailindactor" onClick="factor_showemailindactor()" type="checkbox" class="check">
				<div id="factor_showemailindactor"></div>
			  <b class="b switch"></b>
			  <b class="b track"></b>
			</div>
			<?php
    } ?>
			<script>
				function factor_showemailindactor() {
				var check = document.getElementById("woocommerce_factor_showemailindactor");
				if(check.checked == true){
					//check.classList.add("actives");
					document.getElementById("factor_showemailindactor").innerHTML='<input type="hidden" value="enabled" name="woocommerce_factor_showemailindactor"/>';
				}
				else{
					//check.classList.remove("actives");
					document.getElementById("factor_showemailindactor").innerHTML='<input type="hidden" value="uncheched" name="woocommerce_factor_showemailindactor"/>';
					
				}
				}
			</script>
		</div>
		<div class="radio-float">
            <label style="font-size: 13px;"><b><?php _e('نمایش در لیست بسته بندی  :', 'woocommerce-factor'); ?></b></label>
			<?php if (get_option('woocommerce_factor_showemailinpacking') == "enabled" || get_option('woocommerce_factor_showemailinpacking') == "") {
?>
			<div class="toggle">
  			<input id="woocommerce_factor_showemailinpacking" checked onClick="factor_showemailinpacking()" type="checkbox" class="check" >
			<div id="factor_showemailinpacking"></div>
  			<b class="b switch"></b>
  			<b class="b track"></b>
			</div>
			<?php
    } else { ?>
			<div class="toggle">
			  <input id="woocommerce_factor_showemailinpacking" onClick="factor_showemailinpacking()" type="checkbox" class="check">
				<div id="factor_showemailinpacking"></div>
			  <b class="b switch"></b>
			  <b class="b track"></b>
			</div>
			<?php
    } ?>
			<script>
				function factor_showemailinpacking() {
				var check = document.getElementById("woocommerce_factor_showemailinpacking");
				if(check.checked == true){
					//check.classList.add("actives");
					document.getElementById("factor_showemailinpacking").innerHTML='<input type="hidden" value="enabled" name="woocommerce_factor_showemailinpacking"/>';
				}
				else{
					//check.classList.remove("actives");
					document.getElementById("factor_showemailinpacking").innerHTML='<input type="hidden" value="uncheched" name="woocommerce_factor_showemailinpacking"/>';
					
				}
				}
			</script>
		</div>
		<div class="radio-float">
            <label style="font-size: 13px;"><b><?php _e('نمایش در لیبل  :', 'woocommerce-factor'); ?></b></label>
			<?php if (get_option('woocommerce_factor_showemailinlabel') == "enabled" || get_option('woocommerce_factor_showemailinlabel') == "") {
?>
			<div class="toggle">
  			<input id="woocommerce_factor_showemailinlabel" checked onClick="factor_showemailinlabel()" type="checkbox" class="check" >
			<div id="factor_showemailinlabel"></div>
  			<b class="b switch"></b>
  			<b class="b track"></b>
			</div>
			<?php
    } else { ?>
			<div class="toggle">
			  <input id="woocommerce_factor_showemailinlabel" onClick="factor_showemailinlabel()" type="checkbox" class="check">
				<div id="factor_showemailinlabel"></div>
			  <b class="b switch"></b>
			  <b class="b track"></b>
			</div>
			<?php
    } ?>
			<script>
				function factor_showemailinlabel() {
				var check = document.getElementById("woocommerce_factor_showemailinlabel");
				if(check.checked == true){
					//check.classList.add("actives");
					document.getElementById("factor_showemailinlabel").innerHTML='<input type="hidden" value="enabled" name="woocommerce_factor_showemailinlabel"/>';
				}
				else{
					//check.classList.remove("actives");
					document.getElementById("factor_showemailinlabel").innerHTML='<input type="hidden" value="uncheched" name="woocommerce_factor_showemailinlabel"/>';
					
				}
				}
			</script>
		</div>
            <label for="woocommerce_factor_bemail"><b><?php _e('عنوان ایمیل:', 'woocommerce-factor'); ?></b></label>

            <input style="opacity: 1;" type="text" name="woocommerce_factor_bemail" class="regular-text" value="<?php echo stripslashes(get_option('woocommerce_factor_bemail')); ?>"/>
            <span class="description">
                <?php
    echo __('عنوان پیشفرض ( ایمیل ) می باشد.', 'woocommerce-factor');
?>
            </span>
        </div>
	<div class="item radio">
		<h2>آدرس گیرنده</h2>
		<div class="radio-float">
            <label style="font-size: 13px;"><b><?php _e('نمایش در فاکتور  :', 'woocommerce-factor'); ?></b></label>
			<?php if (get_option('woocommerce_factor_showaddressindactor') == "enabled" || get_option('woocommerce_factor_showaddressindactor') == "") {
?>
			<div class="toggle">
  			<input id="woocommerce_factor_showaddressindactor" checked onClick="factor_showaddressindactor()" type="checkbox" class="check" >
			<div id="factor_showaddressindactor"></div>
  			<b class="b switch"></b>
  			<b class="b track"></b>
			</div>
			<?php
    } else { ?>
			<div class="toggle">
			  <input id="woocommerce_factor_showaddressindactor" onClick="factor_showaddressindactor()" type="checkbox" class="check">
				<div id="factor_showaddressindactor"></div>
			  <b class="b switch"></b>
			  <b class="b track"></b>
			</div>
			<?php
    } ?>
			<script>
				function factor_showaddressindactor() {
				var check = document.getElementById("woocommerce_factor_showaddressindactor");
				if(check.checked == true){
					//check.classList.add("actives");
					document.getElementById("factor_showaddressindactor").innerHTML='<input type="hidden" value="enabled" name="woocommerce_factor_showaddressindactor"/>';
				}
				else{
					//check.classList.remove("actives");
					document.getElementById("factor_showaddressindactor").innerHTML='<input type="hidden" value="uncheched" name="woocommerce_factor_showaddressindactor"/>';
					
				}
				}
			</script>
		</div>
		<div class="radio-float">
            <label style="font-size: 13px;"><b><?php _e('نمایش در لیست بسته بندی  :', 'woocommerce-factor'); ?></b></label>
			<?php if (get_option('woocommerce_factor_showaddressinpacking') == "enabled" || get_option('woocommerce_factor_showaddressinpacking') == "") {
?>
			<div class="toggle">
  			<input id="woocommerce_factor_showaddressinpacking" checked onClick="factor_showaddressinpacking()" type="checkbox" class="check" >
			<div id="factor_showaddressinpacking"></div>
  			<b class="b switch"></b>
  			<b class="b track"></b>
			</div>
			<?php
    } else { ?>
			<div class="toggle">
			  <input id="woocommerce_factor_showaddressinpacking" onClick="factor_showaddressinpacking()" type="checkbox" class="check">
				<div id="factor_showaddressinpacking"></div>
			  <b class="b switch"></b>
			  <b class="b track"></b>
			</div>
			<?php
    } ?>
			<script>
				function factor_showaddressinpacking() {
				var check = document.getElementById("woocommerce_factor_showaddressinpacking");
				if(check.checked == true){
					//check.classList.add("actives");
					document.getElementById("factor_showaddressinpacking").innerHTML='<input type="hidden" value="enabled" name="woocommerce_factor_showaddressinpacking"/>';
				}
				else{
					//check.classList.remove("actives");
					document.getElementById("factor_showaddressinpacking").innerHTML='<input type="hidden" value="uncheched" name="woocommerce_factor_showaddressinpacking"/>';
					
				}
				}
			</script>
		</div>
		<div class="radio-float">
            <label style="font-size: 13px;"><b><?php _e('نمایش در لیبل  :', 'woocommerce-factor'); ?></b></label>
			<?php if (get_option('woocommerce_factor_showaddressinlabel') == "enabled" || get_option('woocommerce_factor_showaddressinlabel') == "") {
?>
			<div class="toggle">
  			<input id="woocommerce_factor_showaddressinlabel" checked onClick="factor_showaddressinlabel()" type="checkbox" class="check" >
			<div id="factor_showaddressinlabel"></div>
  			<b class="b switch"></b>
  			<b class="b track"></b>
			</div>
			<?php
    } else { ?>
			<div class="toggle">
			  <input id="woocommerce_factor_showaddressinlabel" onClick="factor_showaddressinlabel()" type="checkbox" class="check">
				<div id="factor_showaddressinlabel"></div>
			  <b class="b switch"></b>
			  <b class="b track"></b>
			</div>
			<?php
    } ?>
			<script>
				function factor_showaddressinlabel() {
				var check = document.getElementById("woocommerce_factor_showaddressinlabel");
				if(check.checked == true){
					//check.classList.add("actives");
					document.getElementById("factor_showaddressinlabel").innerHTML='<input type="hidden" value="enabled" name="woocommerce_factor_showaddressinlabel"/>';
				}
				else{
					//check.classList.remove("actives");
					document.getElementById("factor_showaddressinlabel").innerHTML='<input type="hidden" value="uncheched" name="woocommerce_factor_showaddressinlabel"/>';
					
				}
				}
			</script>
		</div>
            <label for="woocommerce_factor_baddress"><b><?php _e('عنوان آدرس:', 'woocommerce-factor'); ?></b></label>

            <input style="opacity: 1;" type="text" name="woocommerce_factor_baddress" class="regular-text" value="<?php echo stripslashes(get_option('woocommerce_factor_baddress')); ?>"/>
            <span class="description">
                <?php
    echo __('عنوان پیشفرض ( آدرس ) می باشد.', 'woocommerce-factor');
?>
            </span>
        </div>
	<div class="item radio">
		<h2>کدپستی گیرنده</h2>
		<div class="radio-float">
            <label style="font-size: 13px;"><b><?php _e('نمایش در فاکتور  :', 'woocommerce-factor'); ?></b></label>
			<?php if (get_option('woocommerce_factor_showpostcodeindactor') == "enabled" || get_option('woocommerce_factor_showpostcodeindactor') == "") {
?>
			<div class="toggle">
  			<input id="woocommerce_factor_showpostcodeindactor" checked onClick="factor_showpostcodeindactor()" type="checkbox" class="check" >
			<div id="factor_showpostcodeindactor"></div>
  			<b class="b switch"></b>
  			<b class="b track"></b>
			</div>
			<?php
    } else { ?>
			<div class="toggle">
			  <input id="woocommerce_factor_showpostcodeindactor" onClick="factor_showpostcodeindactor()" type="checkbox" class="check">
				<div id="factor_showpostcodeindactor"></div>
			  <b class="b switch"></b>
			  <b class="b track"></b>
			</div>
			<?php
    } ?>
			<script>
				function factor_showpostcodeindactor() {
				var check = document.getElementById("woocommerce_factor_showpostcodeindactor");
				if(check.checked == true){
					//check.classList.add("actives");
					document.getElementById("factor_showpostcodeindactor").innerHTML='<input type="hidden" value="enabled" name="woocommerce_factor_showpostcodeindactor"/>';
				}
				else{
					//check.classList.remove("actives");
					document.getElementById("factor_showpostcodeindactor").innerHTML='<input type="hidden" value="uncheched" name="woocommerce_factor_showpostcodeindactor"/>';
					
				}
				}
			</script>
		</div>
		<div class="radio-float">
            <label style="font-size: 13px;"><b><?php _e('نمایش در لیست بسته بندی  :', 'woocommerce-factor'); ?></b></label>
			<?php if (get_option('woocommerce_factor_showpostcodeinpacking') == "enabled" || get_option('woocommerce_factor_showpostcodeinpacking') == "") {
?>
			<div class="toggle">
  			<input id="woocommerce_factor_showpostcodeinpacking" checked onClick="factor_showpostcodeinpacking()" type="checkbox" class="check" >
			<div id="factor_showpostcodeinpacking"></div>
  			<b class="b switch"></b>
  			<b class="b track"></b>
			</div>
			<?php
    } else { ?>
			<div class="toggle">
			  <input id="woocommerce_factor_showpostcodeinpacking" onClick="factor_showpostcodeinpacking()" type="checkbox" class="check">
				<div id="factor_showpostcodeinpacking"></div>
			  <b class="b switch"></b>
			  <b class="b track"></b>
			</div>
			<?php
    } ?>
			<script>
				function factor_showpostcodeinpacking() {
				var check = document.getElementById("woocommerce_factor_showpostcodeinpacking");
				if(check.checked == true){
					//check.classList.add("actives");
					document.getElementById("factor_showpostcodeinpacking").innerHTML='<input type="hidden" value="enabled" name="woocommerce_factor_showpostcodeinpacking"/>';
				}
				else{
					//check.classList.remove("actives");
					document.getElementById("factor_showpostcodeinpacking").innerHTML='<input type="hidden" value="uncheched" name="woocommerce_factor_showpostcodeinpacking"/>';
					
				}
				}
			</script>
		</div>
		<div class="radio-float">
            <label style="font-size: 13px;"><b><?php _e('نمایش در لیبل  :', 'woocommerce-factor'); ?></b></label>
			<?php if (get_option('woocommerce_factor_showpostcodeinlabel') == "enabled" || get_option('woocommerce_factor_showpostcodeinlabel') == "") {
?>
			<div class="toggle">
  			<input id="woocommerce_factor_showpostcodeinlabel" checked onClick="factor_showpostcodeinlabel()" type="checkbox" class="check" >
			<div id="factor_showpostcodeinlabel"></div>
  			<b class="b switch"></b>
  			<b class="b track"></b>
			</div>
			<?php
    } else { ?>
			<div class="toggle">
			  <input id="woocommerce_factor_showpostcodeinlabel" onClick="factor_showpostcodeinlabel()" type="checkbox" class="check">
				<div id="factor_showpostcodeinlabel"></div>
			  <b class="b switch"></b>
			  <b class="b track"></b>
			</div>
			<?php
    } ?>
			<script>
				function factor_showpostcodeinlabel() {
				var check = document.getElementById("woocommerce_factor_showpostcodeinlabel");
				if(check.checked == true){
					//check.classList.add("actives");
					document.getElementById("factor_showpostcodeinlabel").innerHTML='<input type="hidden" value="enabled" name="woocommerce_factor_showpostcodeinlabel"/>';
				}
				else{
					//check.classList.remove("actives");
					document.getElementById("factor_showpostcodeinlabel").innerHTML='<input type="hidden" value="uncheched" name="woocommerce_factor_showpostcodeinlabel"/>';
					
				}
				}
			</script>
		</div>
            <label for="woocommerce_factor_bpostcode"><b><?php _e('عنوان کد پستی:', 'woocommerce-factor'); ?></b></label>

            <input style="opacity: 1;" type="text" name="woocommerce_factor_bpostcode" class="regular-text" value="<?php echo stripslashes(get_option('woocommerce_factor_bpostcode')); ?>"/>
            <span class="description">
                <?php
    echo __('عنوان پیشفرض ( کدپستی ) می باشد.', 'woocommerce-factor');
?>
            </span>
        </div>
	<div class="item">
            <label for="woocommerce_factor_bshipping_metod"><b><?php _e('عنوان ارسال از طریق:', 'woocommerce-factor'); ?></b></label>

            <input type="text" name="woocommerce_factor_bshipping_metod" class="regular-text" value="<?php echo stripslashes(get_option('woocommerce_factor_bshipping_metod')); ?>"/><br/>
            <span class="description">
                <?php
    echo __('عنوان پیشفرض ( ارسال از طریق ) می باشد.', 'woocommerce-factor');
?>
            </span>
        </div>
	<div class="item">
            <label for="woocommerce_factor_bpay_metod"><b><?php _e('عنوان پرداخت از طریق:', 'woocommerce-factor'); ?></b></label>

            <input type="text" name="woocommerce_factor_bpay_metod" class="regular-text" value="<?php echo stripslashes(get_option('woocommerce_factor_bpay_metod')); ?>"/><br/>
            <span class="description">
                <?php
    echo __('عنوان پیشفرض ( پرداخت از طریق ) می باشد.', 'woocommerce-factor');
?>
            </span>
        </div>
</div>
</div>
<div tab-id="8" class="tab">
	<main id="about">
<div class="header-premium header-premium--bg2">
    <div class="content">
        <span class="ff--title font-h3 first heading-inverted">طراحی شده توسط انشان وب</span>

        <p class="paragraph-readable--lg text-inverted font-xl">
            حق شما بهترین است، با انشان وب بهترین باشید
        </p>
        
        
    </div>
</div>
  <p class="detail">پیام طراح : دانلود به صورت رایگان و یا خرید از افرادی غیر از طراح حرام است و پیگرد قانونی دارد و هیچ گونه پشتیبانی ندارد.لطفا برای بهتر شدن این افزونه برای هر سایت یکبار خرید کنید با این امر به پایداری افزونه کمک کنید. باتشکر</p>
<div class="products-anshan">
	<h2>دیگر محصولات انشان وب</h2>
	<ul>
		<li>
			<div class="cover">
				<img src="<?php echo woocommerce_factor_template('uri', 'template-body.php'); ?>css/images/post.jpg"/>
			</div>
			<div class="detal">
				<p>درگاه الکترونیک شرکت پست</p>
				<a href="https://www.zhaket.com/web/woocommerce-post-webservise-plugin">خرید محصول</a>
			</div>
		</li>
	</ul>
		</div>
  </main>
</div>
  </div>
</div>

<script src="<?php echo woocommerce_factor_get_plugin_url();?>/assets/js/jquery.min.js"></script>
                        <script>$(document).ready(function () {
    var activesPos = $('.tabs-header .actives').position();
    function changePos() {
        activesPos = $('.tabs-header .actives').position();
        $('.border').stop().css({
            left: activesPos.left,
            width: $('.tabs-header .actives').width()
        });
    }
    changePos();
    var tabHeight = $('.tab.actives').height();
    function animateTabHeight() {
        tabHeight = $('.tab.actives').height();
        $('.tabs-content').stop().css({ height: tabHeight + 'px' });
    }
    animateTabHeight();
    function changeTab() {
        var getTabId = $('.tabs-header .actives a').attr('tab-id');
        $('.tab').stop().fadeOut(300, function () {
            $(this).removeClass('actives');
        }).hide();
        $('.tab[tab-id=' + getTabId + ']').stop().fadeIn(300, function () {
            $(this).addClass('actives');
            animateTabHeight();
        });
    }
    $('.tabs-header a').on('click', function (e) {
        e.preventDefault();
        var tabId = $(this).attr('tab-id');
        $('.tabs-header a').stop().parent().removeClass('actives');
        $(this).stop().parent().addClass('actives');
        changePos();
        tabCurrentItem = tabItems.filter('.actives');
        $('.tab').stop().fadeOut(300, function () {
            $(this).removeClass('actives');
        }).hide();
        $('.tab[tab-id="' + tabId + '"]').stop().fadeIn(300, function () {
            $(this).addClass('actives');
            animateTabHeight();
        });
    });
    var tabItems = $('.tabs-header ul li');
    var tabCurrentItem = tabItems.filter('.actives');
    $('#next').on('click', function (e) {
        e.preventDefault();
        var nextItem = tabCurrentItem.next();
        tabCurrentItem.removeClass('actives');
        if (nextItem.length) {
            tabCurrentItem = nextItem.addClass('actives');
        } else {
            tabCurrentItem = tabItems.first().addClass('actives');
        }
        changePos();
        changeTab();
    });
    $('#prev').on('click', function (e) {
        e.preventDefault();
        var prevItem = tabCurrentItem.prev();
        tabCurrentItem.removeClass('actives');
        if (prevItem.length) {
            tabCurrentItem = prevItem.addClass('actives');
        } else {
            tabCurrentItem = tabItems.last().addClass('actives');
        }
        changePos();
        changeTab();
    });
    $('[ripple]').on('click', function (e) {
        var rippleDiv = $('<div class="ripple" />'), rippleOffset = $(this).offset(), rippleY = e.pageY - rippleOffset.top, rippleX = e.pageX - rippleOffset.left, ripple = $('.ripple');
        rippleDiv.css({
            top: rippleY - ripple.height() / 2,
            left: rippleX - ripple.width() / 2,
            background: $(this).attr('ripple-color')
        }).appendTo($(this));
        window.setTimeout(function () {
            rippleDiv.remove();
        }, 1500);
    });
});
//# sourceURL=pen.js
</script>
<script src="<?php echo woocommerce_factor_template('uri', 'template-body.php'); ?>js/jquery.colorpicker.js"></script>

<div class="submit">
			<input type="submit" name="Submit" class="button-primary" value="<?php esc_attr_e('ذخیره تنظیمات', 'woocommerce-factor'); ?>" />
			 </div>
						
				</div>

			</form>
            </div>
		</div>
</div>
					</div>
	</div>
	<?php
}