jQuery(document).ready(function($) {
	"use strict";

	$('#woocommerce_factor_reset_start').click(function(){
		$('#woocommerce_factor_invoice_start').attr('readonly', 'readonly');
		if ($(this).is(':checked')) {
			$('#woocommerce_factor_invoice_start').removeAttr('readonly');
		}
	});

	$('#factor_settings').validate({
		rules: {
			woocommerce_factor_invoice_start: {
				min: 1,
				digits: true
			}
		}
	});

	var file_frame;

	$('#upload_image_button').click(function(){

		event.preventDefault();

		// If the media frame already exists, reopen it.
		if ( file_frame ) {
			file_frame.open();
			return;
		}

		// Create the media frame.
		file_frame = wp.media.frames.file_frame = wp.media({
			title: jQuery( this ).data( 'uploader_title' ),
			button: {
				text: jQuery( this ).data( 'uploader_button_text' ),
			},
			// Set to true to allow multiple files to be selected
			multiple: false
		});

		// When an image is selected, run a callback.
		file_frame.on( 'select', function() {
			// We set multiple to false so only get one image from the uploader
			var attachment = file_frame.state().get('selection').first().toJSON();

			// Send the value of attachment.url back to factor settings form
			jQuery('#woocommerce_factor_logo').val(attachment.url);
		});

		// Finally, open the modal
		file_frame.open();
	});

});
