<?php

/*
 * This file is part of the Symfony package.
 *
 * (c) Fabien Potencier <fabien@symfony.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace MediaCloud\Vendor\Symfony\Component\Messenger\Bridge\Redis\Transport;
use MediaCloud\Vendor\Symfony\Component\Messenger\Transport\Serialization\SerializerInterface;
use MediaCloud\Vendor\Symfony\Component\Messenger\Transport\TransportFactoryInterface;
use MediaCloud\Vendor\Symfony\Component\Messenger\Transport\TransportInterface;

/**
 * @author Alexander Schranz <alexander@suluio>
 * @author Antoine Bluchet <soyuka@gmail.com>
 */
class RedisTransportFactory implements TransportFactoryInterface
{
    public function createTransport(string $dsn, array $options, SerializerInterface $serializer): TransportInterface
    {
        unset($options['transport_name']);

        return new RedisTransport(Connection::fromDsn($dsn, $options), $serializer);
    }

    public function supports(string $dsn, array $options): bool
    {
        return 0 === strpos($dsn, 'redis://') || 0 === strpos($dsn, 'rediss://');
    }
}

if (!class_exists(\MediaCloud\Vendor\Symfony\Component\Messenger\Transport\RedisExt\RedisTransportFactory::class, false)) {
    class_alias(RedisTransportFactory::class, \MediaCloud\Vendor\Symfony\Component\Messenger\Transport\RedisExt\RedisTransportFactory::class);
}
