<?php

/**
 * Mux PHP - Copyright 2019 Mux Inc.
 * NOTE: This file is auto generated. Do not edit this file manually.
 */

namespace MediaCloud\Vendor\MuxPhp\Models;

use \ArrayAccess;
use \MediaCloud\Vendor\MuxPhp\ObjectSerializer;

/**
 * Asset Class Doc Comment
 *
 * @category Class
 * @package  MuxPhp
 */
class Asset implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
     * The original name of the model.
     *
     * @var string
     */
    protected static $openAPIModelName = 'Asset';

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @var string[]
     */
    protected static $openAPITypes = [
        'id' => 'string',
        'created_at' => 'string',
        'deleted_at' => 'string',
        'status' => 'string',
        'duration' => 'double',
        'max_stored_resolution' => 'string',
        'max_stored_frame_rate' => 'double',
        'aspect_ratio' => 'string',
        'playback_ids' => '\MediaCloud\Vendor\MuxPhp\Models\PlaybackID[]',
        'tracks' => '\MediaCloud\Vendor\MuxPhp\Models\Track[]',
        'errors' => '\MediaCloud\Vendor\MuxPhp\Models\AssetErrors',
        'per_title_encode' => 'bool',
        'is_live' => 'bool',
        'passthrough' => 'string',
        'live_stream_id' => 'string',
        'master' => '\MediaCloud\Vendor\MuxPhp\Models\AssetMaster',
        'master_access' => 'string',
        'mp4_support' => 'string',
        'normalize_audio' => 'bool',
        'static_renditions' => '\MediaCloud\Vendor\MuxPhp\Models\AssetStaticRenditions',
        'test' => 'bool'
    ];

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @var string[]
     */
    protected static $openAPIFormats = [
        'id' => null,
        'created_at' => 'int64',
        'deleted_at' => 'int64',
        'status' => null,
        'duration' => 'double',
        'max_stored_resolution' => null,
        'max_stored_frame_rate' => 'double',
        'aspect_ratio' => null,
        'playback_ids' => null,
        'tracks' => null,
        'errors' => null,
        'per_title_encode' => 'boolean',
        'is_live' => 'boolean',
        'passthrough' => null,
        'live_stream_id' => null,
        'master' => null,
        'master_access' => null,
        'mp4_support' => null,
        'normalize_audio' => null,
        'static_renditions' => null,
        'test' => 'boolean'
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'created_at' => 'created_at',
        'deleted_at' => 'deleted_at',
        'status' => 'status',
        'duration' => 'duration',
        'max_stored_resolution' => 'max_stored_resolution',
        'max_stored_frame_rate' => 'max_stored_frame_rate',
        'aspect_ratio' => 'aspect_ratio',
        'playback_ids' => 'playback_ids',
        'tracks' => 'tracks',
        'errors' => 'errors',
        'per_title_encode' => 'per_title_encode',
        'is_live' => 'is_live',
        'passthrough' => 'passthrough',
        'live_stream_id' => 'live_stream_id',
        'master' => 'master',
        'master_access' => 'master_access',
        'mp4_support' => 'mp4_support',
        'normalize_audio' => 'normalize_audio',
        'static_renditions' => 'static_renditions',
        'test' => 'test'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'created_at' => 'setCreatedAt',
        'deleted_at' => 'setDeletedAt',
        'status' => 'setStatus',
        'duration' => 'setDuration',
        'max_stored_resolution' => 'setMaxStoredResolution',
        'max_stored_frame_rate' => 'setMaxStoredFrameRate',
        'aspect_ratio' => 'setAspectRatio',
        'playback_ids' => 'setPlaybackIds',
        'tracks' => 'setTracks',
        'errors' => 'setErrors',
        'per_title_encode' => 'setPerTitleEncode',
        'is_live' => 'setIsLive',
        'passthrough' => 'setPassthrough',
        'live_stream_id' => 'setLiveStreamId',
        'master' => 'setMaster',
        'master_access' => 'setMasterAccess',
        'mp4_support' => 'setMp4Support',
        'normalize_audio' => 'setNormalizeAudio',
        'static_renditions' => 'setStaticRenditions',
        'test' => 'setTest'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'created_at' => 'getCreatedAt',
        'deleted_at' => 'getDeletedAt',
        'status' => 'getStatus',
        'duration' => 'getDuration',
        'max_stored_resolution' => 'getMaxStoredResolution',
        'max_stored_frame_rate' => 'getMaxStoredFrameRate',
        'aspect_ratio' => 'getAspectRatio',
        'playback_ids' => 'getPlaybackIds',
        'tracks' => 'getTracks',
        'errors' => 'getErrors',
        'per_title_encode' => 'getPerTitleEncode',
        'is_live' => 'getIsLive',
        'passthrough' => 'getPassthrough',
        'live_stream_id' => 'getLiveStreamId',
        'master' => 'getMaster',
        'master_access' => 'getMasterAccess',
        'mp4_support' => 'getMp4Support',
        'normalize_audio' => 'getNormalizeAudio',
        'static_renditions' => 'getStaticRenditions',
        'test' => 'getTest'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    const MASTER_ACCESS_TEMPORARY = 'temporary';
    const MASTER_ACCESS_NONE = 'none';
    const MP4_SUPPORT_STANDARD = 'standard';
    const MP4_SUPPORT_NONE = 'none';
    

    
    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getMasterAccessAllowableValues()
    {
        return [
            self::MASTER_ACCESS_TEMPORARY,
            self::MASTER_ACCESS_NONE,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getMp4SupportAllowableValues()
    {
        return [
            self::MP4_SUPPORT_STANDARD,
            self::MP4_SUPPORT_NONE,
        ];
    }
    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['created_at'] = isset($data['created_at']) ? $data['created_at'] : null;
        $this->container['deleted_at'] = isset($data['deleted_at']) ? $data['deleted_at'] : null;
        $this->container['status'] = isset($data['status']) ? $data['status'] : null;
        $this->container['duration'] = isset($data['duration']) ? $data['duration'] : null;
        $this->container['max_stored_resolution'] = isset($data['max_stored_resolution']) ? $data['max_stored_resolution'] : null;
        $this->container['max_stored_frame_rate'] = isset($data['max_stored_frame_rate']) ? $data['max_stored_frame_rate'] : null;
        $this->container['aspect_ratio'] = isset($data['aspect_ratio']) ? $data['aspect_ratio'] : null;
        $this->container['playback_ids'] = isset($data['playback_ids']) ? $data['playback_ids'] : null;
        $this->container['tracks'] = isset($data['tracks']) ? $data['tracks'] : null;
        $this->container['errors'] = isset($data['errors']) ? $data['errors'] : null;
        $this->container['per_title_encode'] = isset($data['per_title_encode']) ? $data['per_title_encode'] : null;
        $this->container['is_live'] = isset($data['is_live']) ? $data['is_live'] : null;
        $this->container['passthrough'] = isset($data['passthrough']) ? $data['passthrough'] : null;
        $this->container['live_stream_id'] = isset($data['live_stream_id']) ? $data['live_stream_id'] : null;
        $this->container['master'] = isset($data['master']) ? $data['master'] : null;
        $this->container['master_access'] = isset($data['master_access']) ? $data['master_access'] : 'none';
        $this->container['mp4_support'] = isset($data['mp4_support']) ? $data['mp4_support'] : 'none';
        $this->container['normalize_audio'] = isset($data['normalize_audio']) ? $data['normalize_audio'] : false;
        $this->container['static_renditions'] = isset($data['static_renditions']) ? $data['static_renditions'] : null;
        $this->container['test'] = isset($data['test']) ? $data['test'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        $allowedValues = $this->getMasterAccessAllowableValues();
        if (!is_null($this->container['master_access']) && !in_array($this->container['master_access'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value for 'master_access', must be one of '%s'",
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getMp4SupportAllowableValues();
        if (!is_null($this->container['mp4_support']) && !in_array($this->container['mp4_support'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value for 'mp4_support', must be one of '%s'",
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return string|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param string|null $id id
     *
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets created_at
     *
     * @return string|null
     */
    public function getCreatedAt()
    {
        return $this->container['created_at'];
    }

    /**
     * Sets created_at
     *
     * @param string|null $created_at created_at
     *
     * @return $this
     */
    public function setCreatedAt($created_at)
    {
        $this->container['created_at'] = $created_at;

        return $this;
    }

    /**
     * Gets deleted_at
     *
     * @return string|null
     */
    public function getDeletedAt()
    {
        return $this->container['deleted_at'];
    }

    /**
     * Sets deleted_at
     *
     * @param string|null $deleted_at deleted_at
     *
     * @return $this
     */
    public function setDeletedAt($deleted_at)
    {
        $this->container['deleted_at'] = $deleted_at;

        return $this;
    }

    /**
     * Gets status
     *
     * @return string|null
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     *
     * @param string|null $status status
     *
     * @return $this
     */
    public function setStatus($status)
    {
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets duration
     *
     * @return double|null
     */
    public function getDuration()
    {
        return $this->container['duration'];
    }

    /**
     * Sets duration
     *
     * @param double|null $duration duration
     *
     * @return $this
     */
    public function setDuration($duration)
    {
        $this->container['duration'] = $duration;

        return $this;
    }

    /**
     * Gets max_stored_resolution
     *
     * @return string|null
     */
    public function getMaxStoredResolution()
    {
        return $this->container['max_stored_resolution'];
    }

    /**
     * Sets max_stored_resolution
     *
     * @param string|null $max_stored_resolution max_stored_resolution
     *
     * @return $this
     */
    public function setMaxStoredResolution($max_stored_resolution)
    {
        $this->container['max_stored_resolution'] = $max_stored_resolution;

        return $this;
    }

    /**
     * Gets max_stored_frame_rate
     *
     * @return double|null
     */
    public function getMaxStoredFrameRate()
    {
        return $this->container['max_stored_frame_rate'];
    }

    /**
     * Sets max_stored_frame_rate
     *
     * @param double|null $max_stored_frame_rate max_stored_frame_rate
     *
     * @return $this
     */
    public function setMaxStoredFrameRate($max_stored_frame_rate)
    {
        $this->container['max_stored_frame_rate'] = $max_stored_frame_rate;

        return $this;
    }

    /**
     * Gets aspect_ratio
     *
     * @return string|null
     */
    public function getAspectRatio()
    {
        return $this->container['aspect_ratio'];
    }

    /**
     * Sets aspect_ratio
     *
     * @param string|null $aspect_ratio aspect_ratio
     *
     * @return $this
     */
    public function setAspectRatio($aspect_ratio)
    {
        $this->container['aspect_ratio'] = $aspect_ratio;

        return $this;
    }

    /**
     * Gets playback_ids
     *
     * @return \MediaCloud\Vendor\MuxPhp\Models\PlaybackID[]|null
     */
    public function getPlaybackIds()
    {
        return $this->container['playback_ids'];
    }

    /**
     * Sets playback_ids
     *
     * @param \MediaCloud\Vendor\MuxPhp\Models\PlaybackID[]|null $playback_ids playback_ids
     *
     * @return $this
     */
    public function setPlaybackIds($playback_ids)
    {
        $this->container['playback_ids'] = $playback_ids;

        return $this;
    }

    /**
     * Gets tracks
     *
     * @return \MediaCloud\Vendor\MuxPhp\Models\Track[]|null
     */
    public function getTracks()
    {
        return $this->container['tracks'];
    }

    /**
     * Sets tracks
     *
     * @param \MediaCloud\Vendor\MuxPhp\Models\Track[]|null $tracks tracks
     *
     * @return $this
     */
    public function setTracks($tracks)
    {
        $this->container['tracks'] = $tracks;

        return $this;
    }

    /**
     * Gets errors
     *
     * @return \MediaCloud\Vendor\MuxPhp\Models\AssetErrors|null
     */
    public function getErrors()
    {
        return $this->container['errors'];
    }

    /**
     * Sets errors
     *
     * @param \MediaCloud\Vendor\MuxPhp\Models\AssetErrors|null $errors errors
     *
     * @return $this
     */
    public function setErrors($errors)
    {
        $this->container['errors'] = $errors;

        return $this;
    }

    /**
     * Gets per_title_encode
     *
     * @return bool|null
     */
    public function getPerTitleEncode()
    {
        return $this->container['per_title_encode'];
    }

    /**
     * Sets per_title_encode
     *
     * @param bool|null $per_title_encode per_title_encode
     *
     * @return $this
     */
    public function setPerTitleEncode($per_title_encode)
    {
        $this->container['per_title_encode'] = $per_title_encode;

        return $this;
    }

    /**
     * Gets is_live
     *
     * @return bool|null
     */
    public function getIsLive()
    {
        return $this->container['is_live'];
    }

    /**
     * Sets is_live
     *
     * @param bool|null $is_live is_live
     *
     * @return $this
     */
    public function setIsLive($is_live)
    {
        $this->container['is_live'] = $is_live;

        return $this;
    }

    /**
     * Gets passthrough
     *
     * @return string|null
     */
    public function getPassthrough()
    {
        return $this->container['passthrough'];
    }

    /**
     * Sets passthrough
     *
     * @param string|null $passthrough passthrough
     *
     * @return $this
     */
    public function setPassthrough($passthrough)
    {
        $this->container['passthrough'] = $passthrough;

        return $this;
    }

    /**
     * Gets live_stream_id
     *
     * @return string|null
     */
    public function getLiveStreamId()
    {
        return $this->container['live_stream_id'];
    }

    /**
     * Sets live_stream_id
     *
     * @param string|null $live_stream_id live_stream_id
     *
     * @return $this
     */
    public function setLiveStreamId($live_stream_id)
    {
        $this->container['live_stream_id'] = $live_stream_id;

        return $this;
    }

    /**
     * Gets master
     *
     * @return \MediaCloud\Vendor\MuxPhp\Models\AssetMaster|null
     */
    public function getMaster()
    {
        return $this->container['master'];
    }

    /**
     * Sets master
     *
     * @param \MediaCloud\Vendor\MuxPhp\Models\AssetMaster|null $master master
     *
     * @return $this
     */
    public function setMaster($master)
    {
        $this->container['master'] = $master;

        return $this;
    }

    /**
     * Gets master_access
     *
     * @return string|null
     */
    public function getMasterAccess()
    {
        return $this->container['master_access'];
    }

    /**
     * Sets master_access
     *
     * @param string|null $master_access master_access
     *
     * @return $this
     */
    public function setMasterAccess($master_access)
    {
        $allowedValues = $this->getMasterAccessAllowableValues();
        if (!is_null($master_access) && !in_array($master_access, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value for 'master_access', must be one of '%s'",
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['master_access'] = $master_access;

        return $this;
    }

    /**
     * Gets mp4_support
     *
     * @return string|null
     */
    public function getMp4Support()
    {
        return $this->container['mp4_support'];
    }

    /**
     * Sets mp4_support
     *
     * @param string|null $mp4_support mp4_support
     *
     * @return $this
     */
    public function setMp4Support($mp4_support)
    {
        $allowedValues = $this->getMp4SupportAllowableValues();
        if (!is_null($mp4_support) && !in_array($mp4_support, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value for 'mp4_support', must be one of '%s'",
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['mp4_support'] = $mp4_support;

        return $this;
    }

    /**
     * Gets normalize_audio
     *
     * @return bool|null
     */
    public function getNormalizeAudio()
    {
        return $this->container['normalize_audio'];
    }

    /**
     * Sets normalize_audio
     *
     * @param bool|null $normalize_audio normalize_audio
     *
     * @return $this
     */
    public function setNormalizeAudio($normalize_audio)
    {
        $this->container['normalize_audio'] = $normalize_audio;

        return $this;
    }

    /**
     * Gets static_renditions
     *
     * @return \MediaCloud\Vendor\MuxPhp\Models\AssetStaticRenditions|null
     */
    public function getStaticRenditions()
    {
        return $this->container['static_renditions'];
    }

    /**
     * Sets static_renditions
     *
     * @param \MediaCloud\Vendor\MuxPhp\Models\AssetStaticRenditions|null $static_renditions static_renditions
     *
     * @return $this
     */
    public function setStaticRenditions($static_renditions)
    {
        $this->container['static_renditions'] = $static_renditions;

        return $this;
    }

    /**
     * Gets test
     *
     * @return bool|null
     */
    public function getTest()
    {
        return $this->container['test'];
    }

    /**
     * Sets test
     *
     * @param bool|null $test test
     *
     * @return $this
     */
    public function setTest($test)
    {
        $this->container['test'] = $test;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }
}


