<?php

/**
 * Mux PHP - Copyright 2019 Mux Inc.
 * NOTE: This file is auto generated. Do not edit this file manually.
 */

namespace MediaCloud\Vendor\MuxPhp\Api;
use MediaCloud\Vendor\GuzzleHttp\Client;
use MediaCloud\Vendor\GuzzleHttp\ClientInterface;
use MediaCloud\Vendor\GuzzleHttp\Exception\RequestException;
use MediaCloud\Vendor\GuzzleHttp\Psr7\MultipartStream;
use MediaCloud\Vendor\GuzzleHttp\Psr7\Request;
use MediaCloud\Vendor\GuzzleHttp\RequestOptions;
use MediaCloud\Vendor\MuxPhp\ApiException;
use MediaCloud\Vendor\MuxPhp\Configuration;
use MediaCloud\Vendor\MuxPhp\HeaderSelector;
use MediaCloud\Vendor\MuxPhp\ObjectSerializer;

/**
 * DirectUploadsApi Class Doc Comment
 *
 * @category Class
 * @package  MuxPhp
 */
class DirectUploadsApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $host_index (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,
        $host_index = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $host_index;
    }

    /**
     * Set the host index
     *
     * @param  int $host_index Host index (required)
     */
    public function setHostIndex($host_index)
    {
        $this->hostIndex = $host_index;
    }

    /**
     * Get the host index
     *
     * @return Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation cancelDirectUpload
     *
     * Cancel a direct upload
     *
     * @param  string $upload_id ID of the Upload (required)
     *
     * @throws \MediaCloud\Vendor\MuxPhp\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \MediaCloud\Vendor\MuxPhp\Models\UploadResponse
     */
    public function cancelDirectUpload($upload_id)
    {
        list($response) = $this->cancelDirectUploadWithHttpInfo($upload_id);
        return $response;
    }

    /**
     * Operation cancelDirectUploadWithHttpInfo
     *
     * Cancel a direct upload
     *
     * @param  string $upload_id ID of the Upload (required)
     *
     * @throws \MediaCloud\Vendor\MuxPhp\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \MediaCloud\Vendor\MuxPhp\Models\UploadResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function cancelDirectUploadWithHttpInfo($upload_id)
    {
        $request = $this->cancelDirectUploadRequest($upload_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\MediaCloud\Vendor\MuxPhp\Models\UploadResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\MediaCloud\Vendor\MuxPhp\Models\UploadResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\MediaCloud\Vendor\MuxPhp\Models\UploadResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\MediaCloud\Vendor\MuxPhp\Models\UploadResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation cancelDirectUploadAsync
     *
     * Cancel a direct upload
     *
     * @param  string $upload_id ID of the Upload (required)
     *
     * @throws \InvalidArgumentException
     * @return \MediaCloud\Vendor\GuzzleHttp\Promise\PromiseInterface
     */
    public function cancelDirectUploadAsync($upload_id)
    {
        return $this->cancelDirectUploadAsyncWithHttpInfo($upload_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation cancelDirectUploadAsyncWithHttpInfo
     *
     * Cancel a direct upload
     *
     * @param  string $upload_id ID of the Upload (required)
     *
     * @throws \InvalidArgumentException
     * @return \MediaCloud\Vendor\GuzzleHttp\Promise\PromiseInterface
     */
    public function cancelDirectUploadAsyncWithHttpInfo($upload_id)
    {
        $returnType = '\MediaCloud\Vendor\MuxPhp\Models\UploadResponse';
        $request = $this->cancelDirectUploadRequest($upload_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'cancelDirectUpload'
     *
     * @param  string $upload_id ID of the Upload (required)
     *
     * @throws \InvalidArgumentException
     * @return \MediaCloud\Vendor\GuzzleHttp\Psr7\Request
     */
    protected function cancelDirectUploadRequest($upload_id)
    {
        // verify the required parameter 'upload_id' is set
        if ($upload_id === null || (is_array($upload_id) && count($upload_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $upload_id when calling cancelDirectUpload'
            );
        }

        $resourcePath = '/video/v1/uploads/{UPLOAD_ID}/cancel';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($upload_id !== null) {
            $resourcePath = str_replace(
                '{' . 'UPLOAD_ID' . '}',
                ObjectSerializer::toPathValue($upload_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \MediaCloud\Vendor\GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \MediaCloud\Vendor\GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \MediaCloud\Vendor\GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires HTTP basic authentication
        if (!empty($this->config->getUsername()) || !(empty($this->config->getPassword()))) {
            $headers['Authorization'] = 'Basic ' . base64_encode($this->config->getUsername() . ':' . $this->config->getPassword());
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $queryParamsDirect = join('&', $queryParams);
        $query = \MediaCloud\Vendor\GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($queryParamsDirect ? "?{$queryParamsDirect}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createDirectUpload
     *
     * Create a new direct upload URL
     *
     * @param \MediaCloud\Vendor\MuxPhp\Models\CreateUploadRequest $create_upload_request (required)
     *
     * @throws \MediaCloud\Vendor\MuxPhp\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \MediaCloud\Vendor\MuxPhp\Models\UploadResponse
     */
    public function createDirectUpload($create_upload_request)
    {
        list($response) = $this->createDirectUploadWithHttpInfo($create_upload_request);
        return $response;
    }

    /**
     * Operation createDirectUploadWithHttpInfo
     *
     * Create a new direct upload URL
     *
     * @param \MediaCloud\Vendor\MuxPhp\Models\CreateUploadRequest $create_upload_request (required)
     *
     * @throws \MediaCloud\Vendor\MuxPhp\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \MediaCloud\Vendor\MuxPhp\Models\UploadResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function createDirectUploadWithHttpInfo($create_upload_request)
    {
        $request = $this->createDirectUploadRequest($create_upload_request);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 201:
                    if ('\MediaCloud\Vendor\MuxPhp\Models\UploadResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\MediaCloud\Vendor\MuxPhp\Models\UploadResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\MediaCloud\Vendor\MuxPhp\Models\UploadResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\MediaCloud\Vendor\MuxPhp\Models\UploadResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createDirectUploadAsync
     *
     * Create a new direct upload URL
     *
     * @param \MediaCloud\Vendor\MuxPhp\Models\CreateUploadRequest $create_upload_request (required)
     *
     * @throws \InvalidArgumentException
     * @return \MediaCloud\Vendor\GuzzleHttp\Promise\PromiseInterface
     */
    public function createDirectUploadAsync($create_upload_request)
    {
        return $this->createDirectUploadAsyncWithHttpInfo($create_upload_request)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createDirectUploadAsyncWithHttpInfo
     *
     * Create a new direct upload URL
     *
     * @param \MediaCloud\Vendor\MuxPhp\Models\CreateUploadRequest $create_upload_request (required)
     *
     * @throws \InvalidArgumentException
     * @return \MediaCloud\Vendor\GuzzleHttp\Promise\PromiseInterface
     */
    public function createDirectUploadAsyncWithHttpInfo($create_upload_request)
    {
        $returnType = '\MediaCloud\Vendor\MuxPhp\Models\UploadResponse';
        $request = $this->createDirectUploadRequest($create_upload_request);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createDirectUpload'
     *
     * @param \MediaCloud\Vendor\MuxPhp\Models\CreateUploadRequest $create_upload_request (required)
     *
     * @throws \InvalidArgumentException
     * @return \MediaCloud\Vendor\GuzzleHttp\Psr7\Request
     */
    protected function createDirectUploadRequest($create_upload_request)
    {
        // verify the required parameter 'create_upload_request' is set
        if ($create_upload_request === null || (is_array($create_upload_request) && count($create_upload_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $create_upload_request when calling createDirectUpload'
            );
        }

        $resourcePath = '/video/v1/uploads';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;




        // body params
        $_tempBody = null;
        if (isset($create_upload_request)) {
            $_tempBody = $create_upload_request;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \MediaCloud\Vendor\GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \MediaCloud\Vendor\GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \MediaCloud\Vendor\GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires HTTP basic authentication
        if (!empty($this->config->getUsername()) || !(empty($this->config->getPassword()))) {
            $headers['Authorization'] = 'Basic ' . base64_encode($this->config->getUsername() . ':' . $this->config->getPassword());
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $queryParamsDirect = join('&', $queryParams);
        $query = \MediaCloud\Vendor\GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($queryParamsDirect ? "?{$queryParamsDirect}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getDirectUpload
     *
     * Retrieve a single direct upload's info
     *
     * @param  string $upload_id ID of the Upload (required)
     *
     * @throws \MediaCloud\Vendor\MuxPhp\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \MediaCloud\Vendor\MuxPhp\Models\UploadResponse
     */
    public function getDirectUpload($upload_id)
    {
        list($response) = $this->getDirectUploadWithHttpInfo($upload_id);
        return $response;
    }

    /**
     * Operation getDirectUploadWithHttpInfo
     *
     * Retrieve a single direct upload's info
     *
     * @param  string $upload_id ID of the Upload (required)
     *
     * @throws \MediaCloud\Vendor\MuxPhp\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \MediaCloud\Vendor\MuxPhp\Models\UploadResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getDirectUploadWithHttpInfo($upload_id)
    {
        $request = $this->getDirectUploadRequest($upload_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\MediaCloud\Vendor\MuxPhp\Models\UploadResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\MediaCloud\Vendor\MuxPhp\Models\UploadResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\MediaCloud\Vendor\MuxPhp\Models\UploadResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\MediaCloud\Vendor\MuxPhp\Models\UploadResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getDirectUploadAsync
     *
     * Retrieve a single direct upload's info
     *
     * @param  string $upload_id ID of the Upload (required)
     *
     * @throws \InvalidArgumentException
     * @return \MediaCloud\Vendor\GuzzleHttp\Promise\PromiseInterface
     */
    public function getDirectUploadAsync($upload_id)
    {
        return $this->getDirectUploadAsyncWithHttpInfo($upload_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getDirectUploadAsyncWithHttpInfo
     *
     * Retrieve a single direct upload's info
     *
     * @param  string $upload_id ID of the Upload (required)
     *
     * @throws \InvalidArgumentException
     * @return \MediaCloud\Vendor\GuzzleHttp\Promise\PromiseInterface
     */
    public function getDirectUploadAsyncWithHttpInfo($upload_id)
    {
        $returnType = '\MediaCloud\Vendor\MuxPhp\Models\UploadResponse';
        $request = $this->getDirectUploadRequest($upload_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getDirectUpload'
     *
     * @param  string $upload_id ID of the Upload (required)
     *
     * @throws \InvalidArgumentException
     * @return \MediaCloud\Vendor\GuzzleHttp\Psr7\Request
     */
    protected function getDirectUploadRequest($upload_id)
    {
        // verify the required parameter 'upload_id' is set
        if ($upload_id === null || (is_array($upload_id) && count($upload_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $upload_id when calling getDirectUpload'
            );
        }

        $resourcePath = '/video/v1/uploads/{UPLOAD_ID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($upload_id !== null) {
            $resourcePath = str_replace(
                '{' . 'UPLOAD_ID' . '}',
                ObjectSerializer::toPathValue($upload_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \MediaCloud\Vendor\GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \MediaCloud\Vendor\GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \MediaCloud\Vendor\GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires HTTP basic authentication
        if (!empty($this->config->getUsername()) || !(empty($this->config->getPassword()))) {
            $headers['Authorization'] = 'Basic ' . base64_encode($this->config->getUsername() . ':' . $this->config->getPassword());
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $queryParamsDirect = join('&', $queryParams);
        $query = \MediaCloud\Vendor\GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($queryParamsDirect ? "?{$queryParamsDirect}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation listDirectUploads
     *
     * List direct uploads
     *
     * @param  mixed[] $optionalParams An associative array of optional parameters which can be passed to this function:
     *     - limit int - Number of items to include in the response (optional, default to 25)
     *     - page int - Offset by this many pages, of the size of &#x60;limit&#x60; (optional, default to 1)
     *
     * @throws \MediaCloud\Vendor\MuxPhp\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \MediaCloud\Vendor\MuxPhp\Models\ListUploadsResponse
     */
    public function listDirectUploads($optionalParams = [])
    {
        list($response) = $this->listDirectUploadsWithHttpInfo($optionalParams);
        return $response;
    }

    /**
     * Operation listDirectUploadsWithHttpInfo
     *
     * List direct uploads
     *
     * @param  mixed[] $optionalParams An associative array of optional parameters which can be passed to this function:
     *     - limit int - Number of items to include in the response (optional, default to 25)
     *     - page int - Offset by this many pages, of the size of &#x60;limit&#x60; (optional, default to 1)
     *
     * @throws \MediaCloud\Vendor\MuxPhp\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \MediaCloud\Vendor\MuxPhp\Models\ListUploadsResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function listDirectUploadsWithHttpInfo($optionalParams = [])
    {
        $request = $this->listDirectUploadsRequest($optionalParams);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\MediaCloud\Vendor\MuxPhp\Models\ListUploadsResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\MediaCloud\Vendor\MuxPhp\Models\ListUploadsResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\MediaCloud\Vendor\MuxPhp\Models\ListUploadsResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\MediaCloud\Vendor\MuxPhp\Models\ListUploadsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation listDirectUploadsAsync
     *
     * List direct uploads
     *
     * @param  mixed[] $optionalParams An associative array of optional parameters which can be passed to this function:
     *     - limit int - Number of items to include in the response (optional, default to 25)
     *     - page int - Offset by this many pages, of the size of &#x60;limit&#x60; (optional, default to 1)
     *
     * @throws \InvalidArgumentException
     * @return \MediaCloud\Vendor\GuzzleHttp\Promise\PromiseInterface
     */
    public function listDirectUploadsAsync($optionalParams = [])
    {
        return $this->listDirectUploadsAsyncWithHttpInfo($optionalParams)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation listDirectUploadsAsyncWithHttpInfo
     *
     * List direct uploads
     *
     * @param  mixed[] $optionalParams An associative array of optional parameters which can be passed to this function:
     *     - limit int - Number of items to include in the response (optional, default to 25)
     *     - page int - Offset by this many pages, of the size of &#x60;limit&#x60; (optional, default to 1)
     *
     * @throws \InvalidArgumentException
     * @return \MediaCloud\Vendor\GuzzleHttp\Promise\PromiseInterface
     */
    public function listDirectUploadsAsyncWithHttpInfo($optionalParams = [])
    {
        $returnType = '\MediaCloud\Vendor\MuxPhp\Models\ListUploadsResponse';
        $request = $this->listDirectUploadsRequest($optionalParams);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'listDirectUploads'
     *
     * @param  mixed[] $optionalParams An associative array of optional parameters which can be passed to this function:
     *     - limit int - Number of items to include in the response (optional, default to 25)
     *     - page int - Offset by this many pages, of the size of &#x60;limit&#x60; (optional, default to 1)
     *
     * @throws \InvalidArgumentException
     * @return \MediaCloud\Vendor\GuzzleHttp\Psr7\Request
     */
    protected function listDirectUploadsRequest($optionalParams)
    {
        // Pull the set optional params from the associative array $optionalParams, setting them to their defaults if they're not set.
        $limit = array_key_exists('limit', $optionalParams) ? $optionalParams['limit'] : 25;
        $page = array_key_exists('page', $optionalParams) ? $optionalParams['page'] : 1;

        $resourcePath = '/video/v1/uploads';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // Query Param: limit
        if ($limit !== null) {
            array_push($queryParams, 'limit=' . ObjectSerializer::toQueryValue($limit));
        }
        // Query Param: page
        if ($page !== null) {
            array_push($queryParams, 'page=' . ObjectSerializer::toQueryValue($page));
        }



        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \MediaCloud\Vendor\GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \MediaCloud\Vendor\GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \MediaCloud\Vendor\GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires HTTP basic authentication
        if (!empty($this->config->getUsername()) || !(empty($this->config->getPassword()))) {
            $headers['Authorization'] = 'Basic ' . base64_encode($this->config->getUsername() . ':' . $this->config->getPassword());
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $queryParamsDirect = join('&', $queryParams);
        $query = \MediaCloud\Vendor\GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($queryParamsDirect ? "?{$queryParamsDirect}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
