<?php

/**
 * Mux PHP - Copyright 2019 Mux Inc.
 * NOTE: This file is auto generated. Do not edit this file manually.
 */

namespace MediaCloud\Vendor\MuxPhp\Api;
use MediaCloud\Vendor\GuzzleHttp\Client;
use MediaCloud\Vendor\GuzzleHttp\ClientInterface;
use MediaCloud\Vendor\GuzzleHttp\Exception\RequestException;
use MediaCloud\Vendor\GuzzleHttp\Psr7\MultipartStream;
use MediaCloud\Vendor\GuzzleHttp\Psr7\Request;
use MediaCloud\Vendor\GuzzleHttp\RequestOptions;
use MediaCloud\Vendor\MuxPhp\ApiException;
use MediaCloud\Vendor\MuxPhp\Configuration;
use MediaCloud\Vendor\MuxPhp\HeaderSelector;
use MediaCloud\Vendor\MuxPhp\ObjectSerializer;

/**
 * DeliveryUsageApi Class Doc Comment
 *
 * @category Class
 * @package  MuxPhp
 */
class DeliveryUsageApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $host_index (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,
        $host_index = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $host_index;
    }

    /**
     * Set the host index
     *
     * @param  int $host_index Host index (required)
     */
    public function setHostIndex($host_index)
    {
        $this->hostIndex = $host_index;
    }

    /**
     * Get the host index
     *
     * @return Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation listDeliveryUsage
     *
     * List Usage
     *
     * @param  mixed[] $optionalParams An associative array of optional parameters which can be passed to this function:
     *     - page int - Offset by this many pages, of the size of &#x60;limit&#x60; (optional, default to 1)
     *     - limit int - Number of items to include in the response (optional, default to 100)
     *     - asset_id string - Filter response to return delivery usage for this asset only. (optional)
     *     - timeframe string[] - Time window to get delivery usage information. timeframe[0] indicates the start time, timeframe[1] indicates the end time in seconds since the Unix epoch. Default time window is 1 hour representing usage from 13th to 12th hour from when the request is made. (optional)
     *
     * @throws \MediaCloud\Vendor\MuxPhp\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \MediaCloud\Vendor\MuxPhp\Models\ListDeliveryUsageResponse
     */
    public function listDeliveryUsage($optionalParams = [])
    {
        list($response) = $this->listDeliveryUsageWithHttpInfo($optionalParams);
        return $response;
    }

    /**
     * Operation listDeliveryUsageWithHttpInfo
     *
     * List Usage
     *
     * @param  mixed[] $optionalParams An associative array of optional parameters which can be passed to this function:
     *     - page int - Offset by this many pages, of the size of &#x60;limit&#x60; (optional, default to 1)
     *     - limit int - Number of items to include in the response (optional, default to 100)
     *     - asset_id string - Filter response to return delivery usage for this asset only. (optional)
     *     - timeframe string[] - Time window to get delivery usage information. timeframe[0] indicates the start time, timeframe[1] indicates the end time in seconds since the Unix epoch. Default time window is 1 hour representing usage from 13th to 12th hour from when the request is made. (optional)
     *
     * @throws \MediaCloud\Vendor\MuxPhp\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \MediaCloud\Vendor\MuxPhp\Models\ListDeliveryUsageResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function listDeliveryUsageWithHttpInfo($optionalParams = [])
    {
        $request = $this->listDeliveryUsageRequest($optionalParams);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\MediaCloud\Vendor\MuxPhp\Models\ListDeliveryUsageResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\MediaCloud\Vendor\MuxPhp\Models\ListDeliveryUsageResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\MediaCloud\Vendor\MuxPhp\Models\ListDeliveryUsageResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\MediaCloud\Vendor\MuxPhp\Models\ListDeliveryUsageResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation listDeliveryUsageAsync
     *
     * List Usage
     *
     * @param  mixed[] $optionalParams An associative array of optional parameters which can be passed to this function:
     *     - page int - Offset by this many pages, of the size of &#x60;limit&#x60; (optional, default to 1)
     *     - limit int - Number of items to include in the response (optional, default to 100)
     *     - asset_id string - Filter response to return delivery usage for this asset only. (optional)
     *     - timeframe string[] - Time window to get delivery usage information. timeframe[0] indicates the start time, timeframe[1] indicates the end time in seconds since the Unix epoch. Default time window is 1 hour representing usage from 13th to 12th hour from when the request is made. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \MediaCloud\Vendor\GuzzleHttp\Promise\PromiseInterface
     */
    public function listDeliveryUsageAsync($optionalParams = [])
    {
        return $this->listDeliveryUsageAsyncWithHttpInfo($optionalParams)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation listDeliveryUsageAsyncWithHttpInfo
     *
     * List Usage
     *
     * @param  mixed[] $optionalParams An associative array of optional parameters which can be passed to this function:
     *     - page int - Offset by this many pages, of the size of &#x60;limit&#x60; (optional, default to 1)
     *     - limit int - Number of items to include in the response (optional, default to 100)
     *     - asset_id string - Filter response to return delivery usage for this asset only. (optional)
     *     - timeframe string[] - Time window to get delivery usage information. timeframe[0] indicates the start time, timeframe[1] indicates the end time in seconds since the Unix epoch. Default time window is 1 hour representing usage from 13th to 12th hour from when the request is made. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \MediaCloud\Vendor\GuzzleHttp\Promise\PromiseInterface
     */
    public function listDeliveryUsageAsyncWithHttpInfo($optionalParams = [])
    {
        $returnType = '\MediaCloud\Vendor\MuxPhp\Models\ListDeliveryUsageResponse';
        $request = $this->listDeliveryUsageRequest($optionalParams);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'listDeliveryUsage'
     *
     * @param  mixed[] $optionalParams An associative array of optional parameters which can be passed to this function:
     *     - page int - Offset by this many pages, of the size of &#x60;limit&#x60; (optional, default to 1)
     *     - limit int - Number of items to include in the response (optional, default to 100)
     *     - asset_id string - Filter response to return delivery usage for this asset only. (optional)
     *     - timeframe string[] - Time window to get delivery usage information. timeframe[0] indicates the start time, timeframe[1] indicates the end time in seconds since the Unix epoch. Default time window is 1 hour representing usage from 13th to 12th hour from when the request is made. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \MediaCloud\Vendor\GuzzleHttp\Psr7\Request
     */
    protected function listDeliveryUsageRequest($optionalParams)
    {
        // Pull the set optional params from the associative array $optionalParams, setting them to their defaults if they're not set.
        $page = array_key_exists('page', $optionalParams) ? $optionalParams['page'] : 1;
        $limit = array_key_exists('limit', $optionalParams) ? $optionalParams['limit'] : 100;
        $asset_id = array_key_exists('asset_id', $optionalParams) ? $optionalParams['asset_id'] : null;
        $timeframe = array_key_exists('timeframe', $optionalParams) ? $optionalParams['timeframe'] : null;

        $resourcePath = '/video/v1/delivery-usage';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // Query Param: page
        if ($page !== null) {
            array_push($queryParams, 'page=' . ObjectSerializer::toQueryValue($page));
        }
        // Query Param: limit
        if ($limit !== null) {
            array_push($queryParams, 'limit=' . ObjectSerializer::toQueryValue($limit));
        }
        // Query Param: asset_id
        if ($asset_id !== null) {
            array_push($queryParams, 'asset_id=' . ObjectSerializer::toQueryValue($asset_id));
        }
        // Query Param: timeframe[]
        if ($timeframe !== null) {
            if (is_array($timeframe)) {
                foreach ($timeframe as $p) {
                    array_push($queryParams, "timeframe[]=$p");
                }
            }
            else {
                throw new \InvalidArgumentException('Did not receive an array when expecting one for query parameter timeframe[]');
            }
        }



        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \MediaCloud\Vendor\GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \MediaCloud\Vendor\GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \MediaCloud\Vendor\GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires HTTP basic authentication
        if (!empty($this->config->getUsername()) || !(empty($this->config->getPassword()))) {
            $headers['Authorization'] = 'Basic ' . base64_encode($this->config->getUsername() . ':' . $this->config->getPassword());
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $queryParamsDirect = join('&', $queryParams);
        $query = \MediaCloud\Vendor\GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($queryParamsDirect ? "?{$queryParamsDirect}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
