<?php

namespace MediaCloud\Vendor\Aws\StorageGateway;
use MediaCloud\Vendor\Aws\AwsClient;

/**
 * AWS Storage Gateway client.
 *
 * @method \MediaCloud\Vendor\Aws\Result activateGateway(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise activateGatewayAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result addCache(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise addCacheAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result addTagsToResource(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise addTagsToResourceAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result addUploadBuffer(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise addUploadBufferAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result addWorkingStorage(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise addWorkingStorageAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result assignTapePool(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise assignTapePoolAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result associateFileSystem(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise associateFileSystemAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result attachVolume(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise attachVolumeAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result cancelArchival(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise cancelArchivalAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result cancelRetrieval(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise cancelRetrievalAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createCachediSCSIVolume(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createCachediSCSIVolumeAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createNFSFileShare(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createNFSFileShareAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createSMBFileShare(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createSMBFileShareAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createSnapshot(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createSnapshotAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createSnapshotFromVolumeRecoveryPoint(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createSnapshotFromVolumeRecoveryPointAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createStorediSCSIVolume(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createStorediSCSIVolumeAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createTapePool(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createTapePoolAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createTapeWithBarcode(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createTapeWithBarcodeAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createTapes(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createTapesAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteAutomaticTapeCreationPolicy(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteAutomaticTapeCreationPolicyAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteBandwidthRateLimit(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteBandwidthRateLimitAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteChapCredentials(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteChapCredentialsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteFileShare(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteFileShareAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteGateway(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteGatewayAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteSnapshotSchedule(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteSnapshotScheduleAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteTape(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteTapeAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteTapeArchive(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteTapeArchiveAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteTapePool(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteTapePoolAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteVolume(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteVolumeAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeAvailabilityMonitorTest(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeAvailabilityMonitorTestAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeBandwidthRateLimit(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeBandwidthRateLimitAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeBandwidthRateLimitSchedule(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeBandwidthRateLimitScheduleAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeCache(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeCacheAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeCachediSCSIVolumes(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeCachediSCSIVolumesAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeChapCredentials(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeChapCredentialsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeFileSystemAssociations(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeFileSystemAssociationsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeGatewayInformation(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeGatewayInformationAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeMaintenanceStartTime(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeMaintenanceStartTimeAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeNFSFileShares(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeNFSFileSharesAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeSMBFileShares(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeSMBFileSharesAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeSMBSettings(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeSMBSettingsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeSnapshotSchedule(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeSnapshotScheduleAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeStorediSCSIVolumes(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeStorediSCSIVolumesAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeTapeArchives(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeTapeArchivesAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeTapeRecoveryPoints(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeTapeRecoveryPointsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeTapes(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeTapesAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeUploadBuffer(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeUploadBufferAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeVTLDevices(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeVTLDevicesAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeWorkingStorage(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeWorkingStorageAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result detachVolume(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise detachVolumeAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result disableGateway(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise disableGatewayAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result disassociateFileSystem(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise disassociateFileSystemAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result joinDomain(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise joinDomainAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listAutomaticTapeCreationPolicies(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listAutomaticTapeCreationPoliciesAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listFileShares(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listFileSharesAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listFileSystemAssociations(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listFileSystemAssociationsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listGateways(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listGatewaysAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listLocalDisks(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listLocalDisksAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listTagsForResource(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listTagsForResourceAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listTapePools(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listTapePoolsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listTapes(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listTapesAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listVolumeInitiators(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listVolumeInitiatorsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listVolumeRecoveryPoints(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listVolumeRecoveryPointsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listVolumes(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listVolumesAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result notifyWhenUploaded(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise notifyWhenUploadedAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result refreshCache(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise refreshCacheAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result removeTagsFromResource(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise removeTagsFromResourceAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result resetCache(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise resetCacheAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result retrieveTapeArchive(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise retrieveTapeArchiveAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result retrieveTapeRecoveryPoint(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise retrieveTapeRecoveryPointAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result setLocalConsolePassword(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise setLocalConsolePasswordAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result setSMBGuestPassword(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise setSMBGuestPasswordAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result shutdownGateway(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise shutdownGatewayAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result startAvailabilityMonitorTest(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise startAvailabilityMonitorTestAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result startGateway(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise startGatewayAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result updateAutomaticTapeCreationPolicy(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise updateAutomaticTapeCreationPolicyAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result updateBandwidthRateLimit(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise updateBandwidthRateLimitAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result updateBandwidthRateLimitSchedule(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise updateBandwidthRateLimitScheduleAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result updateChapCredentials(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise updateChapCredentialsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result updateFileSystemAssociation(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise updateFileSystemAssociationAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result updateGatewayInformation(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise updateGatewayInformationAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result updateGatewaySoftwareNow(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise updateGatewaySoftwareNowAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result updateMaintenanceStartTime(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise updateMaintenanceStartTimeAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result updateNFSFileShare(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise updateNFSFileShareAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result updateSMBFileShare(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise updateSMBFileShareAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result updateSMBFileShareVisibility(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise updateSMBFileShareVisibilityAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result updateSMBLocalGroups(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise updateSMBLocalGroupsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result updateSMBSecurityStrategy(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise updateSMBSecurityStrategyAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result updateSnapshotSchedule(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise updateSnapshotScheduleAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result updateVTLDeviceType(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise updateVTLDeviceTypeAsync(array $args = [])
 */
class StorageGatewayClient extends AwsClient {}
