<?php

/**
 * Mux PHP - Copyright 2019 Mux Inc.
 * NOTE: This file is auto generated. Do not edit this file manually.
 */

namespace MediaCloud\Vendor\MuxPhp\Models;

use \ArrayAccess;
use \MediaCloud\Vendor\MuxPhp\ObjectSerializer;

/**
 * Track Class Doc Comment
 *
 * @category Class
 * @package  MuxPhp
 */
class Track implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
     * The original name of the model.
     *
     * @var string
     */
    protected static $openAPIModelName = 'Track';

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @var string[]
     */
    protected static $openAPITypes = [
        'id' => 'string',
        'type' => 'string',
        'duration' => 'double',
        'max_width' => 'int',
        'max_height' => 'int',
        'max_frame_rate' => 'double',
        'max_channels' => 'int',
        'max_channel_layout' => 'string',
        'text_type' => 'string',
        'language_code' => 'string',
        'name' => 'string',
        'closed_captions' => 'bool',
        'passthrough' => 'string'
    ];

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @var string[]
     */
    protected static $openAPIFormats = [
        'id' => null,
        'type' => null,
        'duration' => 'double',
        'max_width' => 'int64',
        'max_height' => 'int64',
        'max_frame_rate' => 'double',
        'max_channels' => 'int64',
        'max_channel_layout' => null,
        'text_type' => null,
        'language_code' => null,
        'name' => null,
        'closed_captions' => null,
        'passthrough' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'type' => 'type',
        'duration' => 'duration',
        'max_width' => 'max_width',
        'max_height' => 'max_height',
        'max_frame_rate' => 'max_frame_rate',
        'max_channels' => 'max_channels',
        'max_channel_layout' => 'max_channel_layout',
        'text_type' => 'text_type',
        'language_code' => 'language_code',
        'name' => 'name',
        'closed_captions' => 'closed_captions',
        'passthrough' => 'passthrough'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'type' => 'setType',
        'duration' => 'setDuration',
        'max_width' => 'setMaxWidth',
        'max_height' => 'setMaxHeight',
        'max_frame_rate' => 'setMaxFrameRate',
        'max_channels' => 'setMaxChannels',
        'max_channel_layout' => 'setMaxChannelLayout',
        'text_type' => 'setTextType',
        'language_code' => 'setLanguageCode',
        'name' => 'setName',
        'closed_captions' => 'setClosedCaptions',
        'passthrough' => 'setPassthrough'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'type' => 'getType',
        'duration' => 'getDuration',
        'max_width' => 'getMaxWidth',
        'max_height' => 'getMaxHeight',
        'max_frame_rate' => 'getMaxFrameRate',
        'max_channels' => 'getMaxChannels',
        'max_channel_layout' => 'getMaxChannelLayout',
        'text_type' => 'getTextType',
        'language_code' => 'getLanguageCode',
        'name' => 'getName',
        'closed_captions' => 'getClosedCaptions',
        'passthrough' => 'getPassthrough'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    const TYPE_VIDEO = 'video';
    const TYPE_AUDIO = 'audio';
    const TYPE_TEXT = 'text';
    const TEXT_TYPE_SUBTITLES = 'subtitles';
    

    
    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getTypeAllowableValues()
    {
        return [
            self::TYPE_VIDEO,
            self::TYPE_AUDIO,
            self::TYPE_TEXT,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getTextTypeAllowableValues()
    {
        return [
            self::TEXT_TYPE_SUBTITLES,
        ];
    }
    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['type'] = isset($data['type']) ? $data['type'] : null;
        $this->container['duration'] = isset($data['duration']) ? $data['duration'] : null;
        $this->container['max_width'] = isset($data['max_width']) ? $data['max_width'] : null;
        $this->container['max_height'] = isset($data['max_height']) ? $data['max_height'] : null;
        $this->container['max_frame_rate'] = isset($data['max_frame_rate']) ? $data['max_frame_rate'] : null;
        $this->container['max_channels'] = isset($data['max_channels']) ? $data['max_channels'] : null;
        $this->container['max_channel_layout'] = isset($data['max_channel_layout']) ? $data['max_channel_layout'] : null;
        $this->container['text_type'] = isset($data['text_type']) ? $data['text_type'] : null;
        $this->container['language_code'] = isset($data['language_code']) ? $data['language_code'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['closed_captions'] = isset($data['closed_captions']) ? $data['closed_captions'] : null;
        $this->container['passthrough'] = isset($data['passthrough']) ? $data['passthrough'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        $allowedValues = $this->getTypeAllowableValues();
        if (!is_null($this->container['type']) && !in_array($this->container['type'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value for 'type', must be one of '%s'",
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getTextTypeAllowableValues();
        if (!is_null($this->container['text_type']) && !in_array($this->container['text_type'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value for 'text_type', must be one of '%s'",
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return string|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param string|null $id id
     *
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets type
     *
     * @return string|null
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     *
     * @param string|null $type type
     *
     * @return $this
     */
    public function setType($type)
    {
        $allowedValues = $this->getTypeAllowableValues();
        if (!is_null($type) && !in_array($type, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value for 'type', must be one of '%s'",
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets duration
     *
     * @return double|null
     */
    public function getDuration()
    {
        return $this->container['duration'];
    }

    /**
     * Sets duration
     *
     * @param double|null $duration duration
     *
     * @return $this
     */
    public function setDuration($duration)
    {
        $this->container['duration'] = $duration;

        return $this;
    }

    /**
     * Gets max_width
     *
     * @return int|null
     */
    public function getMaxWidth()
    {
        return $this->container['max_width'];
    }

    /**
     * Sets max_width
     *
     * @param int|null $max_width max_width
     *
     * @return $this
     */
    public function setMaxWidth($max_width)
    {
        $this->container['max_width'] = $max_width;

        return $this;
    }

    /**
     * Gets max_height
     *
     * @return int|null
     */
    public function getMaxHeight()
    {
        return $this->container['max_height'];
    }

    /**
     * Sets max_height
     *
     * @param int|null $max_height max_height
     *
     * @return $this
     */
    public function setMaxHeight($max_height)
    {
        $this->container['max_height'] = $max_height;

        return $this;
    }

    /**
     * Gets max_frame_rate
     *
     * @return double|null
     */
    public function getMaxFrameRate()
    {
        return $this->container['max_frame_rate'];
    }

    /**
     * Sets max_frame_rate
     *
     * @param double|null $max_frame_rate max_frame_rate
     *
     * @return $this
     */
    public function setMaxFrameRate($max_frame_rate)
    {
        $this->container['max_frame_rate'] = $max_frame_rate;

        return $this;
    }

    /**
     * Gets max_channels
     *
     * @return int|null
     */
    public function getMaxChannels()
    {
        return $this->container['max_channels'];
    }

    /**
     * Sets max_channels
     *
     * @param int|null $max_channels max_channels
     *
     * @return $this
     */
    public function setMaxChannels($max_channels)
    {
        $this->container['max_channels'] = $max_channels;

        return $this;
    }

    /**
     * Gets max_channel_layout
     *
     * @return string|null
     */
    public function getMaxChannelLayout()
    {
        return $this->container['max_channel_layout'];
    }

    /**
     * Sets max_channel_layout
     *
     * @param string|null $max_channel_layout max_channel_layout
     *
     * @return $this
     */
    public function setMaxChannelLayout($max_channel_layout)
    {
        $this->container['max_channel_layout'] = $max_channel_layout;

        return $this;
    }

    /**
     * Gets text_type
     *
     * @return string|null
     */
    public function getTextType()
    {
        return $this->container['text_type'];
    }

    /**
     * Sets text_type
     *
     * @param string|null $text_type text_type
     *
     * @return $this
     */
    public function setTextType($text_type)
    {
        $allowedValues = $this->getTextTypeAllowableValues();
        if (!is_null($text_type) && !in_array($text_type, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value for 'text_type', must be one of '%s'",
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['text_type'] = $text_type;

        return $this;
    }

    /**
     * Gets language_code
     *
     * @return string|null
     */
    public function getLanguageCode()
    {
        return $this->container['language_code'];
    }

    /**
     * Sets language_code
     *
     * @param string|null $language_code language_code
     *
     * @return $this
     */
    public function setLanguageCode($language_code)
    {
        $this->container['language_code'] = $language_code;

        return $this;
    }

    /**
     * Gets name
     *
     * @return string|null
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string|null $name name
     *
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets closed_captions
     *
     * @return bool|null
     */
    public function getClosedCaptions()
    {
        return $this->container['closed_captions'];
    }

    /**
     * Sets closed_captions
     *
     * @param bool|null $closed_captions closed_captions
     *
     * @return $this
     */
    public function setClosedCaptions($closed_captions)
    {
        $this->container['closed_captions'] = $closed_captions;

        return $this;
    }

    /**
     * Gets passthrough
     *
     * @return string|null
     */
    public function getPassthrough()
    {
        return $this->container['passthrough'];
    }

    /**
     * Sets passthrough
     *
     * @param string|null $passthrough passthrough
     *
     * @return $this
     */
    public function setPassthrough($passthrough)
    {
        $this->container['passthrough'] = $passthrough;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }
}


