<?php

/**
 * Mux PHP - Copyright 2019 Mux Inc.
 * NOTE: This file is auto generated. Do not edit this file manually.
 */

namespace MediaCloud\Vendor\MuxPhp\Api;
use MediaCloud\Vendor\GuzzleHttp\Client;
use MediaCloud\Vendor\GuzzleHttp\ClientInterface;
use MediaCloud\Vendor\GuzzleHttp\Exception\RequestException;
use MediaCloud\Vendor\GuzzleHttp\Psr7\MultipartStream;
use MediaCloud\Vendor\GuzzleHttp\Psr7\Request;
use MediaCloud\Vendor\GuzzleHttp\RequestOptions;
use MediaCloud\Vendor\MuxPhp\ApiException;
use MediaCloud\Vendor\MuxPhp\Configuration;
use MediaCloud\Vendor\MuxPhp\HeaderSelector;
use MediaCloud\Vendor\MuxPhp\ObjectSerializer;

/**
 * LiveStreamsApi Class Doc Comment
 *
 * @category Class
 * @package  MuxPhp
 */
class LiveStreamsApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $host_index (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,
        $host_index = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $host_index;
    }

    /**
     * Set the host index
     *
     * @param  int $host_index Host index (required)
     */
    public function setHostIndex($host_index)
    {
        $this->hostIndex = $host_index;
    }

    /**
     * Get the host index
     *
     * @return Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation createLiveStream
     *
     * Create a live stream
     *
     * @param \MediaCloud\Vendor\MuxPhp\Models\CreateLiveStreamRequest $create_live_stream_request (required)
     *
     * @throws \MediaCloud\Vendor\MuxPhp\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \MediaCloud\Vendor\MuxPhp\Models\LiveStreamResponse
     */
    public function createLiveStream($create_live_stream_request)
    {
        list($response) = $this->createLiveStreamWithHttpInfo($create_live_stream_request);
        return $response;
    }

    /**
     * Operation createLiveStreamWithHttpInfo
     *
     * Create a live stream
     *
     * @param \MediaCloud\Vendor\MuxPhp\Models\CreateLiveStreamRequest $create_live_stream_request (required)
     *
     * @throws \MediaCloud\Vendor\MuxPhp\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \MediaCloud\Vendor\MuxPhp\Models\LiveStreamResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function createLiveStreamWithHttpInfo($create_live_stream_request)
    {
        $request = $this->createLiveStreamRequest($create_live_stream_request);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 201:
                    if ('\MediaCloud\Vendor\MuxPhp\Models\LiveStreamResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\MediaCloud\Vendor\MuxPhp\Models\LiveStreamResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\MediaCloud\Vendor\MuxPhp\Models\LiveStreamResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\MediaCloud\Vendor\MuxPhp\Models\LiveStreamResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createLiveStreamAsync
     *
     * Create a live stream
     *
     * @param \MediaCloud\Vendor\MuxPhp\Models\CreateLiveStreamRequest $create_live_stream_request (required)
     *
     * @throws \InvalidArgumentException
     * @return \MediaCloud\Vendor\GuzzleHttp\Promise\PromiseInterface
     */
    public function createLiveStreamAsync($create_live_stream_request)
    {
        return $this->createLiveStreamAsyncWithHttpInfo($create_live_stream_request)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createLiveStreamAsyncWithHttpInfo
     *
     * Create a live stream
     *
     * @param \MediaCloud\Vendor\MuxPhp\Models\CreateLiveStreamRequest $create_live_stream_request (required)
     *
     * @throws \InvalidArgumentException
     * @return \MediaCloud\Vendor\GuzzleHttp\Promise\PromiseInterface
     */
    public function createLiveStreamAsyncWithHttpInfo($create_live_stream_request)
    {
        $returnType = '\MediaCloud\Vendor\MuxPhp\Models\LiveStreamResponse';
        $request = $this->createLiveStreamRequest($create_live_stream_request);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createLiveStream'
     *
     * @param \MediaCloud\Vendor\MuxPhp\Models\CreateLiveStreamRequest $create_live_stream_request (required)
     *
     * @throws \InvalidArgumentException
     * @return \MediaCloud\Vendor\GuzzleHttp\Psr7\Request
     */
    protected function createLiveStreamRequest($create_live_stream_request)
    {
        // verify the required parameter 'create_live_stream_request' is set
        if ($create_live_stream_request === null || (is_array($create_live_stream_request) && count($create_live_stream_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $create_live_stream_request when calling createLiveStream'
            );
        }

        $resourcePath = '/video/v1/live-streams';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;




        // body params
        $_tempBody = null;
        if (isset($create_live_stream_request)) {
            $_tempBody = $create_live_stream_request;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \MediaCloud\Vendor\GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \MediaCloud\Vendor\GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \MediaCloud\Vendor\GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires HTTP basic authentication
        if (!empty($this->config->getUsername()) || !(empty($this->config->getPassword()))) {
            $headers['Authorization'] = 'Basic ' . base64_encode($this->config->getUsername() . ':' . $this->config->getPassword());
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $queryParamsDirect = join('&', $queryParams);
        $query = \MediaCloud\Vendor\GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($queryParamsDirect ? "?{$queryParamsDirect}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createLiveStreamPlaybackId
     *
     * Create a live stream playback ID
     *
     * @param  string $live_stream_id The live stream ID (required)
     * @param \MediaCloud\Vendor\MuxPhp\Models\CreatePlaybackIDRequest $create_playback_id_request (required)
     *
     * @throws \MediaCloud\Vendor\MuxPhp\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \MediaCloud\Vendor\MuxPhp\Models\CreatePlaybackIDResponse
     */
    public function createLiveStreamPlaybackId($live_stream_id, $create_playback_id_request)
    {
        list($response) = $this->createLiveStreamPlaybackIdWithHttpInfo($live_stream_id, $create_playback_id_request);
        return $response;
    }

    /**
     * Operation createLiveStreamPlaybackIdWithHttpInfo
     *
     * Create a live stream playback ID
     *
     * @param  string $live_stream_id The live stream ID (required)
     * @param \MediaCloud\Vendor\MuxPhp\Models\CreatePlaybackIDRequest $create_playback_id_request (required)
     *
     * @throws \MediaCloud\Vendor\MuxPhp\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \MediaCloud\Vendor\MuxPhp\Models\CreatePlaybackIDResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function createLiveStreamPlaybackIdWithHttpInfo($live_stream_id, $create_playback_id_request)
    {
        $request = $this->createLiveStreamPlaybackIdRequest($live_stream_id, $create_playback_id_request);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 201:
                    if ('\MediaCloud\Vendor\MuxPhp\Models\CreatePlaybackIDResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\MediaCloud\Vendor\MuxPhp\Models\CreatePlaybackIDResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\MediaCloud\Vendor\MuxPhp\Models\CreatePlaybackIDResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\MediaCloud\Vendor\MuxPhp\Models\CreatePlaybackIDResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createLiveStreamPlaybackIdAsync
     *
     * Create a live stream playback ID
     *
     * @param  string $live_stream_id The live stream ID (required)
     * @param \MediaCloud\Vendor\MuxPhp\Models\CreatePlaybackIDRequest $create_playback_id_request (required)
     *
     * @throws \InvalidArgumentException
     * @return \MediaCloud\Vendor\GuzzleHttp\Promise\PromiseInterface
     */
    public function createLiveStreamPlaybackIdAsync($live_stream_id, $create_playback_id_request)
    {
        return $this->createLiveStreamPlaybackIdAsyncWithHttpInfo($live_stream_id, $create_playback_id_request)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createLiveStreamPlaybackIdAsyncWithHttpInfo
     *
     * Create a live stream playback ID
     *
     * @param  string $live_stream_id The live stream ID (required)
     * @param \MediaCloud\Vendor\MuxPhp\Models\CreatePlaybackIDRequest $create_playback_id_request (required)
     *
     * @throws \InvalidArgumentException
     * @return \MediaCloud\Vendor\GuzzleHttp\Promise\PromiseInterface
     */
    public function createLiveStreamPlaybackIdAsyncWithHttpInfo($live_stream_id, $create_playback_id_request)
    {
        $returnType = '\MediaCloud\Vendor\MuxPhp\Models\CreatePlaybackIDResponse';
        $request = $this->createLiveStreamPlaybackIdRequest($live_stream_id, $create_playback_id_request);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createLiveStreamPlaybackId'
     *
     * @param  string $live_stream_id The live stream ID (required)
     * @param \MediaCloud\Vendor\MuxPhp\Models\CreatePlaybackIDRequest $create_playback_id_request (required)
     *
     * @throws \InvalidArgumentException
     * @return \MediaCloud\Vendor\GuzzleHttp\Psr7\Request
     */
    protected function createLiveStreamPlaybackIdRequest($live_stream_id, $create_playback_id_request)
    {
        // verify the required parameter 'live_stream_id' is set
        if ($live_stream_id === null || (is_array($live_stream_id) && count($live_stream_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $live_stream_id when calling createLiveStreamPlaybackId'
            );
        }
        // verify the required parameter 'create_playback_id_request' is set
        if ($create_playback_id_request === null || (is_array($create_playback_id_request) && count($create_playback_id_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $create_playback_id_request when calling createLiveStreamPlaybackId'
            );
        }

        $resourcePath = '/video/v1/live-streams/{LIVE_STREAM_ID}/playback-ids';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($live_stream_id !== null) {
            $resourcePath = str_replace(
                '{' . 'LIVE_STREAM_ID' . '}',
                ObjectSerializer::toPathValue($live_stream_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($create_playback_id_request)) {
            $_tempBody = $create_playback_id_request;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \MediaCloud\Vendor\GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \MediaCloud\Vendor\GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \MediaCloud\Vendor\GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires HTTP basic authentication
        if (!empty($this->config->getUsername()) || !(empty($this->config->getPassword()))) {
            $headers['Authorization'] = 'Basic ' . base64_encode($this->config->getUsername() . ':' . $this->config->getPassword());
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $queryParamsDirect = join('&', $queryParams);
        $query = \MediaCloud\Vendor\GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($queryParamsDirect ? "?{$queryParamsDirect}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createLiveStreamSimulcastTarget
     *
     * Create a live stream simulcast target
     *
     * @param  string $live_stream_id The live stream ID (required)
     * @param \MediaCloud\Vendor\MuxPhp\Models\CreateSimulcastTargetRequest $create_simulcast_target_request (required)
     *
     * @throws \MediaCloud\Vendor\MuxPhp\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \MediaCloud\Vendor\MuxPhp\Models\SimulcastTargetResponse
     */
    public function createLiveStreamSimulcastTarget($live_stream_id, $create_simulcast_target_request)
    {
        list($response) = $this->createLiveStreamSimulcastTargetWithHttpInfo($live_stream_id, $create_simulcast_target_request);
        return $response;
    }

    /**
     * Operation createLiveStreamSimulcastTargetWithHttpInfo
     *
     * Create a live stream simulcast target
     *
     * @param  string $live_stream_id The live stream ID (required)
     * @param \MediaCloud\Vendor\MuxPhp\Models\CreateSimulcastTargetRequest $create_simulcast_target_request (required)
     *
     * @throws \MediaCloud\Vendor\MuxPhp\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \MediaCloud\Vendor\MuxPhp\Models\SimulcastTargetResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function createLiveStreamSimulcastTargetWithHttpInfo($live_stream_id, $create_simulcast_target_request)
    {
        $request = $this->createLiveStreamSimulcastTargetRequest($live_stream_id, $create_simulcast_target_request);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 201:
                    if ('\MediaCloud\Vendor\MuxPhp\Models\SimulcastTargetResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\MediaCloud\Vendor\MuxPhp\Models\SimulcastTargetResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\MediaCloud\Vendor\MuxPhp\Models\SimulcastTargetResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\MediaCloud\Vendor\MuxPhp\Models\SimulcastTargetResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createLiveStreamSimulcastTargetAsync
     *
     * Create a live stream simulcast target
     *
     * @param  string $live_stream_id The live stream ID (required)
     * @param \MediaCloud\Vendor\MuxPhp\Models\CreateSimulcastTargetRequest $create_simulcast_target_request (required)
     *
     * @throws \InvalidArgumentException
     * @return \MediaCloud\Vendor\GuzzleHttp\Promise\PromiseInterface
     */
    public function createLiveStreamSimulcastTargetAsync($live_stream_id, $create_simulcast_target_request)
    {
        return $this->createLiveStreamSimulcastTargetAsyncWithHttpInfo($live_stream_id, $create_simulcast_target_request)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createLiveStreamSimulcastTargetAsyncWithHttpInfo
     *
     * Create a live stream simulcast target
     *
     * @param  string $live_stream_id The live stream ID (required)
     * @param \MediaCloud\Vendor\MuxPhp\Models\CreateSimulcastTargetRequest $create_simulcast_target_request (required)
     *
     * @throws \InvalidArgumentException
     * @return \MediaCloud\Vendor\GuzzleHttp\Promise\PromiseInterface
     */
    public function createLiveStreamSimulcastTargetAsyncWithHttpInfo($live_stream_id, $create_simulcast_target_request)
    {
        $returnType = '\MediaCloud\Vendor\MuxPhp\Models\SimulcastTargetResponse';
        $request = $this->createLiveStreamSimulcastTargetRequest($live_stream_id, $create_simulcast_target_request);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createLiveStreamSimulcastTarget'
     *
     * @param  string $live_stream_id The live stream ID (required)
     * @param \MediaCloud\Vendor\MuxPhp\Models\CreateSimulcastTargetRequest $create_simulcast_target_request (required)
     *
     * @throws \InvalidArgumentException
     * @return \MediaCloud\Vendor\GuzzleHttp\Psr7\Request
     */
    protected function createLiveStreamSimulcastTargetRequest($live_stream_id, $create_simulcast_target_request)
    {
        // verify the required parameter 'live_stream_id' is set
        if ($live_stream_id === null || (is_array($live_stream_id) && count($live_stream_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $live_stream_id when calling createLiveStreamSimulcastTarget'
            );
        }
        // verify the required parameter 'create_simulcast_target_request' is set
        if ($create_simulcast_target_request === null || (is_array($create_simulcast_target_request) && count($create_simulcast_target_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $create_simulcast_target_request when calling createLiveStreamSimulcastTarget'
            );
        }

        $resourcePath = '/video/v1/live-streams/{LIVE_STREAM_ID}/simulcast-targets';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($live_stream_id !== null) {
            $resourcePath = str_replace(
                '{' . 'LIVE_STREAM_ID' . '}',
                ObjectSerializer::toPathValue($live_stream_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($create_simulcast_target_request)) {
            $_tempBody = $create_simulcast_target_request;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \MediaCloud\Vendor\GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \MediaCloud\Vendor\GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \MediaCloud\Vendor\GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires HTTP basic authentication
        if (!empty($this->config->getUsername()) || !(empty($this->config->getPassword()))) {
            $headers['Authorization'] = 'Basic ' . base64_encode($this->config->getUsername() . ':' . $this->config->getPassword());
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $queryParamsDirect = join('&', $queryParams);
        $query = \MediaCloud\Vendor\GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($queryParamsDirect ? "?{$queryParamsDirect}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteLiveStream
     *
     * Delete a live stream
     *
     * @param  string $live_stream_id The live stream ID (required)
     *
     * @throws \MediaCloud\Vendor\MuxPhp\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteLiveStream($live_stream_id)
    {
        $this->deleteLiveStreamWithHttpInfo($live_stream_id);
    }

    /**
     * Operation deleteLiveStreamWithHttpInfo
     *
     * Delete a live stream
     *
     * @param  string $live_stream_id The live stream ID (required)
     *
     * @throws \MediaCloud\Vendor\MuxPhp\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteLiveStreamWithHttpInfo($live_stream_id)
    {
        $request = $this->deleteLiveStreamRequest($live_stream_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deleteLiveStreamAsync
     *
     * Delete a live stream
     *
     * @param  string $live_stream_id The live stream ID (required)
     *
     * @throws \InvalidArgumentException
     * @return \MediaCloud\Vendor\GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteLiveStreamAsync($live_stream_id)
    {
        return $this->deleteLiveStreamAsyncWithHttpInfo($live_stream_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteLiveStreamAsyncWithHttpInfo
     *
     * Delete a live stream
     *
     * @param  string $live_stream_id The live stream ID (required)
     *
     * @throws \InvalidArgumentException
     * @return \MediaCloud\Vendor\GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteLiveStreamAsyncWithHttpInfo($live_stream_id)
    {
        $returnType = '';
        $request = $this->deleteLiveStreamRequest($live_stream_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteLiveStream'
     *
     * @param  string $live_stream_id The live stream ID (required)
     *
     * @throws \InvalidArgumentException
     * @return \MediaCloud\Vendor\GuzzleHttp\Psr7\Request
     */
    protected function deleteLiveStreamRequest($live_stream_id)
    {
        // verify the required parameter 'live_stream_id' is set
        if ($live_stream_id === null || (is_array($live_stream_id) && count($live_stream_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $live_stream_id when calling deleteLiveStream'
            );
        }

        $resourcePath = '/video/v1/live-streams/{LIVE_STREAM_ID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($live_stream_id !== null) {
            $resourcePath = str_replace(
                '{' . 'LIVE_STREAM_ID' . '}',
                ObjectSerializer::toPathValue($live_stream_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                []
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                [],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \MediaCloud\Vendor\GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \MediaCloud\Vendor\GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \MediaCloud\Vendor\GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires HTTP basic authentication
        if (!empty($this->config->getUsername()) || !(empty($this->config->getPassword()))) {
            $headers['Authorization'] = 'Basic ' . base64_encode($this->config->getUsername() . ':' . $this->config->getPassword());
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $queryParamsDirect = join('&', $queryParams);
        $query = \MediaCloud\Vendor\GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'DELETE',
            $this->config->getHost() . $resourcePath . ($queryParamsDirect ? "?{$queryParamsDirect}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteLiveStreamPlaybackId
     *
     * Delete a live stream playback ID
     *
     * @param  string $live_stream_id The live stream ID (required)
     * @param  string $playback_id The live stream&#39;s playback ID. (required)
     *
     * @throws \MediaCloud\Vendor\MuxPhp\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteLiveStreamPlaybackId($live_stream_id, $playback_id)
    {
        $this->deleteLiveStreamPlaybackIdWithHttpInfo($live_stream_id, $playback_id);
    }

    /**
     * Operation deleteLiveStreamPlaybackIdWithHttpInfo
     *
     * Delete a live stream playback ID
     *
     * @param  string $live_stream_id The live stream ID (required)
     * @param  string $playback_id The live stream&#39;s playback ID. (required)
     *
     * @throws \MediaCloud\Vendor\MuxPhp\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteLiveStreamPlaybackIdWithHttpInfo($live_stream_id, $playback_id)
    {
        $request = $this->deleteLiveStreamPlaybackIdRequest($live_stream_id, $playback_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deleteLiveStreamPlaybackIdAsync
     *
     * Delete a live stream playback ID
     *
     * @param  string $live_stream_id The live stream ID (required)
     * @param  string $playback_id The live stream&#39;s playback ID. (required)
     *
     * @throws \InvalidArgumentException
     * @return \MediaCloud\Vendor\GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteLiveStreamPlaybackIdAsync($live_stream_id, $playback_id)
    {
        return $this->deleteLiveStreamPlaybackIdAsyncWithHttpInfo($live_stream_id, $playback_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteLiveStreamPlaybackIdAsyncWithHttpInfo
     *
     * Delete a live stream playback ID
     *
     * @param  string $live_stream_id The live stream ID (required)
     * @param  string $playback_id The live stream&#39;s playback ID. (required)
     *
     * @throws \InvalidArgumentException
     * @return \MediaCloud\Vendor\GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteLiveStreamPlaybackIdAsyncWithHttpInfo($live_stream_id, $playback_id)
    {
        $returnType = '';
        $request = $this->deleteLiveStreamPlaybackIdRequest($live_stream_id, $playback_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteLiveStreamPlaybackId'
     *
     * @param  string $live_stream_id The live stream ID (required)
     * @param  string $playback_id The live stream&#39;s playback ID. (required)
     *
     * @throws \InvalidArgumentException
     * @return \MediaCloud\Vendor\GuzzleHttp\Psr7\Request
     */
    protected function deleteLiveStreamPlaybackIdRequest($live_stream_id, $playback_id)
    {
        // verify the required parameter 'live_stream_id' is set
        if ($live_stream_id === null || (is_array($live_stream_id) && count($live_stream_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $live_stream_id when calling deleteLiveStreamPlaybackId'
            );
        }
        // verify the required parameter 'playback_id' is set
        if ($playback_id === null || (is_array($playback_id) && count($playback_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $playback_id when calling deleteLiveStreamPlaybackId'
            );
        }

        $resourcePath = '/video/v1/live-streams/{LIVE_STREAM_ID}/playback-ids/{PLAYBACK_ID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($live_stream_id !== null) {
            $resourcePath = str_replace(
                '{' . 'LIVE_STREAM_ID' . '}',
                ObjectSerializer::toPathValue($live_stream_id),
                $resourcePath
            );
        }
        // path params
        if ($playback_id !== null) {
            $resourcePath = str_replace(
                '{' . 'PLAYBACK_ID' . '}',
                ObjectSerializer::toPathValue($playback_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                []
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                [],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \MediaCloud\Vendor\GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \MediaCloud\Vendor\GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \MediaCloud\Vendor\GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires HTTP basic authentication
        if (!empty($this->config->getUsername()) || !(empty($this->config->getPassword()))) {
            $headers['Authorization'] = 'Basic ' . base64_encode($this->config->getUsername() . ':' . $this->config->getPassword());
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $queryParamsDirect = join('&', $queryParams);
        $query = \MediaCloud\Vendor\GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'DELETE',
            $this->config->getHost() . $resourcePath . ($queryParamsDirect ? "?{$queryParamsDirect}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteLiveStreamSimulcastTarget
     *
     * Delete a Live Stream Simulcast Target
     *
     * @param  string $live_stream_id The live stream ID (required)
     * @param  string $simulcast_target_id The ID of the simulcast target. (required)
     *
     * @throws \MediaCloud\Vendor\MuxPhp\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteLiveStreamSimulcastTarget($live_stream_id, $simulcast_target_id)
    {
        $this->deleteLiveStreamSimulcastTargetWithHttpInfo($live_stream_id, $simulcast_target_id);
    }

    /**
     * Operation deleteLiveStreamSimulcastTargetWithHttpInfo
     *
     * Delete a Live Stream Simulcast Target
     *
     * @param  string $live_stream_id The live stream ID (required)
     * @param  string $simulcast_target_id The ID of the simulcast target. (required)
     *
     * @throws \MediaCloud\Vendor\MuxPhp\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteLiveStreamSimulcastTargetWithHttpInfo($live_stream_id, $simulcast_target_id)
    {
        $request = $this->deleteLiveStreamSimulcastTargetRequest($live_stream_id, $simulcast_target_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deleteLiveStreamSimulcastTargetAsync
     *
     * Delete a Live Stream Simulcast Target
     *
     * @param  string $live_stream_id The live stream ID (required)
     * @param  string $simulcast_target_id The ID of the simulcast target. (required)
     *
     * @throws \InvalidArgumentException
     * @return \MediaCloud\Vendor\GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteLiveStreamSimulcastTargetAsync($live_stream_id, $simulcast_target_id)
    {
        return $this->deleteLiveStreamSimulcastTargetAsyncWithHttpInfo($live_stream_id, $simulcast_target_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteLiveStreamSimulcastTargetAsyncWithHttpInfo
     *
     * Delete a Live Stream Simulcast Target
     *
     * @param  string $live_stream_id The live stream ID (required)
     * @param  string $simulcast_target_id The ID of the simulcast target. (required)
     *
     * @throws \InvalidArgumentException
     * @return \MediaCloud\Vendor\GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteLiveStreamSimulcastTargetAsyncWithHttpInfo($live_stream_id, $simulcast_target_id)
    {
        $returnType = '';
        $request = $this->deleteLiveStreamSimulcastTargetRequest($live_stream_id, $simulcast_target_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteLiveStreamSimulcastTarget'
     *
     * @param  string $live_stream_id The live stream ID (required)
     * @param  string $simulcast_target_id The ID of the simulcast target. (required)
     *
     * @throws \InvalidArgumentException
     * @return \MediaCloud\Vendor\GuzzleHttp\Psr7\Request
     */
    protected function deleteLiveStreamSimulcastTargetRequest($live_stream_id, $simulcast_target_id)
    {
        // verify the required parameter 'live_stream_id' is set
        if ($live_stream_id === null || (is_array($live_stream_id) && count($live_stream_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $live_stream_id when calling deleteLiveStreamSimulcastTarget'
            );
        }
        // verify the required parameter 'simulcast_target_id' is set
        if ($simulcast_target_id === null || (is_array($simulcast_target_id) && count($simulcast_target_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $simulcast_target_id when calling deleteLiveStreamSimulcastTarget'
            );
        }

        $resourcePath = '/video/v1/live-streams/{LIVE_STREAM_ID}/simulcast-targets/{SIMULCAST_TARGET_ID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($live_stream_id !== null) {
            $resourcePath = str_replace(
                '{' . 'LIVE_STREAM_ID' . '}',
                ObjectSerializer::toPathValue($live_stream_id),
                $resourcePath
            );
        }
        // path params
        if ($simulcast_target_id !== null) {
            $resourcePath = str_replace(
                '{' . 'SIMULCAST_TARGET_ID' . '}',
                ObjectSerializer::toPathValue($simulcast_target_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                []
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                [],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \MediaCloud\Vendor\GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \MediaCloud\Vendor\GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \MediaCloud\Vendor\GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires HTTP basic authentication
        if (!empty($this->config->getUsername()) || !(empty($this->config->getPassword()))) {
            $headers['Authorization'] = 'Basic ' . base64_encode($this->config->getUsername() . ':' . $this->config->getPassword());
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $queryParamsDirect = join('&', $queryParams);
        $query = \MediaCloud\Vendor\GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'DELETE',
            $this->config->getHost() . $resourcePath . ($queryParamsDirect ? "?{$queryParamsDirect}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getLiveStream
     *
     * Retrieve a live stream
     *
     * @param  string $live_stream_id The live stream ID (required)
     *
     * @throws \MediaCloud\Vendor\MuxPhp\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \MediaCloud\Vendor\MuxPhp\Models\LiveStreamResponse
     */
    public function getLiveStream($live_stream_id)
    {
        list($response) = $this->getLiveStreamWithHttpInfo($live_stream_id);
        return $response;
    }

    /**
     * Operation getLiveStreamWithHttpInfo
     *
     * Retrieve a live stream
     *
     * @param  string $live_stream_id The live stream ID (required)
     *
     * @throws \MediaCloud\Vendor\MuxPhp\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \MediaCloud\Vendor\MuxPhp\Models\LiveStreamResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getLiveStreamWithHttpInfo($live_stream_id)
    {
        $request = $this->getLiveStreamRequest($live_stream_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\MediaCloud\Vendor\MuxPhp\Models\LiveStreamResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\MediaCloud\Vendor\MuxPhp\Models\LiveStreamResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\MediaCloud\Vendor\MuxPhp\Models\LiveStreamResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\MediaCloud\Vendor\MuxPhp\Models\LiveStreamResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getLiveStreamAsync
     *
     * Retrieve a live stream
     *
     * @param  string $live_stream_id The live stream ID (required)
     *
     * @throws \InvalidArgumentException
     * @return \MediaCloud\Vendor\GuzzleHttp\Promise\PromiseInterface
     */
    public function getLiveStreamAsync($live_stream_id)
    {
        return $this->getLiveStreamAsyncWithHttpInfo($live_stream_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getLiveStreamAsyncWithHttpInfo
     *
     * Retrieve a live stream
     *
     * @param  string $live_stream_id The live stream ID (required)
     *
     * @throws \InvalidArgumentException
     * @return \MediaCloud\Vendor\GuzzleHttp\Promise\PromiseInterface
     */
    public function getLiveStreamAsyncWithHttpInfo($live_stream_id)
    {
        $returnType = '\MediaCloud\Vendor\MuxPhp\Models\LiveStreamResponse';
        $request = $this->getLiveStreamRequest($live_stream_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getLiveStream'
     *
     * @param  string $live_stream_id The live stream ID (required)
     *
     * @throws \InvalidArgumentException
     * @return \MediaCloud\Vendor\GuzzleHttp\Psr7\Request
     */
    protected function getLiveStreamRequest($live_stream_id)
    {
        // verify the required parameter 'live_stream_id' is set
        if ($live_stream_id === null || (is_array($live_stream_id) && count($live_stream_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $live_stream_id when calling getLiveStream'
            );
        }

        $resourcePath = '/video/v1/live-streams/{LIVE_STREAM_ID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($live_stream_id !== null) {
            $resourcePath = str_replace(
                '{' . 'LIVE_STREAM_ID' . '}',
                ObjectSerializer::toPathValue($live_stream_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \MediaCloud\Vendor\GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \MediaCloud\Vendor\GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \MediaCloud\Vendor\GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires HTTP basic authentication
        if (!empty($this->config->getUsername()) || !(empty($this->config->getPassword()))) {
            $headers['Authorization'] = 'Basic ' . base64_encode($this->config->getUsername() . ':' . $this->config->getPassword());
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $queryParamsDirect = join('&', $queryParams);
        $query = \MediaCloud\Vendor\GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($queryParamsDirect ? "?{$queryParamsDirect}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getLiveStreamSimulcastTarget
     *
     * Retrieve a Live Stream Simulcast Target
     *
     * @param  string $live_stream_id The live stream ID (required)
     * @param  string $simulcast_target_id The ID of the simulcast target. (required)
     *
     * @throws \MediaCloud\Vendor\MuxPhp\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \MediaCloud\Vendor\MuxPhp\Models\SimulcastTargetResponse
     */
    public function getLiveStreamSimulcastTarget($live_stream_id, $simulcast_target_id)
    {
        list($response) = $this->getLiveStreamSimulcastTargetWithHttpInfo($live_stream_id, $simulcast_target_id);
        return $response;
    }

    /**
     * Operation getLiveStreamSimulcastTargetWithHttpInfo
     *
     * Retrieve a Live Stream Simulcast Target
     *
     * @param  string $live_stream_id The live stream ID (required)
     * @param  string $simulcast_target_id The ID of the simulcast target. (required)
     *
     * @throws \MediaCloud\Vendor\MuxPhp\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \MediaCloud\Vendor\MuxPhp\Models\SimulcastTargetResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getLiveStreamSimulcastTargetWithHttpInfo($live_stream_id, $simulcast_target_id)
    {
        $request = $this->getLiveStreamSimulcastTargetRequest($live_stream_id, $simulcast_target_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\MediaCloud\Vendor\MuxPhp\Models\SimulcastTargetResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\MediaCloud\Vendor\MuxPhp\Models\SimulcastTargetResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\MediaCloud\Vendor\MuxPhp\Models\SimulcastTargetResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\MediaCloud\Vendor\MuxPhp\Models\SimulcastTargetResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getLiveStreamSimulcastTargetAsync
     *
     * Retrieve a Live Stream Simulcast Target
     *
     * @param  string $live_stream_id The live stream ID (required)
     * @param  string $simulcast_target_id The ID of the simulcast target. (required)
     *
     * @throws \InvalidArgumentException
     * @return \MediaCloud\Vendor\GuzzleHttp\Promise\PromiseInterface
     */
    public function getLiveStreamSimulcastTargetAsync($live_stream_id, $simulcast_target_id)
    {
        return $this->getLiveStreamSimulcastTargetAsyncWithHttpInfo($live_stream_id, $simulcast_target_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getLiveStreamSimulcastTargetAsyncWithHttpInfo
     *
     * Retrieve a Live Stream Simulcast Target
     *
     * @param  string $live_stream_id The live stream ID (required)
     * @param  string $simulcast_target_id The ID of the simulcast target. (required)
     *
     * @throws \InvalidArgumentException
     * @return \MediaCloud\Vendor\GuzzleHttp\Promise\PromiseInterface
     */
    public function getLiveStreamSimulcastTargetAsyncWithHttpInfo($live_stream_id, $simulcast_target_id)
    {
        $returnType = '\MediaCloud\Vendor\MuxPhp\Models\SimulcastTargetResponse';
        $request = $this->getLiveStreamSimulcastTargetRequest($live_stream_id, $simulcast_target_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getLiveStreamSimulcastTarget'
     *
     * @param  string $live_stream_id The live stream ID (required)
     * @param  string $simulcast_target_id The ID of the simulcast target. (required)
     *
     * @throws \InvalidArgumentException
     * @return \MediaCloud\Vendor\GuzzleHttp\Psr7\Request
     */
    protected function getLiveStreamSimulcastTargetRequest($live_stream_id, $simulcast_target_id)
    {
        // verify the required parameter 'live_stream_id' is set
        if ($live_stream_id === null || (is_array($live_stream_id) && count($live_stream_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $live_stream_id when calling getLiveStreamSimulcastTarget'
            );
        }
        // verify the required parameter 'simulcast_target_id' is set
        if ($simulcast_target_id === null || (is_array($simulcast_target_id) && count($simulcast_target_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $simulcast_target_id when calling getLiveStreamSimulcastTarget'
            );
        }

        $resourcePath = '/video/v1/live-streams/{LIVE_STREAM_ID}/simulcast-targets/{SIMULCAST_TARGET_ID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($live_stream_id !== null) {
            $resourcePath = str_replace(
                '{' . 'LIVE_STREAM_ID' . '}',
                ObjectSerializer::toPathValue($live_stream_id),
                $resourcePath
            );
        }
        // path params
        if ($simulcast_target_id !== null) {
            $resourcePath = str_replace(
                '{' . 'SIMULCAST_TARGET_ID' . '}',
                ObjectSerializer::toPathValue($simulcast_target_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \MediaCloud\Vendor\GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \MediaCloud\Vendor\GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \MediaCloud\Vendor\GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires HTTP basic authentication
        if (!empty($this->config->getUsername()) || !(empty($this->config->getPassword()))) {
            $headers['Authorization'] = 'Basic ' . base64_encode($this->config->getUsername() . ':' . $this->config->getPassword());
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $queryParamsDirect = join('&', $queryParams);
        $query = \MediaCloud\Vendor\GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($queryParamsDirect ? "?{$queryParamsDirect}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation listLiveStreams
     *
     * List live streams
     *
     * @param  mixed[] $optionalParams An associative array of optional parameters which can be passed to this function:
     *     - limit int - Number of items to include in the response (optional, default to 25)
     *     - page int - Offset by this many pages, of the size of &#x60;limit&#x60; (optional, default to 1)
     *
     * @throws \MediaCloud\Vendor\MuxPhp\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \MediaCloud\Vendor\MuxPhp\Models\ListLiveStreamsResponse
     */
    public function listLiveStreams($optionalParams = [])
    {
        list($response) = $this->listLiveStreamsWithHttpInfo($optionalParams);
        return $response;
    }

    /**
     * Operation listLiveStreamsWithHttpInfo
     *
     * List live streams
     *
     * @param  mixed[] $optionalParams An associative array of optional parameters which can be passed to this function:
     *     - limit int - Number of items to include in the response (optional, default to 25)
     *     - page int - Offset by this many pages, of the size of &#x60;limit&#x60; (optional, default to 1)
     *
     * @throws \MediaCloud\Vendor\MuxPhp\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \MediaCloud\Vendor\MuxPhp\Models\ListLiveStreamsResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function listLiveStreamsWithHttpInfo($optionalParams = [])
    {
        $request = $this->listLiveStreamsRequest($optionalParams);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\MediaCloud\Vendor\MuxPhp\Models\ListLiveStreamsResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\MediaCloud\Vendor\MuxPhp\Models\ListLiveStreamsResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\MediaCloud\Vendor\MuxPhp\Models\ListLiveStreamsResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\MediaCloud\Vendor\MuxPhp\Models\ListLiveStreamsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation listLiveStreamsAsync
     *
     * List live streams
     *
     * @param  mixed[] $optionalParams An associative array of optional parameters which can be passed to this function:
     *     - limit int - Number of items to include in the response (optional, default to 25)
     *     - page int - Offset by this many pages, of the size of &#x60;limit&#x60; (optional, default to 1)
     *
     * @throws \InvalidArgumentException
     * @return \MediaCloud\Vendor\GuzzleHttp\Promise\PromiseInterface
     */
    public function listLiveStreamsAsync($optionalParams = [])
    {
        return $this->listLiveStreamsAsyncWithHttpInfo($optionalParams)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation listLiveStreamsAsyncWithHttpInfo
     *
     * List live streams
     *
     * @param  mixed[] $optionalParams An associative array of optional parameters which can be passed to this function:
     *     - limit int - Number of items to include in the response (optional, default to 25)
     *     - page int - Offset by this many pages, of the size of &#x60;limit&#x60; (optional, default to 1)
     *
     * @throws \InvalidArgumentException
     * @return \MediaCloud\Vendor\GuzzleHttp\Promise\PromiseInterface
     */
    public function listLiveStreamsAsyncWithHttpInfo($optionalParams = [])
    {
        $returnType = '\MediaCloud\Vendor\MuxPhp\Models\ListLiveStreamsResponse';
        $request = $this->listLiveStreamsRequest($optionalParams);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'listLiveStreams'
     *
     * @param  mixed[] $optionalParams An associative array of optional parameters which can be passed to this function:
     *     - limit int - Number of items to include in the response (optional, default to 25)
     *     - page int - Offset by this many pages, of the size of &#x60;limit&#x60; (optional, default to 1)
     *
     * @throws \InvalidArgumentException
     * @return \MediaCloud\Vendor\GuzzleHttp\Psr7\Request
     */
    protected function listLiveStreamsRequest($optionalParams)
    {
        // Pull the set optional params from the associative array $optionalParams, setting them to their defaults if they're not set.
        $limit = array_key_exists('limit', $optionalParams) ? $optionalParams['limit'] : 25;
        $page = array_key_exists('page', $optionalParams) ? $optionalParams['page'] : 1;

        $resourcePath = '/video/v1/live-streams';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // Query Param: limit
        if ($limit !== null) {
            array_push($queryParams, 'limit=' . ObjectSerializer::toQueryValue($limit));
        }
        // Query Param: page
        if ($page !== null) {
            array_push($queryParams, 'page=' . ObjectSerializer::toQueryValue($page));
        }



        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \MediaCloud\Vendor\GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \MediaCloud\Vendor\GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \MediaCloud\Vendor\GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires HTTP basic authentication
        if (!empty($this->config->getUsername()) || !(empty($this->config->getPassword()))) {
            $headers['Authorization'] = 'Basic ' . base64_encode($this->config->getUsername() . ':' . $this->config->getPassword());
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $queryParamsDirect = join('&', $queryParams);
        $query = \MediaCloud\Vendor\GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($queryParamsDirect ? "?{$queryParamsDirect}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation resetStreamKey
     *
     * Reset a live stream’s stream key
     *
     * @param  string $live_stream_id The live stream ID (required)
     *
     * @throws \MediaCloud\Vendor\MuxPhp\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \MediaCloud\Vendor\MuxPhp\Models\LiveStreamResponse
     */
    public function resetStreamKey($live_stream_id)
    {
        list($response) = $this->resetStreamKeyWithHttpInfo($live_stream_id);
        return $response;
    }

    /**
     * Operation resetStreamKeyWithHttpInfo
     *
     * Reset a live stream’s stream key
     *
     * @param  string $live_stream_id The live stream ID (required)
     *
     * @throws \MediaCloud\Vendor\MuxPhp\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \MediaCloud\Vendor\MuxPhp\Models\LiveStreamResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function resetStreamKeyWithHttpInfo($live_stream_id)
    {
        $request = $this->resetStreamKeyRequest($live_stream_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 201:
                    if ('\MediaCloud\Vendor\MuxPhp\Models\LiveStreamResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\MediaCloud\Vendor\MuxPhp\Models\LiveStreamResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\MediaCloud\Vendor\MuxPhp\Models\LiveStreamResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\MediaCloud\Vendor\MuxPhp\Models\LiveStreamResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation resetStreamKeyAsync
     *
     * Reset a live stream’s stream key
     *
     * @param  string $live_stream_id The live stream ID (required)
     *
     * @throws \InvalidArgumentException
     * @return \MediaCloud\Vendor\GuzzleHttp\Promise\PromiseInterface
     */
    public function resetStreamKeyAsync($live_stream_id)
    {
        return $this->resetStreamKeyAsyncWithHttpInfo($live_stream_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation resetStreamKeyAsyncWithHttpInfo
     *
     * Reset a live stream’s stream key
     *
     * @param  string $live_stream_id The live stream ID (required)
     *
     * @throws \InvalidArgumentException
     * @return \MediaCloud\Vendor\GuzzleHttp\Promise\PromiseInterface
     */
    public function resetStreamKeyAsyncWithHttpInfo($live_stream_id)
    {
        $returnType = '\MediaCloud\Vendor\MuxPhp\Models\LiveStreamResponse';
        $request = $this->resetStreamKeyRequest($live_stream_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'resetStreamKey'
     *
     * @param  string $live_stream_id The live stream ID (required)
     *
     * @throws \InvalidArgumentException
     * @return \MediaCloud\Vendor\GuzzleHttp\Psr7\Request
     */
    protected function resetStreamKeyRequest($live_stream_id)
    {
        // verify the required parameter 'live_stream_id' is set
        if ($live_stream_id === null || (is_array($live_stream_id) && count($live_stream_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $live_stream_id when calling resetStreamKey'
            );
        }

        $resourcePath = '/video/v1/live-streams/{LIVE_STREAM_ID}/reset-stream-key';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($live_stream_id !== null) {
            $resourcePath = str_replace(
                '{' . 'LIVE_STREAM_ID' . '}',
                ObjectSerializer::toPathValue($live_stream_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \MediaCloud\Vendor\GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \MediaCloud\Vendor\GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \MediaCloud\Vendor\GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires HTTP basic authentication
        if (!empty($this->config->getUsername()) || !(empty($this->config->getPassword()))) {
            $headers['Authorization'] = 'Basic ' . base64_encode($this->config->getUsername() . ':' . $this->config->getPassword());
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $queryParamsDirect = join('&', $queryParams);
        $query = \MediaCloud\Vendor\GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($queryParamsDirect ? "?{$queryParamsDirect}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation signalLiveStreamComplete
     *
     * Signal a live stream is finished
     *
     * @param  string $live_stream_id The live stream ID (required)
     *
     * @throws \MediaCloud\Vendor\MuxPhp\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \MediaCloud\Vendor\MuxPhp\Models\SignalLiveStreamCompleteResponse
     */
    public function signalLiveStreamComplete($live_stream_id)
    {
        list($response) = $this->signalLiveStreamCompleteWithHttpInfo($live_stream_id);
        return $response;
    }

    /**
     * Operation signalLiveStreamCompleteWithHttpInfo
     *
     * Signal a live stream is finished
     *
     * @param  string $live_stream_id The live stream ID (required)
     *
     * @throws \MediaCloud\Vendor\MuxPhp\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \MediaCloud\Vendor\MuxPhp\Models\SignalLiveStreamCompleteResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function signalLiveStreamCompleteWithHttpInfo($live_stream_id)
    {
        $request = $this->signalLiveStreamCompleteRequest($live_stream_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\MediaCloud\Vendor\MuxPhp\Models\SignalLiveStreamCompleteResponse' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\MediaCloud\Vendor\MuxPhp\Models\SignalLiveStreamCompleteResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\MediaCloud\Vendor\MuxPhp\Models\SignalLiveStreamCompleteResponse';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\MediaCloud\Vendor\MuxPhp\Models\SignalLiveStreamCompleteResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation signalLiveStreamCompleteAsync
     *
     * Signal a live stream is finished
     *
     * @param  string $live_stream_id The live stream ID (required)
     *
     * @throws \InvalidArgumentException
     * @return \MediaCloud\Vendor\GuzzleHttp\Promise\PromiseInterface
     */
    public function signalLiveStreamCompleteAsync($live_stream_id)
    {
        return $this->signalLiveStreamCompleteAsyncWithHttpInfo($live_stream_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation signalLiveStreamCompleteAsyncWithHttpInfo
     *
     * Signal a live stream is finished
     *
     * @param  string $live_stream_id The live stream ID (required)
     *
     * @throws \InvalidArgumentException
     * @return \MediaCloud\Vendor\GuzzleHttp\Promise\PromiseInterface
     */
    public function signalLiveStreamCompleteAsyncWithHttpInfo($live_stream_id)
    {
        $returnType = '\MediaCloud\Vendor\MuxPhp\Models\SignalLiveStreamCompleteResponse';
        $request = $this->signalLiveStreamCompleteRequest($live_stream_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'signalLiveStreamComplete'
     *
     * @param  string $live_stream_id The live stream ID (required)
     *
     * @throws \InvalidArgumentException
     * @return \MediaCloud\Vendor\GuzzleHttp\Psr7\Request
     */
    protected function signalLiveStreamCompleteRequest($live_stream_id)
    {
        // verify the required parameter 'live_stream_id' is set
        if ($live_stream_id === null || (is_array($live_stream_id) && count($live_stream_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $live_stream_id when calling signalLiveStreamComplete'
            );
        }

        $resourcePath = '/video/v1/live-streams/{LIVE_STREAM_ID}/complete';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($live_stream_id !== null) {
            $resourcePath = str_replace(
                '{' . 'LIVE_STREAM_ID' . '}',
                ObjectSerializer::toPathValue($live_stream_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \MediaCloud\Vendor\GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \MediaCloud\Vendor\GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \MediaCloud\Vendor\GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires HTTP basic authentication
        if (!empty($this->config->getUsername()) || !(empty($this->config->getPassword()))) {
            $headers['Authorization'] = 'Basic ' . base64_encode($this->config->getUsername() . ':' . $this->config->getPassword());
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $queryParamsDirect = join('&', $queryParams);
        $query = \MediaCloud\Vendor\GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($queryParamsDirect ? "?{$queryParamsDirect}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
