<?php

namespace MediaCloud\Vendor\Illuminate\Events;
use MediaCloud\Vendor\Illuminate\Support\ServiceProvider;
use MediaCloud\Vendor\Illuminate\Contracts\Queue\Factory as QueueFactoryContract;

class EventServiceProvider extends ServiceProvider
{
    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {
        $this->app->singleton('events', function ($app) {
            return (new Dispatcher($app))->setQueueResolver(function () use ($app) {
                return $app->make(QueueFactoryContract::class);
            });
        });
    }
}
