<?php

namespace WP_Arvan\OBS;

use Aws\S3\Exception\S3Exception;

class ApiValidator
{
    private $kueue;
    private const  interval = 60*60*24; // A Day

    public function __construct(){

        add_action('obs_periodic_validate_api', [$this, 'periodicValidateApi']);
        $this->kueue = new Kueue\KueueCore();
    }

    public function setup(){
        if(!$this->kueue->has_pending_job('obs_periodic_validate_api')) {
            $this->kueue->add_job(time(), self::interval, 'obs_periodic_validate_api', array(), null);
            $this->kueue->schedule_jobs();
        }

        if(get_option('OBS_INVALID_API_KEY')){
            Helper::show_admin_notice('Invalid API key, Please provide a valid access and secret key ' . "<a href='".admin_url('admin.php?page=wp-arvancloud-storage')."'> ".__("Setting page", 'arvancloud-object-storage' )." </a>");
        };
    }
    public function periodicValidateApi(){
        $s3client = S3Singletone::get_instance();

        try {
            $buckets = $s3client->get_s3client()->listBuckets();
            update_option('OBS_INVALID_API_KEY', false);
        }catch (S3Exception $ex){
            if($ex->getStatusCode() == 403)
            {
                update_option('OBS_INVALID_API_KEY', true);
                delete_option('arvan-cloud-storage-settings');

            }
        }
    }
}