<?php

/**
 * Mux PHP - Copyright 2019 Mux Inc.
 * NOTE: This file is auto generated. Do not edit this file manually.
 */

namespace MediaCloud\Vendor\MuxPhp\Models;

use \ArrayAccess;
use \MediaCloud\Vendor\MuxPhp\ObjectSerializer;

/**
 * LiveStream Class Doc Comment
 *
 * @category Class
 * @package  MuxPhp
 */
class LiveStream implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
     * The original name of the model.
     *
     * @var string
     */
    protected static $openAPIModelName = 'LiveStream';

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @var string[]
     */
    protected static $openAPITypes = [
        'id' => 'string',
        'created_at' => 'string',
        'stream_key' => 'string',
        'active_asset_id' => 'string',
        'recent_asset_ids' => 'string[]',
        'status' => 'string',
        'playback_ids' => '\MediaCloud\Vendor\MuxPhp\Models\PlaybackID[]',
        'new_asset_settings' => '\MediaCloud\Vendor\MuxPhp\Models\Asset',
        'passthrough' => 'string',
        'reconnect_window' => 'float',
        'reduced_latency' => 'bool',
        'simulcast_targets' => '\MediaCloud\Vendor\MuxPhp\Models\SimulcastTarget[]',
        'test' => 'bool'
    ];

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @var string[]
     */
    protected static $openAPIFormats = [
        'id' => null,
        'created_at' => 'int64',
        'stream_key' => null,
        'active_asset_id' => null,
        'recent_asset_ids' => null,
        'status' => null,
        'playback_ids' => null,
        'new_asset_settings' => null,
        'passthrough' => null,
        'reconnect_window' => null,
        'reduced_latency' => 'boolean',
        'simulcast_targets' => null,
        'test' => 'boolean'
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'created_at' => 'created_at',
        'stream_key' => 'stream_key',
        'active_asset_id' => 'active_asset_id',
        'recent_asset_ids' => 'recent_asset_ids',
        'status' => 'status',
        'playback_ids' => 'playback_ids',
        'new_asset_settings' => 'new_asset_settings',
        'passthrough' => 'passthrough',
        'reconnect_window' => 'reconnect_window',
        'reduced_latency' => 'reduced_latency',
        'simulcast_targets' => 'simulcast_targets',
        'test' => 'test'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'created_at' => 'setCreatedAt',
        'stream_key' => 'setStreamKey',
        'active_asset_id' => 'setActiveAssetId',
        'recent_asset_ids' => 'setRecentAssetIds',
        'status' => 'setStatus',
        'playback_ids' => 'setPlaybackIds',
        'new_asset_settings' => 'setNewAssetSettings',
        'passthrough' => 'setPassthrough',
        'reconnect_window' => 'setReconnectWindow',
        'reduced_latency' => 'setReducedLatency',
        'simulcast_targets' => 'setSimulcastTargets',
        'test' => 'setTest'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'created_at' => 'getCreatedAt',
        'stream_key' => 'getStreamKey',
        'active_asset_id' => 'getActiveAssetId',
        'recent_asset_ids' => 'getRecentAssetIds',
        'status' => 'getStatus',
        'playback_ids' => 'getPlaybackIds',
        'new_asset_settings' => 'getNewAssetSettings',
        'passthrough' => 'getPassthrough',
        'reconnect_window' => 'getReconnectWindow',
        'reduced_latency' => 'getReducedLatency',
        'simulcast_targets' => 'getSimulcastTargets',
        'test' => 'getTest'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    

    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['created_at'] = isset($data['created_at']) ? $data['created_at'] : null;
        $this->container['stream_key'] = isset($data['stream_key']) ? $data['stream_key'] : null;
        $this->container['active_asset_id'] = isset($data['active_asset_id']) ? $data['active_asset_id'] : null;
        $this->container['recent_asset_ids'] = isset($data['recent_asset_ids']) ? $data['recent_asset_ids'] : null;
        $this->container['status'] = isset($data['status']) ? $data['status'] : null;
        $this->container['playback_ids'] = isset($data['playback_ids']) ? $data['playback_ids'] : null;
        $this->container['new_asset_settings'] = isset($data['new_asset_settings']) ? $data['new_asset_settings'] : null;
        $this->container['passthrough'] = isset($data['passthrough']) ? $data['passthrough'] : null;
        $this->container['reconnect_window'] = isset($data['reconnect_window']) ? $data['reconnect_window'] : null;
        $this->container['reduced_latency'] = isset($data['reduced_latency']) ? $data['reduced_latency'] : null;
        $this->container['simulcast_targets'] = isset($data['simulcast_targets']) ? $data['simulcast_targets'] : null;
        $this->container['test'] = isset($data['test']) ? $data['test'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return string|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param string|null $id id
     *
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets created_at
     *
     * @return string|null
     */
    public function getCreatedAt()
    {
        return $this->container['created_at'];
    }

    /**
     * Sets created_at
     *
     * @param string|null $created_at created_at
     *
     * @return $this
     */
    public function setCreatedAt($created_at)
    {
        $this->container['created_at'] = $created_at;

        return $this;
    }

    /**
     * Gets stream_key
     *
     * @return string|null
     */
    public function getStreamKey()
    {
        return $this->container['stream_key'];
    }

    /**
     * Sets stream_key
     *
     * @param string|null $stream_key stream_key
     *
     * @return $this
     */
    public function setStreamKey($stream_key)
    {
        $this->container['stream_key'] = $stream_key;

        return $this;
    }

    /**
     * Gets active_asset_id
     *
     * @return string|null
     */
    public function getActiveAssetId()
    {
        return $this->container['active_asset_id'];
    }

    /**
     * Sets active_asset_id
     *
     * @param string|null $active_asset_id active_asset_id
     *
     * @return $this
     */
    public function setActiveAssetId($active_asset_id)
    {
        $this->container['active_asset_id'] = $active_asset_id;

        return $this;
    }

    /**
     * Gets recent_asset_ids
     *
     * @return string[]|null
     */
    public function getRecentAssetIds()
    {
        return $this->container['recent_asset_ids'];
    }

    /**
     * Sets recent_asset_ids
     *
     * @param string[]|null $recent_asset_ids recent_asset_ids
     *
     * @return $this
     */
    public function setRecentAssetIds($recent_asset_ids)
    {
        $this->container['recent_asset_ids'] = $recent_asset_ids;

        return $this;
    }

    /**
     * Gets status
     *
     * @return string|null
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     *
     * @param string|null $status status
     *
     * @return $this
     */
    public function setStatus($status)
    {
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets playback_ids
     *
     * @return \MediaCloud\Vendor\MuxPhp\Models\PlaybackID[]|null
     */
    public function getPlaybackIds()
    {
        return $this->container['playback_ids'];
    }

    /**
     * Sets playback_ids
     *
     * @param \MediaCloud\Vendor\MuxPhp\Models\PlaybackID[]|null $playback_ids playback_ids
     *
     * @return $this
     */
    public function setPlaybackIds($playback_ids)
    {
        $this->container['playback_ids'] = $playback_ids;

        return $this;
    }

    /**
     * Gets new_asset_settings
     *
     * @return \MediaCloud\Vendor\MuxPhp\Models\Asset|null
     */
    public function getNewAssetSettings()
    {
        return $this->container['new_asset_settings'];
    }

    /**
     * Sets new_asset_settings
     *
     * @param \MediaCloud\Vendor\MuxPhp\Models\Asset|null $new_asset_settings new_asset_settings
     *
     * @return $this
     */
    public function setNewAssetSettings($new_asset_settings)
    {
        $this->container['new_asset_settings'] = $new_asset_settings;

        return $this;
    }

    /**
     * Gets passthrough
     *
     * @return string|null
     */
    public function getPassthrough()
    {
        return $this->container['passthrough'];
    }

    /**
     * Sets passthrough
     *
     * @param string|null $passthrough passthrough
     *
     * @return $this
     */
    public function setPassthrough($passthrough)
    {
        $this->container['passthrough'] = $passthrough;

        return $this;
    }

    /**
     * Gets reconnect_window
     *
     * @return float|null
     */
    public function getReconnectWindow()
    {
        return $this->container['reconnect_window'];
    }

    /**
     * Sets reconnect_window
     *
     * @param float|null $reconnect_window reconnect_window
     *
     * @return $this
     */
    public function setReconnectWindow($reconnect_window)
    {
        $this->container['reconnect_window'] = $reconnect_window;

        return $this;
    }

    /**
     * Gets reduced_latency
     *
     * @return bool|null
     */
    public function getReducedLatency()
    {
        return $this->container['reduced_latency'];
    }

    /**
     * Sets reduced_latency
     *
     * @param bool|null $reduced_latency reduced_latency
     *
     * @return $this
     */
    public function setReducedLatency($reduced_latency)
    {
        $this->container['reduced_latency'] = $reduced_latency;

        return $this;
    }

    /**
     * Gets simulcast_targets
     *
     * @return \MediaCloud\Vendor\MuxPhp\Models\SimulcastTarget[]|null
     */
    public function getSimulcastTargets()
    {
        return $this->container['simulcast_targets'];
    }

    /**
     * Sets simulcast_targets
     *
     * @param \MediaCloud\Vendor\MuxPhp\Models\SimulcastTarget[]|null $simulcast_targets simulcast_targets
     *
     * @return $this
     */
    public function setSimulcastTargets($simulcast_targets)
    {
        $this->container['simulcast_targets'] = $simulcast_targets;

        return $this;
    }

    /**
     * Gets test
     *
     * @return bool|null
     */
    public function getTest()
    {
        return $this->container['test'];
    }

    /**
     * Sets test
     *
     * @param bool|null $test test
     *
     * @return $this
     */
    public function setTest($test)
    {
        $this->container['test'] = $test;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }
}


