<?php

namespace MediaCloud\Vendor\Aws\Ec2;
use MediaCloud\Vendor\Aws\AwsClient;
use MediaCloud\Vendor\Aws\Api\Service;
use MediaCloud\Vendor\Aws\Api\DocModel;
use MediaCloud\Vendor\Aws\Api\ApiProvider;
use MediaCloud\Vendor\Aws\PresignUrlMiddleware;

/**
 * Client used to interact with Amazon EC2.
 *
 * @method \MediaCloud\Vendor\Aws\Result acceptVpcPeeringConnection(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise acceptVpcPeeringConnectionAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result allocateAddress(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise allocateAddressAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result allocateHosts(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise allocateHostsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result assignPrivateIpAddresses(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise assignPrivateIpAddressesAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result associateAddress(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise associateAddressAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result associateDhcpOptions(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise associateDhcpOptionsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result associateRouteTable(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise associateRouteTableAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result attachClassicLinkVpc(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise attachClassicLinkVpcAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result attachInternetGateway(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise attachInternetGatewayAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result attachNetworkInterface(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise attachNetworkInterfaceAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result attachVolume(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise attachVolumeAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result attachVpnGateway(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise attachVpnGatewayAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result authorizeSecurityGroupEgress(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise authorizeSecurityGroupEgressAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result authorizeSecurityGroupIngress(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise authorizeSecurityGroupIngressAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result bundleInstance(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise bundleInstanceAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result cancelBundleTask(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise cancelBundleTaskAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result cancelConversionTask(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise cancelConversionTaskAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result cancelExportTask(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise cancelExportTaskAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result cancelImportTask(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise cancelImportTaskAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result cancelReservedInstancesListing(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise cancelReservedInstancesListingAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result cancelSpotFleetRequests(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise cancelSpotFleetRequestsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result cancelSpotInstanceRequests(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise cancelSpotInstanceRequestsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result confirmProductInstance(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise confirmProductInstanceAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result copyImage(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise copyImageAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result copySnapshot(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise copySnapshotAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createCustomerGateway(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createCustomerGatewayAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createDhcpOptions(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createDhcpOptionsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createFlowLogs(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createFlowLogsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createImage(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createImageAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createInstanceExportTask(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createInstanceExportTaskAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createInternetGateway(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createInternetGatewayAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createKeyPair(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createKeyPairAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createNatGateway(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createNatGatewayAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createNetworkAcl(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createNetworkAclAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createNetworkAclEntry(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createNetworkAclEntryAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createNetworkInterface(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createNetworkInterfaceAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createPlacementGroup(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createPlacementGroupAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createReservedInstancesListing(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createReservedInstancesListingAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createRoute(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createRouteAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createRouteTable(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createRouteTableAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createSecurityGroup(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createSecurityGroupAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createSnapshot(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createSnapshotAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createSpotDatafeedSubscription(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createSpotDatafeedSubscriptionAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createSubnet(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createSubnetAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createTags(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createTagsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createVolume(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createVolumeAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createVpc(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createVpcAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createVpcEndpoint(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createVpcEndpointAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createVpcPeeringConnection(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createVpcPeeringConnectionAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createVpnConnection(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createVpnConnectionAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createVpnConnectionRoute(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createVpnConnectionRouteAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createVpnGateway(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createVpnGatewayAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteCustomerGateway(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteCustomerGatewayAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteDhcpOptions(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteDhcpOptionsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteFlowLogs(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteFlowLogsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteInternetGateway(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteInternetGatewayAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteKeyPair(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteKeyPairAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteNatGateway(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteNatGatewayAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteNetworkAcl(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteNetworkAclAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteNetworkAclEntry(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteNetworkAclEntryAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteNetworkInterface(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteNetworkInterfaceAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deletePlacementGroup(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deletePlacementGroupAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteRoute(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteRouteAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteRouteTable(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteRouteTableAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteSecurityGroup(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteSecurityGroupAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteSnapshot(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteSnapshotAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteSpotDatafeedSubscription(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteSpotDatafeedSubscriptionAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteSubnet(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteSubnetAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteTags(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteTagsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteVolume(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteVolumeAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteVpc(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteVpcAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteVpcEndpoints(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteVpcEndpointsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteVpcPeeringConnection(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteVpcPeeringConnectionAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteVpnConnection(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteVpnConnectionAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteVpnConnectionRoute(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteVpnConnectionRouteAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteVpnGateway(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteVpnGatewayAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deregisterImage(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deregisterImageAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeAccountAttributes(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeAccountAttributesAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeAddresses(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeAddressesAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeAvailabilityZones(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeAvailabilityZonesAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeBundleTasks(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeBundleTasksAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeClassicLinkInstances(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeClassicLinkInstancesAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeConversionTasks(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeConversionTasksAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeCustomerGateways(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeCustomerGatewaysAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeDhcpOptions(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeDhcpOptionsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeExportTasks(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeExportTasksAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeFlowLogs(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeFlowLogsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeHosts(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeHostsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeIdFormat(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeIdFormatAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeImageAttribute(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeImageAttributeAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeImages(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeImagesAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeImportImageTasks(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeImportImageTasksAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeImportSnapshotTasks(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeImportSnapshotTasksAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeInstanceAttribute(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeInstanceAttributeAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeInstanceStatus(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeInstanceStatusAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeInstances(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeInstancesAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeInternetGateways(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeInternetGatewaysAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeKeyPairs(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeKeyPairsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeMovingAddresses(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeMovingAddressesAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeNatGateways(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeNatGatewaysAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeNetworkAcls(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeNetworkAclsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeNetworkInterfaceAttribute(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeNetworkInterfaceAttributeAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeNetworkInterfaces(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeNetworkInterfacesAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describePlacementGroups(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describePlacementGroupsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describePrefixLists(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describePrefixListsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeRegions(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeRegionsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeReservedInstances(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeReservedInstancesAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeReservedInstancesListings(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeReservedInstancesListingsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeReservedInstancesModifications(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeReservedInstancesModificationsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeReservedInstancesOfferings(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeReservedInstancesOfferingsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeRouteTables(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeRouteTablesAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeScheduledInstanceAvailability(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeScheduledInstanceAvailabilityAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeScheduledInstances(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeScheduledInstancesAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeSecurityGroupReferences(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeSecurityGroupReferencesAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeSecurityGroups(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeSecurityGroupsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeSnapshotAttribute(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeSnapshotAttributeAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeSnapshots(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeSnapshotsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeSpotDatafeedSubscription(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeSpotDatafeedSubscriptionAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeSpotFleetInstances(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeSpotFleetInstancesAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeSpotFleetRequestHistory(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeSpotFleetRequestHistoryAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeSpotFleetRequests(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeSpotFleetRequestsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeSpotInstanceRequests(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeSpotInstanceRequestsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeSpotPriceHistory(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeSpotPriceHistoryAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeStaleSecurityGroups(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeStaleSecurityGroupsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeSubnets(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeSubnetsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeTags(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeTagsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeVolumeAttribute(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeVolumeAttributeAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeVolumeStatus(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeVolumeStatusAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeVolumes(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeVolumesAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeVpcAttribute(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeVpcAttributeAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeVpcClassicLink(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeVpcClassicLinkAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeVpcClassicLinkDnsSupport(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeVpcClassicLinkDnsSupportAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeVpcEndpointServices(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeVpcEndpointServicesAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeVpcEndpoints(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeVpcEndpointsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeVpcPeeringConnections(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeVpcPeeringConnectionsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeVpcs(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeVpcsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeVpnConnections(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeVpnConnectionsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeVpnGateways(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeVpnGatewaysAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result detachClassicLinkVpc(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise detachClassicLinkVpcAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result detachInternetGateway(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise detachInternetGatewayAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result detachNetworkInterface(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise detachNetworkInterfaceAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result detachVolume(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise detachVolumeAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result detachVpnGateway(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise detachVpnGatewayAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result disableVgwRoutePropagation(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise disableVgwRoutePropagationAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result disableVpcClassicLink(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise disableVpcClassicLinkAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result disableVpcClassicLinkDnsSupport(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise disableVpcClassicLinkDnsSupportAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result disassociateAddress(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise disassociateAddressAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result disassociateRouteTable(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise disassociateRouteTableAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result enableVgwRoutePropagation(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise enableVgwRoutePropagationAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result enableVolumeIO(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise enableVolumeIOAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result enableVpcClassicLink(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise enableVpcClassicLinkAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result enableVpcClassicLinkDnsSupport(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise enableVpcClassicLinkDnsSupportAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result getConsoleOutput(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise getConsoleOutputAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result getConsoleScreenshot(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise getConsoleScreenshotAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result getPasswordData(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise getPasswordDataAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result importImage(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise importImageAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result importInstance(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise importInstanceAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result importKeyPair(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise importKeyPairAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result importSnapshot(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise importSnapshotAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result importVolume(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise importVolumeAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result modifyHosts(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise modifyHostsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result modifyIdFormat(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise modifyIdFormatAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result modifyImageAttribute(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise modifyImageAttributeAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result modifyInstanceAttribute(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise modifyInstanceAttributeAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result modifyInstancePlacement(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise modifyInstancePlacementAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result modifyNetworkInterfaceAttribute(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise modifyNetworkInterfaceAttributeAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result modifyReservedInstances(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise modifyReservedInstancesAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result modifySnapshotAttribute(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise modifySnapshotAttributeAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result modifySpotFleetRequest(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise modifySpotFleetRequestAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result modifySubnetAttribute(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise modifySubnetAttributeAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result modifyVolumeAttribute(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise modifyVolumeAttributeAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result modifyVpcAttribute(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise modifyVpcAttributeAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result modifyVpcEndpoint(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise modifyVpcEndpointAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result modifyVpcPeeringConnectionOptions(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise modifyVpcPeeringConnectionOptionsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result monitorInstances(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise monitorInstancesAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result moveAddressToVpc(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise moveAddressToVpcAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result purchaseReservedInstancesOffering(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise purchaseReservedInstancesOfferingAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result purchaseScheduledInstances(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise purchaseScheduledInstancesAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result rebootInstances(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise rebootInstancesAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result registerImage(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise registerImageAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result rejectVpcPeeringConnection(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise rejectVpcPeeringConnectionAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result releaseAddress(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise releaseAddressAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result releaseHosts(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise releaseHostsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result replaceNetworkAclAssociation(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise replaceNetworkAclAssociationAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result replaceNetworkAclEntry(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise replaceNetworkAclEntryAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result replaceRoute(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise replaceRouteAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result replaceRouteTableAssociation(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise replaceRouteTableAssociationAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result reportInstanceStatus(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise reportInstanceStatusAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result requestSpotFleet(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise requestSpotFleetAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result requestSpotInstances(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise requestSpotInstancesAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result resetImageAttribute(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise resetImageAttributeAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result resetInstanceAttribute(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise resetInstanceAttributeAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result resetNetworkInterfaceAttribute(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise resetNetworkInterfaceAttributeAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result resetSnapshotAttribute(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise resetSnapshotAttributeAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result restoreAddressToClassic(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise restoreAddressToClassicAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result revokeSecurityGroupEgress(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise revokeSecurityGroupEgressAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result revokeSecurityGroupIngress(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise revokeSecurityGroupIngressAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result runInstances(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise runInstancesAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result runScheduledInstances(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise runScheduledInstancesAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result startInstances(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise startInstancesAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result stopInstances(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise stopInstancesAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result terminateInstances(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise terminateInstancesAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result unassignPrivateIpAddresses(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise unassignPrivateIpAddressesAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result unmonitorInstances(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise unmonitorInstancesAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeHostReservationOfferings(array $args = []) (supported in versions 2016-04-01, 2016-09-15, 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeHostReservationOfferingsAsync(array $args = []) (supported in versions 2016-04-01, 2016-09-15, 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result describeHostReservations(array $args = []) (supported in versions 2016-04-01, 2016-09-15, 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeHostReservationsAsync(array $args = []) (supported in versions 2016-04-01, 2016-09-15, 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result describeIdentityIdFormat(array $args = []) (supported in versions 2016-04-01, 2016-09-15, 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeIdentityIdFormatAsync(array $args = []) (supported in versions 2016-04-01, 2016-09-15, 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result getHostReservationPurchasePreview(array $args = []) (supported in versions 2016-04-01, 2016-09-15, 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise getHostReservationPurchasePreviewAsync(array $args = []) (supported in versions 2016-04-01, 2016-09-15, 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result modifyIdentityIdFormat(array $args = []) (supported in versions 2016-04-01, 2016-09-15, 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise modifyIdentityIdFormatAsync(array $args = []) (supported in versions 2016-04-01, 2016-09-15, 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result purchaseHostReservation(array $args = []) (supported in versions 2016-04-01, 2016-09-15, 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise purchaseHostReservationAsync(array $args = []) (supported in versions 2016-04-01, 2016-09-15, 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result acceptReservedInstancesExchangeQuote(array $args = []) (supported in versions 2016-09-15, 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise acceptReservedInstancesExchangeQuoteAsync(array $args = []) (supported in versions 2016-09-15, 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result getReservedInstancesExchangeQuote(array $args = []) (supported in versions 2016-09-15, 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise getReservedInstancesExchangeQuoteAsync(array $args = []) (supported in versions 2016-09-15, 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result acceptTransitGatewayPeeringAttachment(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise acceptTransitGatewayPeeringAttachmentAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result acceptTransitGatewayVpcAttachment(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise acceptTransitGatewayVpcAttachmentAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result acceptVpcEndpointConnections(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise acceptVpcEndpointConnectionsAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result advertiseByoipCidr(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise advertiseByoipCidrAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result applySecurityGroupsToClientVpnTargetNetwork(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise applySecurityGroupsToClientVpnTargetNetworkAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result assignIpv6Addresses(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise assignIpv6AddressesAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result associateClientVpnTargetNetwork(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise associateClientVpnTargetNetworkAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result associateIamInstanceProfile(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise associateIamInstanceProfileAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result associateSubnetCidrBlock(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise associateSubnetCidrBlockAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result associateTransitGatewayMulticastDomain(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise associateTransitGatewayMulticastDomainAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result associateTransitGatewayRouteTable(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise associateTransitGatewayRouteTableAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result associateVpcCidrBlock(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise associateVpcCidrBlockAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result authorizeClientVpnIngress(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise authorizeClientVpnIngressAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result cancelCapacityReservation(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise cancelCapacityReservationAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result copyFpgaImage(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise copyFpgaImageAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result createCapacityReservation(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createCapacityReservationAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result createCarrierGateway(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createCarrierGatewayAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result createClientVpnEndpoint(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createClientVpnEndpointAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result createClientVpnRoute(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createClientVpnRouteAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result createDefaultSubnet(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createDefaultSubnetAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result createDefaultVpc(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createDefaultVpcAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result createEgressOnlyInternetGateway(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createEgressOnlyInternetGatewayAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result createFleet(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createFleetAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result createFpgaImage(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createFpgaImageAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result createLaunchTemplate(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createLaunchTemplateAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result createLaunchTemplateVersion(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createLaunchTemplateVersionAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result createLocalGatewayRoute(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createLocalGatewayRouteAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result createLocalGatewayRouteTableVpcAssociation(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createLocalGatewayRouteTableVpcAssociationAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result createManagedPrefixList(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createManagedPrefixListAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result createNetworkInterfacePermission(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createNetworkInterfacePermissionAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result createSnapshots(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createSnapshotsAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result createTrafficMirrorFilter(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createTrafficMirrorFilterAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result createTrafficMirrorFilterRule(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createTrafficMirrorFilterRuleAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result createTrafficMirrorSession(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createTrafficMirrorSessionAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result createTrafficMirrorTarget(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createTrafficMirrorTargetAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result createTransitGateway(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createTransitGatewayAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result createTransitGatewayMulticastDomain(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createTransitGatewayMulticastDomainAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result createTransitGatewayPeeringAttachment(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createTransitGatewayPeeringAttachmentAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result createTransitGatewayPrefixListReference(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createTransitGatewayPrefixListReferenceAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result createTransitGatewayRoute(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createTransitGatewayRouteAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result createTransitGatewayRouteTable(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createTransitGatewayRouteTableAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result createTransitGatewayVpcAttachment(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createTransitGatewayVpcAttachmentAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result createVpcEndpointConnectionNotification(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createVpcEndpointConnectionNotificationAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result createVpcEndpointServiceConfiguration(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createVpcEndpointServiceConfigurationAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result deleteCarrierGateway(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteCarrierGatewayAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result deleteClientVpnEndpoint(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteClientVpnEndpointAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result deleteClientVpnRoute(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteClientVpnRouteAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result deleteEgressOnlyInternetGateway(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteEgressOnlyInternetGatewayAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result deleteFleets(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteFleetsAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result deleteFpgaImage(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteFpgaImageAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result deleteLaunchTemplate(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteLaunchTemplateAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result deleteLaunchTemplateVersions(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteLaunchTemplateVersionsAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result deleteLocalGatewayRoute(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteLocalGatewayRouteAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result deleteLocalGatewayRouteTableVpcAssociation(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteLocalGatewayRouteTableVpcAssociationAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result deleteManagedPrefixList(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteManagedPrefixListAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result deleteNetworkInterfacePermission(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteNetworkInterfacePermissionAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result deleteQueuedReservedInstances(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteQueuedReservedInstancesAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result deleteTrafficMirrorFilter(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteTrafficMirrorFilterAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result deleteTrafficMirrorFilterRule(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteTrafficMirrorFilterRuleAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result deleteTrafficMirrorSession(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteTrafficMirrorSessionAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result deleteTrafficMirrorTarget(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteTrafficMirrorTargetAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result deleteTransitGateway(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteTransitGatewayAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result deleteTransitGatewayMulticastDomain(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteTransitGatewayMulticastDomainAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result deleteTransitGatewayPeeringAttachment(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteTransitGatewayPeeringAttachmentAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result deleteTransitGatewayPrefixListReference(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteTransitGatewayPrefixListReferenceAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result deleteTransitGatewayRoute(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteTransitGatewayRouteAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result deleteTransitGatewayRouteTable(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteTransitGatewayRouteTableAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result deleteTransitGatewayVpcAttachment(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteTransitGatewayVpcAttachmentAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result deleteVpcEndpointConnectionNotifications(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteVpcEndpointConnectionNotificationsAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result deleteVpcEndpointServiceConfigurations(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteVpcEndpointServiceConfigurationsAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result deprovisionByoipCidr(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deprovisionByoipCidrAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result deregisterInstanceEventNotificationAttributes(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deregisterInstanceEventNotificationAttributesAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result deregisterTransitGatewayMulticastGroupMembers(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deregisterTransitGatewayMulticastGroupMembersAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result deregisterTransitGatewayMulticastGroupSources(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deregisterTransitGatewayMulticastGroupSourcesAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result describeAggregateIdFormat(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeAggregateIdFormatAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result describeByoipCidrs(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeByoipCidrsAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result describeCapacityReservations(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeCapacityReservationsAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result describeCarrierGateways(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeCarrierGatewaysAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result describeClientVpnAuthorizationRules(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeClientVpnAuthorizationRulesAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result describeClientVpnConnections(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeClientVpnConnectionsAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result describeClientVpnEndpoints(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeClientVpnEndpointsAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result describeClientVpnRoutes(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeClientVpnRoutesAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result describeClientVpnTargetNetworks(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeClientVpnTargetNetworksAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result describeCoipPools(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeCoipPoolsAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result describeEgressOnlyInternetGateways(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeEgressOnlyInternetGatewaysAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result describeElasticGpus(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeElasticGpusAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result describeExportImageTasks(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeExportImageTasksAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result describeFastSnapshotRestores(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeFastSnapshotRestoresAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result describeFleetHistory(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeFleetHistoryAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result describeFleetInstances(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeFleetInstancesAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result describeFleets(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeFleetsAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result describeFpgaImageAttribute(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeFpgaImageAttributeAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result describeFpgaImages(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeFpgaImagesAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result describeIamInstanceProfileAssociations(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeIamInstanceProfileAssociationsAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result describeInstanceCreditSpecifications(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeInstanceCreditSpecificationsAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result describeInstanceEventNotificationAttributes(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeInstanceEventNotificationAttributesAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result describeInstanceTypeOfferings(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeInstanceTypeOfferingsAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result describeInstanceTypes(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeInstanceTypesAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result describeIpv6Pools(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeIpv6PoolsAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result describeLaunchTemplateVersions(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeLaunchTemplateVersionsAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result describeLaunchTemplates(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeLaunchTemplatesAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result describeLocalGatewayRouteTableVirtualInterfaceGroupAssociations(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result describeLocalGatewayRouteTableVpcAssociations(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeLocalGatewayRouteTableVpcAssociationsAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result describeLocalGatewayRouteTables(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeLocalGatewayRouteTablesAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result describeLocalGatewayVirtualInterfaceGroups(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeLocalGatewayVirtualInterfaceGroupsAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result describeLocalGatewayVirtualInterfaces(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeLocalGatewayVirtualInterfacesAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result describeLocalGateways(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeLocalGatewaysAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result describeManagedPrefixLists(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeManagedPrefixListsAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result describeNetworkInterfacePermissions(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeNetworkInterfacePermissionsAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result describePrincipalIdFormat(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describePrincipalIdFormatAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result describePublicIpv4Pools(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describePublicIpv4PoolsAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result describeTrafficMirrorFilters(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeTrafficMirrorFiltersAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result describeTrafficMirrorSessions(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeTrafficMirrorSessionsAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result describeTrafficMirrorTargets(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeTrafficMirrorTargetsAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result describeTransitGatewayAttachments(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeTransitGatewayAttachmentsAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result describeTransitGatewayMulticastDomains(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeTransitGatewayMulticastDomainsAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result describeTransitGatewayPeeringAttachments(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeTransitGatewayPeeringAttachmentsAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result describeTransitGatewayRouteTables(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeTransitGatewayRouteTablesAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result describeTransitGatewayVpcAttachments(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeTransitGatewayVpcAttachmentsAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result describeTransitGateways(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeTransitGatewaysAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result describeVolumesModifications(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeVolumesModificationsAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result describeVpcEndpointConnectionNotifications(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeVpcEndpointConnectionNotificationsAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result describeVpcEndpointConnections(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeVpcEndpointConnectionsAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result describeVpcEndpointServiceConfigurations(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeVpcEndpointServiceConfigurationsAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result describeVpcEndpointServicePermissions(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeVpcEndpointServicePermissionsAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result disableEbsEncryptionByDefault(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise disableEbsEncryptionByDefaultAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result disableFastSnapshotRestores(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise disableFastSnapshotRestoresAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result disableTransitGatewayRouteTablePropagation(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise disableTransitGatewayRouteTablePropagationAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result disassociateClientVpnTargetNetwork(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise disassociateClientVpnTargetNetworkAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result disassociateIamInstanceProfile(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise disassociateIamInstanceProfileAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result disassociateSubnetCidrBlock(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise disassociateSubnetCidrBlockAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result disassociateTransitGatewayMulticastDomain(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise disassociateTransitGatewayMulticastDomainAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result disassociateTransitGatewayRouteTable(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise disassociateTransitGatewayRouteTableAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result disassociateVpcCidrBlock(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise disassociateVpcCidrBlockAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result enableEbsEncryptionByDefault(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise enableEbsEncryptionByDefaultAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result enableFastSnapshotRestores(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise enableFastSnapshotRestoresAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result enableTransitGatewayRouteTablePropagation(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise enableTransitGatewayRouteTablePropagationAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result exportClientVpnClientCertificateRevocationList(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise exportClientVpnClientCertificateRevocationListAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result exportClientVpnClientConfiguration(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise exportClientVpnClientConfigurationAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result exportImage(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise exportImageAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result exportTransitGatewayRoutes(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise exportTransitGatewayRoutesAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result getAssociatedIpv6PoolCidrs(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise getAssociatedIpv6PoolCidrsAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result getCapacityReservationUsage(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise getCapacityReservationUsageAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result getCoipPoolUsage(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise getCoipPoolUsageAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result getDefaultCreditSpecification(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise getDefaultCreditSpecificationAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result getEbsDefaultKmsKeyId(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise getEbsDefaultKmsKeyIdAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result getEbsEncryptionByDefault(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise getEbsEncryptionByDefaultAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result getGroupsForCapacityReservation(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise getGroupsForCapacityReservationAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result getLaunchTemplateData(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise getLaunchTemplateDataAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result getManagedPrefixListAssociations(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise getManagedPrefixListAssociationsAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result getManagedPrefixListEntries(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise getManagedPrefixListEntriesAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result getTransitGatewayAttachmentPropagations(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise getTransitGatewayAttachmentPropagationsAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result getTransitGatewayMulticastDomainAssociations(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise getTransitGatewayMulticastDomainAssociationsAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result getTransitGatewayPrefixListReferences(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise getTransitGatewayPrefixListReferencesAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result getTransitGatewayRouteTableAssociations(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise getTransitGatewayRouteTableAssociationsAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result getTransitGatewayRouteTablePropagations(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise getTransitGatewayRouteTablePropagationsAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result importClientVpnClientCertificateRevocationList(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise importClientVpnClientCertificateRevocationListAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result modifyAvailabilityZoneGroup(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise modifyAvailabilityZoneGroupAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result modifyCapacityReservation(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise modifyCapacityReservationAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result modifyClientVpnEndpoint(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise modifyClientVpnEndpointAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result modifyDefaultCreditSpecification(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise modifyDefaultCreditSpecificationAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result modifyEbsDefaultKmsKeyId(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise modifyEbsDefaultKmsKeyIdAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result modifyFleet(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise modifyFleetAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result modifyFpgaImageAttribute(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise modifyFpgaImageAttributeAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result modifyInstanceCapacityReservationAttributes(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise modifyInstanceCapacityReservationAttributesAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result modifyInstanceCreditSpecification(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise modifyInstanceCreditSpecificationAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result modifyInstanceEventStartTime(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise modifyInstanceEventStartTimeAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result modifyInstanceMetadataOptions(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise modifyInstanceMetadataOptionsAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result modifyLaunchTemplate(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise modifyLaunchTemplateAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result modifyManagedPrefixList(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise modifyManagedPrefixListAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result modifyTrafficMirrorFilterNetworkServices(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise modifyTrafficMirrorFilterNetworkServicesAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result modifyTrafficMirrorFilterRule(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise modifyTrafficMirrorFilterRuleAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result modifyTrafficMirrorSession(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise modifyTrafficMirrorSessionAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result modifyTransitGateway(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise modifyTransitGatewayAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result modifyTransitGatewayPrefixListReference(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise modifyTransitGatewayPrefixListReferenceAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result modifyTransitGatewayVpcAttachment(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise modifyTransitGatewayVpcAttachmentAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result modifyVolume(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise modifyVolumeAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result modifyVpcEndpointConnectionNotification(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise modifyVpcEndpointConnectionNotificationAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result modifyVpcEndpointServiceConfiguration(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise modifyVpcEndpointServiceConfigurationAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result modifyVpcEndpointServicePermissions(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise modifyVpcEndpointServicePermissionsAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result modifyVpcTenancy(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise modifyVpcTenancyAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result modifyVpnConnection(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise modifyVpnConnectionAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result modifyVpnTunnelCertificate(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise modifyVpnTunnelCertificateAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result modifyVpnTunnelOptions(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise modifyVpnTunnelOptionsAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result provisionByoipCidr(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise provisionByoipCidrAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result registerInstanceEventNotificationAttributes(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise registerInstanceEventNotificationAttributesAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result registerTransitGatewayMulticastGroupMembers(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise registerTransitGatewayMulticastGroupMembersAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result registerTransitGatewayMulticastGroupSources(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise registerTransitGatewayMulticastGroupSourcesAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result rejectTransitGatewayPeeringAttachment(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise rejectTransitGatewayPeeringAttachmentAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result rejectTransitGatewayVpcAttachment(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise rejectTransitGatewayVpcAttachmentAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result rejectVpcEndpointConnections(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise rejectVpcEndpointConnectionsAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result replaceIamInstanceProfileAssociation(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise replaceIamInstanceProfileAssociationAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result replaceTransitGatewayRoute(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise replaceTransitGatewayRouteAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result resetEbsDefaultKmsKeyId(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise resetEbsDefaultKmsKeyIdAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result resetFpgaImageAttribute(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise resetFpgaImageAttributeAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result restoreManagedPrefixListVersion(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise restoreManagedPrefixListVersionAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result revokeClientVpnIngress(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise revokeClientVpnIngressAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result searchLocalGatewayRoutes(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise searchLocalGatewayRoutesAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result searchTransitGatewayMulticastGroups(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise searchTransitGatewayMulticastGroupsAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result searchTransitGatewayRoutes(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise searchTransitGatewayRoutesAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result sendDiagnosticInterrupt(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise sendDiagnosticInterruptAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result startVpcEndpointServicePrivateDnsVerification(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise startVpcEndpointServicePrivateDnsVerificationAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result terminateClientVpnConnections(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise terminateClientVpnConnectionsAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result unassignIpv6Addresses(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise unassignIpv6AddressesAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result updateSecurityGroupRuleDescriptionsEgress(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise updateSecurityGroupRuleDescriptionsEgressAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result updateSecurityGroupRuleDescriptionsIngress(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise updateSecurityGroupRuleDescriptionsIngressAsync(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\Aws\Result withdrawByoipCidr(array $args = []) (supported in versions 2016-11-15)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise withdrawByoipCidrAsync(array $args = []) (supported in versions 2016-11-15)
 */
class Ec2Client extends AwsClient
{
    public function __construct(array $args)
    {
        $args['with_resolved'] = function (array $args) {
            $this->getHandlerList()->appendInit(
                PresignUrlMiddleware::wrap(
                    $this,
                    $args['endpoint_provider'],
                    [
                        'operations' => [
                            'CopySnapshot',
                        ],
                        'service' => 'ec2',
                        'presign_param' => 'PresignedUrl',
                    ]
                ),
                'ec2.copy_snapshot'
            );
        };

        parent::__construct($args);
    }

    /**
     * @internal
     * @codeCoverageIgnore
     */
    public static function applyDocFilters(array $api, array $docs)
    {
        // Several copy snapshot parameters are optional.
        $docs['shapes']['String']['refs']['CopySnapshotRequest$PresignedUrl']
            = '<div class="alert alert-info">The SDK will compute this value '
            . 'for you on your behalf.</div>';
        $docs['shapes']['String']['refs']['CopySnapshotRequest$DestinationRegion']
            = '<div class="alert alert-info">The SDK will populate this '
            . 'parameter on your behalf using the configured region value of '
            . 'the client.</div>';

        return [
            new Service($api, ApiProvider::defaultProvider()),
            new DocModel($docs)
        ];
    }
}
