<?php

namespace MediaCloud\Vendor\Aws\AppMesh;
use MediaCloud\Vendor\Aws\AwsClient;

/**
 * This client is used to interact with the **AWS App Mesh** service.
 * @method \MediaCloud\Vendor\Aws\Result createMesh(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createMeshAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createRoute(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createRouteAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createVirtualNode(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createVirtualNodeAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createVirtualRouter(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createVirtualRouterAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteMesh(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteMeshAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteRoute(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteRouteAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteVirtualNode(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteVirtualNodeAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteVirtualRouter(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteVirtualRouterAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeMesh(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeMeshAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeRoute(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeRouteAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeVirtualNode(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeVirtualNodeAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result describeVirtualRouter(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeVirtualRouterAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listMeshes(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listMeshesAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listRoutes(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listRoutesAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listVirtualNodes(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listVirtualNodesAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result listVirtualRouters(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listVirtualRoutersAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result updateRoute(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise updateRouteAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result updateVirtualNode(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise updateVirtualNodeAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result updateVirtualRouter(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise updateVirtualRouterAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createGatewayRoute(array $args = []) (supported in versions 2019-01-25)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createGatewayRouteAsync(array $args = []) (supported in versions 2019-01-25)
 * @method \MediaCloud\Vendor\Aws\Result createVirtualGateway(array $args = []) (supported in versions 2019-01-25)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createVirtualGatewayAsync(array $args = []) (supported in versions 2019-01-25)
 * @method \MediaCloud\Vendor\Aws\Result createVirtualService(array $args = []) (supported in versions 2019-01-25)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createVirtualServiceAsync(array $args = []) (supported in versions 2019-01-25)
 * @method \MediaCloud\Vendor\Aws\Result deleteGatewayRoute(array $args = []) (supported in versions 2019-01-25)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteGatewayRouteAsync(array $args = []) (supported in versions 2019-01-25)
 * @method \MediaCloud\Vendor\Aws\Result deleteVirtualGateway(array $args = []) (supported in versions 2019-01-25)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteVirtualGatewayAsync(array $args = []) (supported in versions 2019-01-25)
 * @method \MediaCloud\Vendor\Aws\Result deleteVirtualService(array $args = []) (supported in versions 2019-01-25)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteVirtualServiceAsync(array $args = []) (supported in versions 2019-01-25)
 * @method \MediaCloud\Vendor\Aws\Result describeGatewayRoute(array $args = []) (supported in versions 2019-01-25)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeGatewayRouteAsync(array $args = []) (supported in versions 2019-01-25)
 * @method \MediaCloud\Vendor\Aws\Result describeVirtualGateway(array $args = []) (supported in versions 2019-01-25)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeVirtualGatewayAsync(array $args = []) (supported in versions 2019-01-25)
 * @method \MediaCloud\Vendor\Aws\Result describeVirtualService(array $args = []) (supported in versions 2019-01-25)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise describeVirtualServiceAsync(array $args = []) (supported in versions 2019-01-25)
 * @method \MediaCloud\Vendor\Aws\Result listGatewayRoutes(array $args = []) (supported in versions 2019-01-25)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listGatewayRoutesAsync(array $args = []) (supported in versions 2019-01-25)
 * @method \MediaCloud\Vendor\Aws\Result listTagsForResource(array $args = []) (supported in versions 2019-01-25)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listTagsForResourceAsync(array $args = []) (supported in versions 2019-01-25)
 * @method \MediaCloud\Vendor\Aws\Result listVirtualGateways(array $args = []) (supported in versions 2019-01-25)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listVirtualGatewaysAsync(array $args = []) (supported in versions 2019-01-25)
 * @method \MediaCloud\Vendor\Aws\Result listVirtualServices(array $args = []) (supported in versions 2019-01-25)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise listVirtualServicesAsync(array $args = []) (supported in versions 2019-01-25)
 * @method \MediaCloud\Vendor\Aws\Result tagResource(array $args = []) (supported in versions 2019-01-25)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise tagResourceAsync(array $args = []) (supported in versions 2019-01-25)
 * @method \MediaCloud\Vendor\Aws\Result untagResource(array $args = []) (supported in versions 2019-01-25)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise untagResourceAsync(array $args = []) (supported in versions 2019-01-25)
 * @method \MediaCloud\Vendor\Aws\Result updateGatewayRoute(array $args = []) (supported in versions 2019-01-25)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise updateGatewayRouteAsync(array $args = []) (supported in versions 2019-01-25)
 * @method \MediaCloud\Vendor\Aws\Result updateMesh(array $args = []) (supported in versions 2019-01-25)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise updateMeshAsync(array $args = []) (supported in versions 2019-01-25)
 * @method \MediaCloud\Vendor\Aws\Result updateVirtualGateway(array $args = []) (supported in versions 2019-01-25)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise updateVirtualGatewayAsync(array $args = []) (supported in versions 2019-01-25)
 * @method \MediaCloud\Vendor\Aws\Result updateVirtualService(array $args = []) (supported in versions 2019-01-25)
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise updateVirtualServiceAsync(array $args = []) (supported in versions 2019-01-25)
 */
class AppMeshClient extends AwsClient {}
