<?php

namespace MediaCloud\Vendor\Aws\ApiGateway;
use MediaCloud\Vendor\Aws\AwsClient;
use MediaCloud\Vendor\Aws\CommandInterface;
use MediaCloud\Vendor\Psr\Http\Message\RequestInterface;

/**
 * This client is used to interact with the **AWS API Gateway** service.
 *
 * @method \MediaCloud\Vendor\Aws\Result createApiKey(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createApiKeyAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createAuthorizer(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createAuthorizerAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createBasePathMapping(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createBasePathMappingAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createDeployment(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createDeploymentAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createDocumentationPart(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createDocumentationPartAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createDocumentationVersion(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createDocumentationVersionAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createDomainName(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createDomainNameAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createModel(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createModelAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createRequestValidator(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createRequestValidatorAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createResource(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createResourceAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createRestApi(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createRestApiAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createStage(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createStageAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createUsagePlan(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createUsagePlanAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createUsagePlanKey(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createUsagePlanKeyAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result createVpcLink(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise createVpcLinkAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteApiKey(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteApiKeyAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteAuthorizer(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteAuthorizerAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteBasePathMapping(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteBasePathMappingAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteClientCertificate(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteClientCertificateAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteDeployment(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteDeploymentAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteDocumentationPart(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteDocumentationPartAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteDocumentationVersion(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteDocumentationVersionAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteDomainName(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteDomainNameAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteGatewayResponse(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteGatewayResponseAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteIntegration(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteIntegrationAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteIntegrationResponse(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteIntegrationResponseAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteMethod(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteMethodAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteMethodResponse(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteMethodResponseAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteModel(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteModelAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteRequestValidator(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteRequestValidatorAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteResource(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteResourceAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteRestApi(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteRestApiAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteStage(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteStageAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteUsagePlan(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteUsagePlanAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteUsagePlanKey(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteUsagePlanKeyAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result deleteVpcLink(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise deleteVpcLinkAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result flushStageAuthorizersCache(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise flushStageAuthorizersCacheAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result flushStageCache(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise flushStageCacheAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result generateClientCertificate(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise generateClientCertificateAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result getAccount(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise getAccountAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result getApiKey(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise getApiKeyAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result getApiKeys(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise getApiKeysAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result getAuthorizer(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise getAuthorizerAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result getAuthorizers(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise getAuthorizersAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result getBasePathMapping(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise getBasePathMappingAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result getBasePathMappings(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise getBasePathMappingsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result getClientCertificate(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise getClientCertificateAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result getClientCertificates(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise getClientCertificatesAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result getDeployment(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise getDeploymentAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result getDeployments(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise getDeploymentsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result getDocumentationPart(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise getDocumentationPartAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result getDocumentationParts(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise getDocumentationPartsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result getDocumentationVersion(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise getDocumentationVersionAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result getDocumentationVersions(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise getDocumentationVersionsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result getDomainName(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise getDomainNameAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result getDomainNames(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise getDomainNamesAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result getExport(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise getExportAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result getGatewayResponse(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise getGatewayResponseAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result getGatewayResponses(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise getGatewayResponsesAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result getIntegration(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise getIntegrationAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result getIntegrationResponse(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise getIntegrationResponseAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result getMethod(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise getMethodAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result getMethodResponse(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise getMethodResponseAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result getModel(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise getModelAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result getModelTemplate(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise getModelTemplateAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result getModels(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise getModelsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result getRequestValidator(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise getRequestValidatorAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result getRequestValidators(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise getRequestValidatorsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result getResource(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise getResourceAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result getResources(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise getResourcesAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result getRestApi(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise getRestApiAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result getRestApis(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise getRestApisAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result getSdk(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise getSdkAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result getSdkType(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise getSdkTypeAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result getSdkTypes(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise getSdkTypesAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result getStage(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise getStageAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result getStages(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise getStagesAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result getTags(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise getTagsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result getUsage(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise getUsageAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result getUsagePlan(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise getUsagePlanAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result getUsagePlanKey(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise getUsagePlanKeyAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result getUsagePlanKeys(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise getUsagePlanKeysAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result getUsagePlans(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise getUsagePlansAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result getVpcLink(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise getVpcLinkAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result getVpcLinks(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise getVpcLinksAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result importApiKeys(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise importApiKeysAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result importDocumentationParts(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise importDocumentationPartsAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result importRestApi(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise importRestApiAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result putGatewayResponse(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise putGatewayResponseAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result putIntegration(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise putIntegrationAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result putIntegrationResponse(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise putIntegrationResponseAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result putMethod(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise putMethodAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result putMethodResponse(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise putMethodResponseAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result putRestApi(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise putRestApiAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result tagResource(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise tagResourceAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result testInvokeAuthorizer(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise testInvokeAuthorizerAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result testInvokeMethod(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise testInvokeMethodAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result untagResource(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise untagResourceAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result updateAccount(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise updateAccountAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result updateApiKey(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise updateApiKeyAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result updateAuthorizer(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise updateAuthorizerAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result updateBasePathMapping(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise updateBasePathMappingAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result updateClientCertificate(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise updateClientCertificateAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result updateDeployment(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise updateDeploymentAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result updateDocumentationPart(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise updateDocumentationPartAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result updateDocumentationVersion(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise updateDocumentationVersionAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result updateDomainName(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise updateDomainNameAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result updateGatewayResponse(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise updateGatewayResponseAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result updateIntegration(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise updateIntegrationAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result updateIntegrationResponse(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise updateIntegrationResponseAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result updateMethod(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise updateMethodAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result updateMethodResponse(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise updateMethodResponseAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result updateModel(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise updateModelAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result updateRequestValidator(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise updateRequestValidatorAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result updateResource(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise updateResourceAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result updateRestApi(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise updateRestApiAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result updateStage(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise updateStageAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result updateUsage(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise updateUsageAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result updateUsagePlan(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise updateUsagePlanAsync(array $args = [])
 * @method \MediaCloud\Vendor\Aws\Result updateVpcLink(array $args = [])
 * @method \MediaCloud\Vendor\GuzzleHttp\Promise\Promise updateVpcLinkAsync(array $args = [])
 */
class ApiGatewayClient extends AwsClient
{
    public function __construct(array $args)
    {
        parent::__construct($args);
        $stack = $this->getHandlerList();
        $stack->appendBuild([__CLASS__, '_add_accept_header']);
    }

    public static function _add_accept_header(callable $handler)
    {
        return function (
            CommandInterface $command,
            RequestInterface $request
        ) use ($handler) {
            $request = $request->withHeader('Accept', 'application/json');

            return $handler($command, $request);
        };
    }
}
