<?php

// Copyright (c) 2016 Interfacelab LLC. All rights reserved.
//
// Released under the GPLv3 license
// http://www.gnu.org/licenses/gpl-3.0.html
//
// **********************************************************************
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// **********************************************************************

namespace MediaCloud\Plugin\Tools\Video\Driver\Mux;

/**
 * Class MuxToolSettings
 * @package MediaCloud\Mux
 *
 * @property bool secureVideo
 * @property int secureVideoExpiration
 * @property int secureThumbnailExpiration
 * @property int secureGifExpiration
 * @property int secureKeyRotation
 * @property string playerType
 * @property bool playerAllowAirPlay
 * @property bool playerAllowQualitySelect
 * @property bool playerOverrideNative
 * @property bool playerFilmstrips
 * @property bool playerMP4Fallback
 * @property bool playerAllowDownload
 * @property bool playerAllowOriginalDownload
 * @property string playerMP4Quality
 * @property string playerAnalyticsMode
 * @property bool watermarkEnabled
 * @property int watermarkImageId
 * @property-read string watermarkImageUrl
 * @property int watermarkWidth
 * @property string watermarkVerticalAlign
 * @property int watermarkVerticalMargin
 * @property string watermarkHorizontalAlign
 * @property int watermarkHorizontalMargin
 * @property int watermarkOpacity
 */
class MuxToolProSettings extends MuxToolSettings {
	/**
	 * Map of property names to setting names
	 * @var string[]
	 */
	protected $proSettingsMap = [
		'envKey' => ['media-cloud-mux-env-key', null, null],
		'secureVideo' => ['media-cloud-mux-secure-video', null, false],
		'secureVideoExpiration' => ['media-cloud-mux-secure-video-expiration', null, 0],
		'secureThumbnail' => ['media-cloud-mux-secure-thumbnail', null, false],
		'secureThumbnailExpiration' => ['media-cloud-mux-secure-thumbnail-expiration', null, 0],
		'secureGif' => ['media-cloud-mux-secure-gif', null, false],
		'secureGifExpiration' => ['media-cloud-mux-secure-gif-expiration', null, 0],
		'secureKeyRotation' => ['media-cloud-mux-secure-key-rotation', null, 24],
		'playerType' => ['media-cloud-mux-player', null, 'videojs'],
		'playerAllowAirPlay' => ['media-cloud-mux-player-air-play', null, true],
		'playerAllowQualitySelect' => ['media-cloud-mux-player-quality-select', null, true],
		'playerOverrideNative' => ['media-cloud-mux-player-override-native', null, true],
		'playerFilmstrips' => ['media-cloud-mux-player-filmstrips', null, true],
		'playerMP4Fallback' => ['media-cloud-mux-player-mp4-fallback', null, true],
		'playerMP4Quality' => ['media-cloud-mux-player-mp4-preferred-quality', null, "medium.mp4"],
		'playerAnalyticsMode' => ['media-cloud-mux-player-analytics-mode', null, "none"],
		'playerAllowDownload' => ['media-cloud-mux-player-allow-download', null, true],
		'playerAllowOriginalDownload' => ['media-cloud-mux-player-allow-download-original', null, true],
		'watermarkEnabled' => ['media-cloud-mux-watermark-enabled', null, false],
		'watermarkImageId' => ['media-cloud-mux-watermark-image', null, null],
		'watermarkWidth' => ['media-cloud-mux-watermark-width', null, 0],
		'watermarkVerticalAlign' => ['media-cloud-mux-watermark-vertical-align', null, 'middle'],
		'watermarkVerticalMargin' => ['media-cloud-mux-watermark-vertical-margin', null, 0],
		'watermarkHorizontalAlign' => ['media-cloud-mux-watermark-horizontal-align', null, 'center'],
		'watermarkHorizontalMargin' => ['media-cloud-mux-watermark-horizontal-margin', null, 0],
		'watermarkOpacity' => ['media-cloud-mux-watermark-opacity', null, 100],
	];

	public function __construct() {
		$this->settingsMap = array_merge($this->settingsMap, $this->proSettingsMap);
	}

	public function __get($name) {
		if ($name === 'watermarkImageUrl') {
			$imageId = $this->watermarkImageId;
			if (!empty($imageId)) {
				$imageSrc = wp_get_attachment_image_src($imageId, 'full');
				if (!empty($imageSrc)) {
					return $imageSrc[0];
				}
			}

			return null;
		}

		return parent::__get($name); // TODO: Change the autogenerated stub
	}

	public function __isset($name) {
		if (in_array($name, ['watermarkImageUrl'])) {
			return true;
		}

		return parent::__isset($name);
	}
}